package com.palladiosimulator.textual.repository.naming;

import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.palladiosimulator.pcm.repository.CollectionDataType;
import org.palladiosimulator.pcm.repository.CompositeDataType;
import org.palladiosimulator.pcm.repository.PrimitiveDataType;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.resourcetype.ResourceType;

@SuppressWarnings("all")
public class RepositoryNameProvider extends DefaultDeclarativeQualifiedNameProvider {
  public QualifiedName qualifiedName(final ResourceType r) {
    return QualifiedName.create(r.getEntityName());
  }

  public QualifiedName qualifiedName(final Repository r) {
    return QualifiedName.create(r.getEntityName());
  }

  public QualifiedName qualifiedName(final PrimitiveDataType d) {
    return QualifiedName.create(d.getType().name());
  }

  public QualifiedName qualifiedName(final CollectionDataType d) {
    return QualifiedName.create(d.getEntityName());
  }

  public QualifiedName qualifiedName(final CompositeDataType d) {
    return QualifiedName.create(d.getEntityName());
  }
}
