package com.palladiosimulator.textual.repository.scoping;

import java.net.URL;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

@SuppressWarnings("all")
public class StandaloneRepoLangImportURIGlobalScopeProvider extends RepoLangImportURIGlobalScopeProvider {
  private static final String[][] mappings = { new String[] { "pathmap://PCM_MODELS/Palladio.resourcetype", "Palladio.resourcetype" }, new String[] { "pathmap://PCM_MODELS/PrimitiveTypes.repository", "PrimitiveTypes.repository" } };

  @Override
  public Object registerUriMappings(final Resource resource) {
    final Map<URI, URI> uriMap = resource.getResourceSet().getURIConverter().getURIMap();
    for (final String[] mapping : StandaloneRepoLangImportURIGlobalScopeProvider.mappings) {
      boolean _containsKey = uriMap.containsKey(mapping[0]);
      boolean _not = (!_containsKey);
      if (_not) {
        final ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL _resource = cl.getResource(mapping[1]);
        String _string = null;
        if (_resource!=null) {
          _string=_resource.toString();
        }
        final String url = _string;
        uriMap.put(URI.createURI(mapping[0]), URI.createURI(url));
      }
    }
    return null;
  }
}
