package org.palladiosimulator.textual.commons.generator.eclipse;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.builder.BuilderParticipant;
import org.eclipse.xtext.builder.EclipseResourceFileSystemAccess2;
import org.eclipse.xtext.builder.IXtextBuilderParticipant;
import org.eclipse.xtext.generator.GeneratorContext;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.palladiosimulator.textual.commons.generator.MultiSourceGenerator;

@SuppressWarnings("all")
public class CustomBuilderParticipant extends BuilderParticipant {
  @Inject
  private ResourceDescriptionsProvider resourceDescriptionsProvider;

  @Inject
  private IContainer.Manager containerManager;

  @Inject(optional = true)
  private MultiSourceGenerator generator;

  protected ThreadLocal<Boolean> buildSemaphor = new ThreadLocal<Boolean>();

  @Override
  public void build(final IXtextBuilderParticipant.IBuildContext context, final IProgressMonitor monitor) throws CoreException {
    this.buildSemaphor.set(Boolean.valueOf(false));
    super.build(context, monitor);
  }

  @Override
  public void handleChangedContents(final IResourceDescription.Delta delta, final IXtextBuilderParticipant.IBuildContext context, final IFileSystemAccess fileSystemAccess) {
    try {
      if (((!(this.buildSemaphor.get()).booleanValue()) && (this.generator != null))) {
        this.invokeGenerator(delta, context, fileSystemAccess);
      } else {
        super.handleChangedContents(delta, context, fileSystemAccess);
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }

  @Override
  protected void handleChangedContents(final IResourceDescription.Delta delta, final IXtextBuilderParticipant.IBuildContext context, final EclipseResourceFileSystemAccess2 fileSystemAccess) throws CoreException {
    if (((!(this.buildSemaphor.get()).booleanValue()) && (this.generator != null))) {
      this.invokeGenerator(delta, context, fileSystemAccess);
    } else {
      super.handleChangedContents(delta, context, fileSystemAccess);
    }
  }

  public IResourceDescription.Delta invokeGenerator(final IResourceDescription.Delta delta, final IXtextBuilderParticipant.IBuildContext context, final IFileSystemAccess fileSystemAccess) {
    this.buildSemaphor.set(Boolean.valueOf(true));
    GeneratorContext generatorContext = new GeneratorContext();
    generatorContext.setCancelIndicator(CancelIndicator.NullImpl);
    Resource resource = context.getResourceSet().getResource(delta.getUri(), true);
    boolean _shouldGenerate = this.shouldGenerate(resource, context);
    if (_shouldGenerate) {
      IResourceDescriptions index = this.resourceDescriptionsProvider.createResourceDescriptions();
      IResourceDescription resDesc = index.getResourceDescription(resource.getURI());
      List<IContainer> visibleContainers = this.containerManager.getVisibleContainers(resDesc, index);
      for (final IContainer c : visibleContainers) {
        Iterable<IResourceDescription> _resourceDescriptions = c.getResourceDescriptions();
        for (final IResourceDescription rd : _resourceDescriptions) {
          context.getResourceSet().getResource(rd.getURI(), true);
        }
      }
      ResourceSet resourceSet = context.getResourceSet();
      this.generator.doGenerate(resourceSet, ((EclipseResourceFileSystemAccess2) fileSystemAccess), generatorContext);
    }
    return delta;
  }
}
