/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.textual.commons.generator.eclipse;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.builder.BuilderParticipant;
import org.eclipse.xtext.builder.EclipseResourceFileSystemAccess2;
import org.eclipse.xtext.builder.IXtextBuilderParticipant;
import org.eclipse.xtext.generator.GeneratorContext;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.palladiosimulator.textual.commons.generator.MultiSourceGenerator;

public class CustomBuilderParticipant
extends BuilderParticipant {
    @Inject
    private ResourceDescriptionsProvider resourceDescriptionsProvider;
    @Inject
    private IContainer.Manager containerManager;
    @Inject(optional=true)
    private MultiSourceGenerator generator;
    protected ThreadLocal<Boolean> buildSemaphor = new ThreadLocal();

    public void build(IXtextBuilderParticipant.IBuildContext context, IProgressMonitor monitor) throws CoreException {
        this.buildSemaphor.set(false);
        super.build(context, monitor);
    }

    public void handleChangedContents(IResourceDescription.Delta delta, IXtextBuilderParticipant.IBuildContext context, IFileSystemAccess fileSystemAccess) {
        try {
            if (!this.buildSemaphor.get().booleanValue() && this.generator != null) {
                this.invokeGenerator(delta, context, fileSystemAccess);
            } else {
                super.handleChangedContents(delta, context, fileSystemAccess);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void handleChangedContents(IResourceDescription.Delta delta, IXtextBuilderParticipant.IBuildContext context, EclipseResourceFileSystemAccess2 fileSystemAccess) throws CoreException {
        if (!this.buildSemaphor.get().booleanValue() && this.generator != null) {
            this.invokeGenerator(delta, context, (IFileSystemAccess)fileSystemAccess);
        } else {
            super.handleChangedContents(delta, context, fileSystemAccess);
        }
    }

    public IResourceDescription.Delta invokeGenerator(IResourceDescription.Delta delta, IXtextBuilderParticipant.IBuildContext context, IFileSystemAccess fileSystemAccess) {
        this.buildSemaphor.set(true);
        GeneratorContext generatorContext = new GeneratorContext();
        generatorContext.setCancelIndicator(CancelIndicator.NullImpl);
        Resource resource = context.getResourceSet().getResource(delta.getUri(), true);
        boolean _shouldGenerate = this.shouldGenerate(resource, context);
        if (_shouldGenerate) {
            IResourceDescriptions index = this.resourceDescriptionsProvider.createResourceDescriptions();
            IResourceDescription resDesc = index.getResourceDescription(resource.getURI());
            List visibleContainers = this.containerManager.getVisibleContainers(resDesc, index);
            for (IContainer c : visibleContainers) {
                Iterable _resourceDescriptions = c.getResourceDescriptions();
                for (IResourceDescription rd : _resourceDescriptions) {
                    context.getResourceSet().getResource(rd.getURI(), true);
                }
            }
            ResourceSet resourceSet = context.getResourceSet();
            this.generator.doGenerate(resourceSet, (IFileSystemAccess2)((EclipseResourceFileSystemAccess2)fileSystemAccess), (IGeneratorContext)generatorContext);
        }
        return delta;
    }
}

