package org.palladiosimulator.textual.commons.generator.impl;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.palladiosimulator.textual.commons.generator.GenerationFileNameProvider;
import org.palladiosimulator.textual.commons.generator.ModelFileExtensionRegistry;

@SuppressWarnings("all")
public class GenerationFileNameProviderImpl implements GenerationFileNameProvider {
  private static final String FILE_EXTENSION_SEPARATOR = ".";

  private static final String SOURCE_NAME_SEPARATOR = "_";

  @Inject
  private IQualifiedNameProvider nameProvider;

  @Inject
  private ModelFileExtensionRegistry extensionRegistry;

  /**
   * val typeDefinitions = new ArrayList<TypeNameDefinition>();
   * 
   * new() {
   * typeDefinitions.add(new TypeNameDefinition(Repository, "repository"))
   * typeDefinitions.add(new TypeNameDefinition(org.palladiosimulator.textual.tpcm.language.System, "system"))
   * typeDefinitions.add(new TypeNameDefinition(Allocation, "allocation"))
   * typeDefinitions.add(new TypeNameDefinition(ResourceEnvironment, "resourceenvironment"))
   * typeDefinitions.add(new TypeNameDefinition(ResourceTypeRepository, "resourcetyperepository"))
   * typeDefinitions.add(new TypeNameDefinition(Usage, "usagemodel"))
   * }
   */
  @Override
  public String generateFileNameFor(final EObject resource, final String originalFileName) {
    String _xblockexpression = null;
    {
      final QualifiedName name = this.nameProvider.getFullyQualifiedName(resource);
      Comparable<?> _xifexpression = null;
      if (((name == null) || name.isEmpty())) {
        _xifexpression = resource.eClass().getName();
      } else {
        _xifexpression = name;
      }
      final Comparable<?> finalName = _xifexpression;
      StringConcatenation _builder = new StringConcatenation();
      _builder.append(finalName);
      _builder.append(GenerationFileNameProviderImpl.SOURCE_NAME_SEPARATOR);
      _builder.append(originalFileName);
      _builder.append(GenerationFileNameProviderImpl.FILE_EXTENSION_SEPARATOR);
      String _modelFileExtension = this.extensionRegistry.getModelFileExtension(resource);
      _builder.append(_modelFileExtension);
      _xblockexpression = _builder.toString();
    }
    return _xblockexpression;
  }
}
