package org.palladiosimulator.textual.commons.generator.registry.impl;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.palladiosimulator.textual.commons.generator.registry.ChildPropertyMapping;
import org.palladiosimulator.textual.commons.generator.registry.GeneratorTransformationRegistry;

@SuppressWarnings("all")
public class ListValueChildPropertyApplier<S extends Object, T extends Object, OS extends Object, OT extends Object> implements ChildPropertyMapping<OS, OT> {
  private final Function<OS, ? extends List<S>> provider;

  private final BiConsumer<OT, List<T>> applier;

  private final Class<T> requiredType;

  public ListValueChildPropertyApplier(final Function<OS, ? extends List<S>> provider, final Class<T> type, final BiConsumer<OT, List<T>> applier) {
    this.provider = provider;
    this.applier = applier;
    this.requiredType = type;
  }

  @Override
  public void run(final OS element, final OT mappedParent, final GeneratorTransformationRegistry registry) {
    final List<S> providedObject = this.provider.apply(element);
    final Function1<S, T> _function = (S it) -> {
      return registry.<S, T>map(it, this.requiredType);
    };
    final List<T> mappedObject = ListExtensions.<S, T>map(providedObject, _function);
    this.applier.accept(mappedParent, mappedObject);
  }
}
