package org.palladiosimulator.textual.commons.generator.registry.impl;

import java.util.function.BiConsumer;
import java.util.function.Function;
import org.palladiosimulator.textual.commons.generator.registry.ChildPropertyMapping;
import org.palladiosimulator.textual.commons.generator.registry.GeneratorTransformationRegistry;

@SuppressWarnings("all")
public class SingleValueChildPropertyApplier<S extends Object, T extends Object, OS extends Object, OT extends Object> implements ChildPropertyMapping<OS, OT> {
  private final Function<OS, S> provider;

  private final BiConsumer<OT, T> applier;

  private final Class<T> requiredType;

  public SingleValueChildPropertyApplier(final Function<OS, S> provider, final Class<T> target, final BiConsumer<OT, T> applier) {
    this.provider = provider;
    this.applier = applier;
    this.requiredType = target;
  }

  @Override
  public void run(final OS element, final OT mappedParent, final GeneratorTransformationRegistry registry) {
    final S providedObject = this.provider.apply(element);
    T _xifexpression = null;
    if ((providedObject != null)) {
      _xifexpression = registry.<S, T>map(providedObject, this.requiredType);
    } else {
      _xifexpression = null;
    }
    final T mappedObject = _xifexpression;
    if ((mappedObject != null)) {
      this.applier.accept(mappedParent, mappedObject);
    }
  }
}
