package org.palladiosimulator.textual.commons.generator.rules.impl;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.palladiosimulator.textual.commons.generator.registry.impl.ListValueChildPropertyApplier;
import org.palladiosimulator.textual.commons.generator.rules.ValueApplierRule;

@SuppressWarnings("all")
public class ListValueApplierRule<S extends Object, T extends Object, OS extends Object, OT extends Object> implements ValueApplierRule<List<T>, OT> {
  private final Function<OS, ? extends List<S>> provider;

  private final Registration<OS, OT> registration;

  private final Class<T> specifiedTarget;

  public ListValueApplierRule(final Function<OS, ? extends List<S>> targetType, final Registration<OS, OT> regi) {
    this(targetType, null, regi);
  }

  public ListValueApplierRule(final Function<OS, ? extends List<S>> targetType, final Class<T> target, final Registration<OS, OT> regi) {
    this.provider = targetType;
    this.specifiedTarget = target;
    this.registration = regi;
  }

  @Override
  public void thenSet(final BiConsumer<OT, List<T>> apply) {
    ListValueChildPropertyApplier<S, T, OS, OT> _listValueChildPropertyApplier = new ListValueChildPropertyApplier<S, T, OS, OT>(this.provider, this.specifiedTarget, apply);
    this.registration.addPropertyMapping(_listValueChildPropertyApplier);
  }
}
