package org.palladiosimulator.textual.commons.generator.rules.impl;

import java.util.function.BiConsumer;
import java.util.function.Function;
import org.palladiosimulator.textual.commons.generator.registry.impl.SingleValueChildPropertyApplier;
import org.palladiosimulator.textual.commons.generator.rules.ValueApplierRule;

@SuppressWarnings("all")
public class SingleValueApplierRule<S extends Object, T extends Object, OS extends Object, OT extends Object> implements ValueApplierRule<T, OT> {
  private final Function<OS, S> applier;

  private final Registration<OS, OT> registration;

  private final Class<T> specifiedTarget;

  public SingleValueApplierRule(final Function<OS, S> setterOnTarget, final Registration<OS, OT> regi) {
    this(setterOnTarget, null, regi);
  }

  public SingleValueApplierRule(final Function<OS, S> setterOnTarget, final Class<T> target, final Registration<OS, OT> regi) {
    this.applier = setterOnTarget;
    this.specifiedTarget = target;
    this.registration = regi;
  }

  @Override
  public void thenSet(final BiConsumer<OT, T> apply) {
    SingleValueChildPropertyApplier<S, T, OS, OT> _singleValueChildPropertyApplier = new SingleValueChildPropertyApplier<S, T, OS, OT>(this.applier, this.specifiedTarget, apply);
    this.registration.addPropertyMapping(_singleValueChildPropertyApplier);
  }
}
