/**
 * generated by Xtext 2.21.0
 */
package org.palladiosimulator.textual.commons.generator.impl;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function0;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.palladiosimulator.textual.commons.generator.GenerationFileNameProvider;
import org.palladiosimulator.textual.commons.generator.MultiModelGeneratorFragment;
import org.palladiosimulator.textual.commons.generator.registry.GeneratorTransformationRegistry;
import org.palladiosimulator.textual.commons.generator.registry.ProvidedMapping;
import org.palladiosimulator.textual.commons.generator.registry.RegisteredMappingProvider;
import org.palladiosimulator.textual.commons.generator.registry.RootElementFilter;

/**
 * Generates code from your model files on save.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#code-generation
 */
@SuppressWarnings("all")
public class ExtensibleMultiModelGenerator extends AbstractMultiSourceGenerator {
  public static class MappingInformation {
    public final EObject mappedValue;

    public final String fileName;

    public MappingInformation(final EObject mappedValue, final String filename) {
      this.mappedValue = mappedValue;
      this.fileName = filename;
    }
  }

  @Inject
  private GenerationFileNameProvider filenameProvider;

  @Inject
  @Named(MultiModelGeneratorFragment.NAMED_DELEGATE)
  private RegisteredMappingProvider mappingProvider;

  @Inject
  @Named(MultiModelGeneratorFragment.NAMED_DELEGATE)
  private RootElementFilter elementFilter;

  @Inject
  private GeneratorTransformationRegistry registry;

  @Override
  public void doGenerate(final ResourceSet resources, final IFileSystemAccess2 fsa, final IGeneratorContext context) {
    Collection<ProvidedMapping> allMappings = this.mappingProvider.retrieveMappings(resources);
    final ResourceSetImpl outputResources = new ResourceSetImpl();
    final Runnable _function = () -> {
      final ArrayList<Pair<String, Resource>> createdResources = new ArrayList<Pair<String, Resource>>();
      EList<Resource> _resources = resources.getResources();
      for (final Resource resource : _resources) {
        {
          final Function1<EObject, Boolean> _function_1 = (EObject it) -> {
            return Boolean.valueOf(this.elementFilter.translatesToRootElement(it));
          };
          final Iterator<EObject> fragments = IteratorExtensions.<EObject>filter(resource.getAllContents(), _function_1);
          final String sourceFileName = this.getSourceFileName(resource);
          final Function1<EObject, ExtensibleMultiModelGenerator.MappingInformation> _function_2 = (EObject it) -> {
            ExtensibleMultiModelGenerator.MappingInformation _xblockexpression = null;
            {
              final String filename = this.filenameProvider.generateFileNameFor(it, sourceFileName);
              Object _map = this.registry.<EObject, Object>map(it);
              final EObject mapped = ((EObject) _map);
              _xblockexpression = new ExtensibleMultiModelGenerator.MappingInformation(mapped, filename);
            }
            return _xblockexpression;
          };
          List<ExtensibleMultiModelGenerator.MappingInformation> _list = IteratorExtensions.<ExtensibleMultiModelGenerator.MappingInformation>toList(IteratorExtensions.<EObject, ExtensibleMultiModelGenerator.MappingInformation>map(fragments, _function_2));
          final ArrayList<ExtensibleMultiModelGenerator.MappingInformation> mappedFragments = new ArrayList<ExtensibleMultiModelGenerator.MappingInformation>(_list);
          final Function1<ExtensibleMultiModelGenerator.MappingInformation, Pair<String, Resource>> _function_3 = (ExtensibleMultiModelGenerator.MappingInformation it) -> {
            Resource _createResource = this.createResource(outputResources, it.mappedValue, it.fileName, fsa, context);
            return Pair.<String, Resource>of(it.fileName, _createResource);
          };
          createdResources.addAll(IterableExtensions.<Pair<String, Resource>>toList(ListExtensions.<ExtensibleMultiModelGenerator.MappingInformation, Pair<String, Resource>>map(mappedFragments, _function_3)));
        }
      }
      final Consumer<Pair<String, Resource>> _function_1 = (Pair<String, Resource> mapping) -> {
        try {
          final ByteArrayOutputStream output = new ByteArrayOutputStream();
          mapping.getValue().save(output, new Function0<Map<?, ?>>() {
            @Override
            public Map<?, ?> apply() {
              return null;
            }
          }.apply());
          byte[] _byteArray = output.toByteArray();
          ByteArrayInputStream _byteArrayInputStream = new ByteArrayInputStream(_byteArray);
          fsa.generateFile(mapping.getKey(), _byteArrayInputStream);
        } catch (Throwable _e) {
          throw Exceptions.sneakyThrow(_e);
        }
      };
      createdResources.forEach(_function_1);
    };
    this.registry.withContext(allMappings, _function);
  }

  private String getSourceFileName(final Resource resource) {
    final String fileNameWithExtension = resource.getURI().lastSegment();
    final int extensionDotIndex = fileNameWithExtension.lastIndexOf(".");
    return fileNameWithExtension.substring(0, extensionDotIndex);
  }

  public Resource createResource(final ResourceSet containerSet, final EObject resource, final String fileName, final IFileSystemAccess2 fsa, final IGeneratorContext context) {
    final URI targetFile = fsa.getURI(fileName);
    final Resource targetResource = containerSet.createResource(targetFile);
    targetResource.getContents().add(resource);
    return targetResource;
  }
}
