package org.palladiosimulator.textual.commons.generator.registry.impl;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.palladiosimulator.textual.commons.generator.MultiModelGeneratorFragment;
import org.palladiosimulator.textual.commons.generator.MultiModelGeneratorFragmentCollector;
import org.palladiosimulator.textual.commons.generator.registry.GeneratorRuleRegistrationFacade;
import org.palladiosimulator.textual.commons.generator.registry.GeneratorRulesRegistrationDelegate;
import org.palladiosimulator.textual.commons.generator.registry.GeneratorTransformationRegistry;
import org.palladiosimulator.textual.commons.generator.registry.ProvidedMapping;
import org.palladiosimulator.textual.commons.generator.rules.ExecutableRule;
import org.palladiosimulator.textual.commons.generator.rules.GeneratorRuleBuilder;
import org.palladiosimulator.textual.commons.generator.rules.impl.GeneratorRuleBuilderImpl;
import org.palladiosimulator.textual.commons.generator.rules.impl.Registration;

@SuppressWarnings("all")
public class GeneratorTransformationRegistryImpl implements GeneratorTransformationRegistry, GeneratorRuleRegistrationFacade {
  /**
   * Defines a key that identifies a mapped object. This key contains the source object id
   * as well as the type it was mapped to. Thus, if an object is mapped to two or more
   * different types, this uniquely identifies the mapped objects by that target type.
   */
  private static class MappedObjectKey {
    private final Class<?> targetType;

    private final int objectId;

    public MappedObjectKey(final Class<?> targetType, final int id) {
      this.targetType = targetType;
      this.objectId = id;
    }

    @Override
    public boolean equals(final Object other) {
      if ((!(other instanceof GeneratorTransformationRegistryImpl.MappedObjectKey))) {
        return false;
      }
      final GeneratorTransformationRegistryImpl.MappedObjectKey otherKey = ((GeneratorTransformationRegistryImpl.MappedObjectKey) other);
      boolean _and = false;
      if (!(otherKey.objectId == this.objectId)) {
        _and = false;
      } else {
        boolean _xifexpression = false;
        if ((this.targetType != null)) {
          _xifexpression = Objects.equal(this.targetType, otherKey.targetType);
        } else {
          _xifexpression = (otherKey.targetType == null);
        }
        _and = _xifexpression;
      }
      return _and;
    }

    @Override
    public int hashCode() {
      return java.util.Objects.hash(this.targetType, Integer.valueOf(this.objectId));
    }
  }

  private final List<ExecutableRule<?, ?>> rules = new ArrayList<ExecutableRule<?, ?>>();

  private final Map<GeneratorTransformationRegistryImpl.MappedObjectKey, Object> mappedObjects = new HashMap<GeneratorTransformationRegistryImpl.MappedObjectKey, Object>();

  @Inject
  public GeneratorTransformationRegistryImpl(final MultiModelGeneratorFragmentCollector providerCollector) {
    final Function1<MultiModelGeneratorFragment, GeneratorRulesRegistrationDelegate> _function = (MultiModelGeneratorFragment it) -> {
      return it.getRulesRegistrationDelegate();
    };
    final Consumer<GeneratorRulesRegistrationDelegate> _function_1 = (GeneratorRulesRegistrationDelegate it) -> {
      it.doRegistration(this);
    };
    IterableExtensions.<MultiModelGeneratorFragment, GeneratorRulesRegistrationDelegate>map(providerCollector.getGeneratorFragments(), _function).forEach(_function_1);
  }

  @Override
  public Object map(final Object source) {
    return this.<Object, Object>map(source, null);
  }

  @Override
  public void withContext(final Runnable runnable) {
    ArrayList<ProvidedMapping> _arrayList = new ArrayList<ProvidedMapping>();
    this.withContext(_arrayList, runnable);
  }

  @Override
  public void withContext(final Collection<ProvidedMapping> provided, final Runnable runnable) {
    this.mappedObjects.clear();
    final Consumer<ProvidedMapping> _function = (ProvidedMapping it) -> {
      final int referenceId = System.identityHashCode(it.getSourceObject());
      Class<?> _get = it.getTargetObject().getClass().getInterfaces()[0];
      final GeneratorTransformationRegistryImpl.MappedObjectKey key = new GeneratorTransformationRegistryImpl.MappedObjectKey(_get, referenceId);
      this.mappedObjects.put(key, it.getTargetObject());
    };
    provided.forEach(_function);
    runnable.run();
    this.mappedObjects.clear();
  }

  @Override
  public <S extends Object, T extends Object> void configure(final Class<S> source, final Class<T> target, final Consumer<GeneratorRuleBuilder<S, T>> mapping) {
    final GeneratorRuleBuilderImpl<S, T> builder = new GeneratorRuleBuilderImpl<S, T>(source, target);
    mapping.accept(builder);
    final ExecutableRule<S, T> rule = builder.build();
    final Function1<ExecutableRule<?, ?>, Boolean> _function = (ExecutableRule<?, ?> it) -> {
      return Boolean.valueOf(it.<S, T>conflictsWith(rule));
    };
    boolean _exists = IterableExtensions.<ExecutableRule<?, ?>>exists(this.rules, _function);
    if (_exists) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("Trying to register duplicated transformation for ");
      String _simpleName = source.getSimpleName();
      _builder.append(_simpleName);
      _builder.append(" to ");
      String _simpleName_1 = target.getSimpleName();
      _builder.append(_simpleName_1);
      throw new IllegalStateException(_builder.toString());
    }
    this.rules.add(rule);
  }

  @Override
  public <S extends Object, T extends Object> T map(final S source, final Class<T> target) {
    final int referenceId = System.identityHashCode(source);
    final GeneratorTransformationRegistryImpl.MappedObjectKey key = new GeneratorTransformationRegistryImpl.MappedObjectKey(target, referenceId);
    boolean _containsKey = this.mappedObjects.containsKey(key);
    if (_containsKey) {
      Object _get = this.mappedObjects.get(key);
      return ((T) _get);
    } else {
      if ((target == null)) {
        final Predicate<Map.Entry<GeneratorTransformationRegistryImpl.MappedObjectKey, Object>> _function = (Map.Entry<GeneratorTransformationRegistryImpl.MappedObjectKey, Object> it) -> {
          return (it.getKey().objectId == referenceId);
        };
        final List<Map.Entry<GeneratorTransformationRegistryImpl.MappedObjectKey, Object>> existing = this.mappedObjects.entrySet().stream().filter(_function).collect(Collectors.<Map.Entry<GeneratorTransformationRegistryImpl.MappedObjectKey, Object>>toList());
        int _size = existing.size();
        boolean _equals = (_size == 1);
        if (_equals) {
          Object _value = existing.get(0).getValue();
          return ((T) _value);
        }
      }
    }
    final Function1<ExecutableRule<?, ?>, Boolean> _function_1 = (ExecutableRule<?, ?> it) -> {
      return Boolean.valueOf(it.appliesTo(source, target));
    };
    final Function1<ExecutableRule<?, ?>, Registration<S, T>> _function_2 = (ExecutableRule<?, ?> it) -> {
      return ((Registration<S, T>) it);
    };
    final List<Registration<S, T>> possibleRegistrations = IterableExtensions.<Registration<S, T>>toList(IterableExtensions.<ExecutableRule<?, ?>, Registration<S, T>>map(IterableExtensions.<ExecutableRule<?, ?>>filter(this.rules, _function_1), _function_2));
    int _size_1 = possibleRegistrations.size();
    boolean _equals_1 = (_size_1 == 0);
    if (_equals_1) {
      String _simpleName = source.getClass().getSimpleName();
      String _plus = ("Couldn\'t find a mapping for " + _simpleName);
      String _plus_1 = (_plus + " to ");
      String _simpleName_1 = null;
      if (target!=null) {
        _simpleName_1=target.getSimpleName();
      }
      String _plus_2 = (_plus_1 + _simpleName_1);
      throw new RuntimeException(_plus_2);
    }
    int _size_2 = possibleRegistrations.size();
    boolean _greaterThan = (_size_2 > 1);
    if (_greaterThan) {
      String _simpleName_2 = source.getClass().getSimpleName();
      String _plus_3 = ("Found multiple matching transformations for " + _simpleName_2);
      throw new IllegalStateException(_plus_3);
    }
    final Registration<S, T> registrationToApply = possibleRegistrations.get(0);
    final T targetMapped = registrationToApply.create(source);
    this.mappedObjects.put(key, targetMapped);
    registrationToApply.applyTo(source, targetMapped, this);
    return targetMapped;
  }
}
