package org.palladiosimulator.textual.commons.generator.rules;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

@SuppressWarnings("all")
public interface GeneratorRuleBuilder<S extends Object, T extends Object> {
  /**
   * Defines a transformation for a child element.
   * 
   * @param contentProvider Provider for how get this element from the source element
   * @param target The desired target type for these elements
   * @see ValueApplierConfigurer
   */
  <PS extends Object, PT extends Object> ValueApplierRule<PT, T> map(final Function<S, PS> contentProvider, final Class<PT> target);

  /**
   * Defines a transformation for a child element.
   * 
   * @param contentProvider Provider for how get this element from the source element
   * @see ValueApplierConfigurer
   */
  <PS extends Object, PT extends Object> ValueApplierRule<PT, T> map(final Function<S, PS> contentProvider);

  /**
   * Defines a transformation for child elements.
   * 
   * @param contentProvider Provider for how get these elements from the source element
   * @see ValueApplierConfigurer
   */
  <PS extends Object, PT extends Object> ValueApplierRule<List<PT>, T> mapAll(final Function<S, ? extends List<PS>> contentProvider);

  /**
   * Defines a transformation for child elements.
   * 
   * @param contentProvider Provider for how get these elements from the source element
   * @param target The desired target type for these elements
   * @see ValueApplierConfigurer
   */
  <PS extends Object, PT extends Object> ValueApplierRule<List<PT>, T> mapAll(final Function<S, ? extends List<PS>> contentProvider, final Class<PT> target);

  /**
   * (Required)
   * Defines how the target object can be created from the given source.
   */
  void setCreate(final Function<S, T> factory);

  /**
   * (Optional)
   * Defines a predicate for this transformation. This makes sure that the transformation only happens, if the
   * predicate defined here tests successfully.
   */
  void setWhen(final Predicate<S> guard);

  /**
   * (Optional)
   * Defines what to do after all child element transformations have finished.
   */
  void setAfter(final Consumer<T> callback);

  /**
   * Build the resulting rule.
   */
  ExecutableRule<S, T> build();
}
