package org.palladiosimulator.textual.commons.generator.rules.impl;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.palladiosimulator.textual.commons.generator.rules.ExecutableRule;
import org.palladiosimulator.textual.commons.generator.rules.GeneratorRuleBuilder;
import org.palladiosimulator.textual.commons.generator.rules.ValueApplierRule;

@SuppressWarnings("all")
public class GeneratorRuleBuilderImpl<S extends Object, T extends Object> implements GeneratorRuleBuilder<S, T> {
  private final Registration<S, T> registration;

  public GeneratorRuleBuilderImpl(final Class<S> source, final Class<T> target) {
    Registration<S, T> _registration = new Registration<S, T>(source, target);
    this.registration = _registration;
  }

  @Override
  public <PS extends Object, PT extends Object> ValueApplierRule<PT, T> map(final Function<S, PS> contentProvider) {
    return new SingleValueApplierRule<PS, PT, S, T>(contentProvider, this.registration);
  }

  @Override
  public <PS extends Object, PT extends Object> ValueApplierRule<List<PT>, T> mapAll(final Function<S, ? extends List<PS>> contentProvider) {
    return new ListValueApplierRule<PS, PT, S, T>(contentProvider, this.registration);
  }

  @Override
  public void setCreate(final Function<S, T> factory) {
    this.registration.setFactory(factory);
  }

  @Override
  public void setWhen(final Predicate<S> guard) {
    this.registration.setPredicate(guard);
  }

  @Override
  public <PS extends Object, PT extends Object> ValueApplierRule<PT, T> map(final Function<S, PS> contentProvider, final Class<PT> target) {
    return new SingleValueApplierRule<PS, PT, S, T>(contentProvider, target, this.registration);
  }

  @Override
  public <PS extends Object, PT extends Object> ValueApplierRule<List<PT>, T> mapAll(final Function<S, ? extends List<PS>> contentProvider, final Class<PT> target) {
    return new ListValueApplierRule<PS, PT, S, T>(contentProvider, target, this.registration);
  }

  @Override
  public void setAfter(final Consumer<T> callback) {
    this.registration.setCallback(callback);
  }

  @Override
  public ExecutableRule<S, T> build() {
    Registration<S, T> _xifexpression = null;
    boolean _hasFactory = this.registration.hasFactory();
    boolean _not = (!_hasFactory);
    if (_not) {
      throw new IllegalStateException("No factory was configured for a transformation.");
    } else {
      _xifexpression = this.registration;
    }
    return _xifexpression;
  }
}
