/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.textual.commons.generator.standalone;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.name.Named;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.palladiosimulator.textual.commons.generator.MultiModelGeneratorFragment;
import org.palladiosimulator.textual.commons.generator.MultiModelGeneratorFragmentCollector;
import org.palladiosimulator.textual.commons.generator.MultiModelGeneratorFragmentProvider;

public class ServiceLoaderMultiModuleGeneratorFragmentCollector
implements MultiModelGeneratorFragmentCollector {
    private final String languageName;
    private final Injector injector;

    @Inject
    public ServiceLoaderMultiModuleGeneratorFragmentCollector(@Named(value="languageName") String languageName, Injector injector) {
        this.languageName = languageName;
        this.injector = injector;
    }

    public Iterable<MultiModelGeneratorFragment> getGeneratorFragments() {
        ServiceLoader<MultiModelGeneratorFragmentProvider> loader = ServiceLoader.load(MultiModelGeneratorFragmentProvider.class);
        return loader.stream().map(p -> (MultiModelGeneratorFragmentProvider)p.get()).filter(fp -> fp.getLanguage().equals(this.languageName)).map(prov -> prov.getGeneratorFragment(this.injector)).collect(Collectors.toList());
    }
}

