/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.textual.commons.generator.impl;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.palladiosimulator.textual.commons.generator.GenerationFileNameProvider;
import org.palladiosimulator.textual.commons.generator.impl.AbstractMultiSourceGenerator;
import org.palladiosimulator.textual.commons.generator.registry.GeneratorTransformationRegistry;
import org.palladiosimulator.textual.commons.generator.registry.ProvidedMapping;
import org.palladiosimulator.textual.commons.generator.registry.RegisteredMappingProvider;
import org.palladiosimulator.textual.commons.generator.registry.RootElementFilter;

public class ExtensibleMultiModelGenerator
extends AbstractMultiSourceGenerator {
    @Inject
    private GenerationFileNameProvider filenameProvider;
    @Inject
    @Named(value="org.palladiosimulator.textual.commons.generator.delegate")
    private RegisteredMappingProvider mappingProvider;
    @Inject
    @Named(value="org.palladiosimulator.textual.commons.generator.delegate")
    private RootElementFilter elementFilter;
    @Inject
    private GeneratorTransformationRegistry registry;

    @Override
    public void doGenerate(ResourceSet resources, IFileSystemAccess2 fsa, IGeneratorContext context) {
        Collection<ProvidedMapping> allMappings = this.mappingProvider.retrieveMappings(resources);
        ResourceSetImpl outputResources = new ResourceSetImpl();
        Runnable _function = () -> {
            ArrayList<Pair> createdResources = new ArrayList<Pair>();
            EList _resources = resources.getResources();
            for (Resource resource : _resources) {
                Functions.Function1 _function_1 = it -> this.elementFilter.translatesToRootElement((EObject)it);
                Iterator fragments = IteratorExtensions.filter((Iterator)resource.getAllContents(), (Functions.Function1)_function_1);
                String sourceFileName = this.getSourceFileName(resource);
                Functions.Function1 _function_2 = it -> {
                    MappingInformation _xblockexpression = null;
                    String filename = this.filenameProvider.generateFileNameFor((EObject)it, sourceFileName);
                    Object _map = this.registry.map(it);
                    EObject mapped = (EObject)_map;
                    _xblockexpression = new MappingInformation(mapped, filename);
                    return _xblockexpression;
                };
                List _list = IteratorExtensions.toList((Iterator)IteratorExtensions.map((Iterator)fragments, (Functions.Function1)_function_2));
                ArrayList mappedFragments = new ArrayList(_list);
                Functions.Function1 _function_3 = it -> {
                    Resource _createResource = this.createResource((ResourceSet)outputResources, it.mappedValue, it.fileName, fsa, context);
                    return Pair.of((Object)it.fileName, (Object)_createResource);
                };
                createdResources.addAll(IterableExtensions.toList((Iterable)ListExtensions.map(mappedFragments, (Functions.Function1)_function_3)));
            }
            Consumer<Pair> _function_1 = mapping -> {
                try {
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    ((Resource)mapping.getValue()).save((OutputStream)output, (Map)new Functions.Function0<Map<?, ?>>(){

                        public Map<?, ?> apply() {
                            return null;
                        }
                    }.apply());
                    byte[] _byteArray = output.toByteArray();
                    ByteArrayInputStream _byteArrayInputStream = new ByteArrayInputStream(_byteArray);
                    fsa.generateFile((String)mapping.getKey(), (InputStream)_byteArrayInputStream);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            createdResources.forEach(_function_1);
        };
        this.registry.withContext(allMappings, _function);
    }

    private String getSourceFileName(Resource resource) {
        String fileNameWithExtension = resource.getURI().lastSegment();
        int extensionDotIndex = fileNameWithExtension.lastIndexOf(".");
        return fileNameWithExtension.substring(0, extensionDotIndex);
    }

    public Resource createResource(ResourceSet containerSet, EObject resource, String fileName, IFileSystemAccess2 fsa, IGeneratorContext context) {
        URI targetFile = fsa.getURI(fileName);
        Resource targetResource = containerSet.createResource(targetFile);
        targetResource.getContents().add((Object)resource);
        return targetResource;
    }

    public static class MappingInformation {
        public final EObject mappedValue;
        public final String fileName;

        public MappingInformation(EObject mappedValue, String filename) {
            this.mappedValue = mappedValue;
            this.fileName = filename;
        }
    }
}

