/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.textual.commons.generator.impl;

import com.google.common.collect.Streams;
import com.google.inject.Inject;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.textual.commons.generator.ModelFileExtensionRegistrationFacade;
import org.palladiosimulator.textual.commons.generator.ModelFileExtensionRegistry;
import org.palladiosimulator.textual.commons.generator.MultiModelGeneratorFragment;
import org.palladiosimulator.textual.commons.generator.MultiModelGeneratorFragmentCollector;

public class ModelFileExtensionRegistryImpl
implements ModelFileExtensionRegistrationFacade,
ModelFileExtensionRegistry {
    static final String FALLBACK_FILE_EXTENSION = "xmi";
    Map<EClassifier, String> fileExtensions = new ConcurrentHashMap<EClassifier, String>();

    @Inject
    public ModelFileExtensionRegistryImpl(MultiModelGeneratorFragmentCollector providerCollector) {
        Streams.stream(providerCollector.getGeneratorFragments()).map(MultiModelGeneratorFragment::getFileExtensionRegistrationDelegate).forEach(delegate -> delegate.doFileRegistration(this));
    }

    @Override
    public void registerFileExtension(EClassifier clazz, String fileExtension) {
        String conflict = this.fileExtensions.put(clazz, fileExtension);
        if (conflict != null && !conflict.equals(fileExtension)) {
            throw new RuntimeException(String.format("Conflicting registration of extensions \".%s\" and \".%s\" for class %s", fileExtension, conflict, clazz.getName()));
        }
    }

    @Override
    public String getModelFileExtension(EObject rootElement) {
        EClass clazz = rootElement.eClass();
        return Optional.ofNullable(this.fileExtensions.get(clazz)).orElseGet(() -> clazz.getEAllSuperTypes().stream().flatMap(cls -> Optional.ofNullable(this.fileExtensions.get(cls)).stream()).findFirst().orElse(FALLBACK_FILE_EXTENSION));
    }
}

