/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.textual.commons.generator.registry.impl;

import com.google.common.collect.Streams;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.palladiosimulator.textual.commons.generator.MultiModelGeneratorFragment;
import org.palladiosimulator.textual.commons.generator.MultiModelGeneratorFragmentCollector;
import org.palladiosimulator.textual.commons.generator.registry.ProvidedMapping;
import org.palladiosimulator.textual.commons.generator.registry.RegisteredMappingProvider;

public class DelegatingRegisteredMappingProvider
implements RegisteredMappingProvider {
    private final Collection<RegisteredMappingProvider> providers;

    @Inject
    public DelegatingRegisteredMappingProvider(MultiModelGeneratorFragmentCollector providerCollector) {
        this.providers = Streams.stream(providerCollector.getGeneratorFragments()).map(MultiModelGeneratorFragment::getRegisteredMappingProvider).collect(Collectors.toList());
    }

    @Override
    public Collection<ProvidedMapping> retrieveMappings(ResourceSet resourceSet) {
        return this.providers.stream().flatMap(provider -> provider.retrieveMappings(resourceSet).stream()).collect(Collectors.toList());
    }
}

