/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.textual.commons.generator.registry.impl;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.palladiosimulator.textual.commons.generator.MultiModelGeneratorFragmentCollector;
import org.palladiosimulator.textual.commons.generator.registry.GeneratorRuleRegistrationFacade;
import org.palladiosimulator.textual.commons.generator.registry.GeneratorRulesRegistrationDelegate;
import org.palladiosimulator.textual.commons.generator.registry.GeneratorTransformationRegistry;
import org.palladiosimulator.textual.commons.generator.registry.ProvidedMapping;
import org.palladiosimulator.textual.commons.generator.rules.ExecutableRule;
import org.palladiosimulator.textual.commons.generator.rules.GeneratorRuleBuilder;
import org.palladiosimulator.textual.commons.generator.rules.impl.GeneratorRuleBuilderImpl;
import org.palladiosimulator.textual.commons.generator.rules.impl.Registration;

public class GeneratorTransformationRegistryImpl
implements GeneratorTransformationRegistry,
GeneratorRuleRegistrationFacade {
    private final List<ExecutableRule<?, ?>> rules = new ArrayList();
    private final Map<MappedObjectKey, Object> mappedObjects = new HashMap<MappedObjectKey, Object>();

    @Inject
    public GeneratorTransformationRegistryImpl(MultiModelGeneratorFragmentCollector providerCollector) {
        Functions.Function1 _function = it -> it.getRulesRegistrationDelegate();
        Consumer<GeneratorRulesRegistrationDelegate> _function_1 = it -> it.doRegistration(this);
        IterableExtensions.map(providerCollector.getGeneratorFragments(), (Functions.Function1)_function).forEach(_function_1);
    }

    public Object map(Object source) {
        return this.map(source, null);
    }

    @Override
    public void withContext(Runnable runnable) {
        ArrayList<ProvidedMapping> _arrayList = new ArrayList<ProvidedMapping>();
        this.withContext(_arrayList, runnable);
    }

    @Override
    public void withContext(Collection<ProvidedMapping> provided, Runnable runnable) {
        this.mappedObjects.clear();
        Consumer<ProvidedMapping> _function = it -> {
            int referenceId = System.identityHashCode(it.getSourceObject());
            Class<?> _get = it.getTargetObject().getClass().getInterfaces()[0];
            MappedObjectKey key = new MappedObjectKey(_get, referenceId);
            this.mappedObjects.put(key, it.getTargetObject());
        };
        provided.forEach(_function);
        runnable.run();
        this.mappedObjects.clear();
    }

    @Override
    public <S, T> void configure(Class<S> source, Class<T> target, Consumer<GeneratorRuleBuilder<S, T>> mapping) {
        GeneratorRuleBuilderImpl<S, T> builder = new GeneratorRuleBuilderImpl<S, T>(source, target);
        mapping.accept(builder);
        ExecutableRule rule = builder.build();
        Functions.Function1 _function = it -> it.conflictsWith(rule);
        boolean _exists = IterableExtensions.exists(this.rules, (Functions.Function1)_function);
        if (_exists) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Trying to register duplicated transformation for ");
            String _simpleName = source.getSimpleName();
            _builder.append(_simpleName);
            _builder.append(" to ");
            String _simpleName_1 = target.getSimpleName();
            _builder.append(_simpleName_1);
            throw new IllegalStateException(_builder.toString());
        }
        this.rules.add(rule);
    }

    @Override
    public <S, T> T map(S source, Class<T> target) {
        boolean _greaterThan;
        boolean _equals_1;
        int referenceId = System.identityHashCode(source);
        MappedObjectKey key = new MappedObjectKey(target, referenceId);
        boolean _containsKey = this.mappedObjects.containsKey(key);
        if (_containsKey) {
            Object _get = this.mappedObjects.get(key);
            return (T)_get;
        }
        if (target == null) {
            boolean _equals;
            Predicate<Map.Entry> _function = it -> ((MappedObjectKey)it.getKey()).objectId == referenceId;
            List existing = this.mappedObjects.entrySet().stream().filter(_function).collect(Collectors.toList());
            int _size = existing.size();
            boolean bl = _equals = _size == 1;
            if (_equals) {
                Object _value = ((Map.Entry)existing.get(0)).getValue();
                return (T)_value;
            }
        }
        Functions.Function1 _function_1 = it -> it.appliesTo(source, target);
        Functions.Function1 _function_2 = it -> (Registration)it;
        List possibleRegistrations = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(this.rules, (Functions.Function1)_function_1), (Functions.Function1)_function_2));
        int _size_1 = possibleRegistrations.size();
        boolean bl = _equals_1 = _size_1 == 0;
        if (_equals_1) {
            String _simpleName = source.getClass().getSimpleName();
            String _plus = "Couldn't find a mapping for " + _simpleName;
            String _plus_1 = String.valueOf(_plus) + " to ";
            String _simpleName_1 = null;
            if (target != null) {
                _simpleName_1 = target.getSimpleName();
            }
            String _plus_2 = String.valueOf(_plus_1) + _simpleName_1;
            throw new RuntimeException(_plus_2);
        }
        int _size_2 = possibleRegistrations.size();
        boolean bl2 = _greaterThan = _size_2 > 1;
        if (_greaterThan) {
            String _simpleName_2 = source.getClass().getSimpleName();
            String _plus_3 = "Found multiple matching transformations for " + _simpleName_2;
            throw new IllegalStateException(_plus_3);
        }
        Registration registrationToApply = (Registration)possibleRegistrations.get(0);
        Object targetMapped = registrationToApply.create(source);
        this.mappedObjects.put(key, targetMapped);
        registrationToApply.applyTo(source, targetMapped, this);
        return targetMapped;
    }

    private static class MappedObjectKey {
        private final Class<?> targetType;
        private final int objectId;

        public MappedObjectKey(Class<?> targetType, int id) {
            this.targetType = targetType;
            this.objectId = id;
        }

        public boolean equals(Object other) {
            if (!(other instanceof MappedObjectKey)) {
                return false;
            }
            MappedObjectKey otherKey = (MappedObjectKey)other;
            boolean _and = false;
            if (otherKey.objectId != this.objectId) {
                _and = false;
            } else {
                boolean _xifexpression = false;
                _xifexpression = this.targetType != null ? com.google.common.base.Objects.equal(this.targetType, otherKey.targetType) : otherKey.targetType == null;
                _and = _xifexpression;
            }
            return _and;
        }

        public int hashCode() {
            return Objects.hash(this.targetType, this.objectId);
        }
    }
}

