/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.textual.commons.generator.registry.impl;

import com.google.common.collect.Streams;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.textual.commons.generator.MultiModelGeneratorFragment;
import org.palladiosimulator.textual.commons.generator.MultiModelGeneratorFragmentCollector;
import org.palladiosimulator.textual.commons.generator.registry.RootElementFilter;

public class DelegatingRootElementFilter
implements RootElementFilter {
    private final Collection<RootElementFilter> filters;

    @Inject
    public DelegatingRootElementFilter(MultiModelGeneratorFragmentCollector providerCollector) {
        this.filters = Streams.stream(providerCollector.getGeneratorFragments()).map(MultiModelGeneratorFragment::getRootElementFilter).collect(Collectors.toList());
    }

    @Override
    public boolean translatesToRootElement(EObject object) {
        return this.filters.stream().anyMatch(f -> f.translatesToRootElement(object));
    }
}

