/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.textual.commons.generator.rules.impl;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.palladiosimulator.textual.commons.generator.registry.ChildPropertyMapping;
import org.palladiosimulator.textual.commons.generator.registry.GeneratorTransformationRegistry;
import org.palladiosimulator.textual.commons.generator.rules.ExecutableRule;

public class Registration<S, T>
implements ExecutableRule<S, T> {
    private static final Predicate<Object> DEFAULT_PREDICATE = it -> true;
    private final Class<S> mappingSource;
    private final Class<T> mappingTarget;
    private Function<S, T> factory;
    private Predicate<S> predicate = DEFAULT_PREDICATE;
    private Consumer<T> callback = it -> {};
    private final List<ChildPropertyMapping<S, T>> contents = new ArrayList<ChildPropertyMapping<S, T>>();

    public Registration(Class<S> source, Class<T> target, Function<S, T> factory) {
        this(source, target);
        this.factory = factory;
    }

    public Registration(Class<S> source, Class<T> target) {
        this.mappingSource = source;
        this.mappingTarget = target;
    }

    public Class<S> getSourceType() {
        return this.mappingSource;
    }

    public Class<T> getTargetType() {
        return this.mappingTarget;
    }

    public boolean doesMap(Object instance) {
        return this.mappingSource.isAssignableFrom(instance.getClass()) && this.predicate.test(this.mappingSource.cast(instance));
    }

    @Override
    public boolean appliesTo(Object instance, Class<?> target) {
        return (target == null || this.mappingTarget == target) && this.doesMap(instance);
    }

    public boolean hasPredicate() {
        return this.predicate != DEFAULT_PREDICATE;
    }

    public boolean hasFactory() {
        return this.factory != null;
    }

    public T create(S source) {
        return this.factory.apply(source);
    }

    public boolean addPropertyMapping(ChildPropertyMapping<S, T> mapping) {
        return this.contents.add(mapping);
    }

    public Predicate<S> setPredicate(Predicate<S> pred) {
        this.predicate = pred;
        return this.predicate;
    }

    public Function<S, T> setFactory(Function<S, T> factory) {
        this.factory = factory;
        return this.factory;
    }

    public Consumer<T> setCallback(Consumer<T> callback) {
        this.callback = callback;
        return this.callback;
    }

    @Override
    public void applyTo(S source, T target, GeneratorTransformationRegistry registry) {
        try {
            Consumer<ChildPropertyMapping> _function = it -> it.run(source, target, registry);
            this.contents.forEach(_function);
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                String _simpleName = source.getClass().getSimpleName();
                String _plus = "Exception occurred when transforming object of type " + _simpleName;
                String _plus_1 = String.valueOf(_plus) + " to ";
                String _simpleName_1 = target.getClass().getSimpleName();
                String _plus_2 = String.valueOf(_plus_1) + _simpleName_1;
                throw new RuntimeException(_plus_2, e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        this.callback.accept(target);
    }

    @Override
    public <U, V> boolean conflictsWith(ExecutableRule<U, V> conflictCandidate) {
        boolean _xblockexpression = false;
        if (conflictCandidate instanceof Registration && Objects.equal(((Registration)conflictCandidate).getSourceType(), this.getSourceType()) && Objects.equal(((Registration)conflictCandidate).getTargetType(), this.getTargetType()) && !this.hasPredicate() && !((Registration)conflictCandidate).hasPredicate()) {
            return true;
        }
        _xblockexpression = false;
        return _xblockexpression;
    }
}

