package org.palladiosimulator.textual.tpcm.generator.pcm;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.resourceenvironment.CommunicationLinkResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceenvironmentFactory;
import org.palladiosimulator.pcm.resourcetype.CommunicationLinkResourceType;
import org.palladiosimulator.pcm.resourcetype.SchedulingPolicy;
import org.palladiosimulator.textual.commons.generator.registry.GeneratorRuleRegistrationFacade;
import org.palladiosimulator.textual.commons.generator.registry.GeneratorRulesRegistrationDelegate;
import org.palladiosimulator.textual.commons.generator.rules.GeneratorRuleBuilder;
import org.palladiosimulator.textual.tpcm.language.CommunicationLinkType;
import org.palladiosimulator.textual.tpcm.language.LinkingResource;
import org.palladiosimulator.textual.tpcm.language.ProcessingResource;
import org.palladiosimulator.textual.tpcm.language.ProcessingResourceType;
import org.palladiosimulator.textual.tpcm.language.ResourceContainer;
import org.palladiosimulator.textual.tpcm.language.ResourceEnvironment;

@SuppressWarnings("all")
public class ResourceEnvironmentConfigurer implements GeneratorRulesRegistrationDelegate {
  private static final String PROCESSING_RATE_PROPERTY_NAME = "processingRate";

  private static final String SCHEDULING_POLICY_PROPERTY_NAME = "schedulingPolicy";

  private static final String LATENCY_PROPERTY_NAME = "latency";

  private static final String THROUGHPUT_PROPERTY_NAME = "throughput";

  @Override
  public void doRegistration(final GeneratorRuleRegistrationFacade registry) {
    final Consumer<GeneratorRuleBuilder<ResourceEnvironment, org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment>> _function = (GeneratorRuleBuilder<ResourceEnvironment, org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment> it) -> {
      final Function<ResourceEnvironment, org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment> _function_1 = (ResourceEnvironment it_1) -> {
        org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment _createResourceEnvironment = ResourceenvironmentFactory.eINSTANCE.createResourceEnvironment();
        final Procedure1<org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment> _function_2 = (org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment e) -> {
          e.setEntityName(it_1.getName());
        };
        return ObjectExtensions.<org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment>operator_doubleArrow(_createResourceEnvironment, _function_2);
      };
      it.setCreate(_function_1);
      final Function<ResourceEnvironment, List<ResourceContainer>> _function_2 = (ResourceEnvironment it_1) -> {
        return IterableExtensions.<ResourceContainer>toList(Iterables.<ResourceContainer>filter(it_1.getContents(), ResourceContainer.class));
      };
      final BiConsumer<org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment, List<org.palladiosimulator.pcm.resourceenvironment.ResourceContainer>> _function_3 = (org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment environment, List<org.palladiosimulator.pcm.resourceenvironment.ResourceContainer> container) -> {
        EObjectExtensions.<org.palladiosimulator.pcm.resourceenvironment.ResourceContainer>addAllUnOwned(environment.getResourceContainer_ResourceEnvironment(), container);
      };
      it.<ResourceContainer, org.palladiosimulator.pcm.resourceenvironment.ResourceContainer>mapAll(_function_2).thenSet(_function_3);
      final Function<ResourceEnvironment, List<LinkingResource>> _function_4 = (ResourceEnvironment it_1) -> {
        return IterableExtensions.<LinkingResource>toList(Iterables.<LinkingResource>filter(it_1.getContents(), LinkingResource.class));
      };
      final BiConsumer<org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment, List<org.palladiosimulator.pcm.resourceenvironment.LinkingResource>> _function_5 = (org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment environment, List<org.palladiosimulator.pcm.resourceenvironment.LinkingResource> links) -> {
        EObjectExtensions.<org.palladiosimulator.pcm.resourceenvironment.LinkingResource>addAllUnOwned(environment.getLinkingResources__ResourceEnvironment(), links);
      };
      it.<LinkingResource, org.palladiosimulator.pcm.resourceenvironment.LinkingResource>mapAll(_function_4).thenSet(_function_5);
    };
    registry.<ResourceEnvironment, org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment>configure(ResourceEnvironment.class, org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment.class, _function);
    final Consumer<GeneratorRuleBuilder<ResourceContainer, org.palladiosimulator.pcm.resourceenvironment.ResourceContainer>> _function_1 = (GeneratorRuleBuilder<ResourceContainer, org.palladiosimulator.pcm.resourceenvironment.ResourceContainer> it) -> {
      final Function<ResourceContainer, org.palladiosimulator.pcm.resourceenvironment.ResourceContainer> _function_2 = (ResourceContainer it_1) -> {
        org.palladiosimulator.pcm.resourceenvironment.ResourceContainer _createResourceContainer = ResourceenvironmentFactory.eINSTANCE.createResourceContainer();
        final Procedure1<org.palladiosimulator.pcm.resourceenvironment.ResourceContainer> _function_3 = (org.palladiosimulator.pcm.resourceenvironment.ResourceContainer e) -> {
          e.setEntityName(it_1.getName());
        };
        return ObjectExtensions.<org.palladiosimulator.pcm.resourceenvironment.ResourceContainer>operator_doubleArrow(_createResourceContainer, _function_3);
      };
      it.setCreate(_function_2);
      final Function<ResourceContainer, List<ProcessingResource>> _function_3 = (ResourceContainer it_1) -> {
        return IterableExtensions.<ProcessingResource>toList(Iterables.<ProcessingResource>filter(it_1.getContents(), ProcessingResource.class));
      };
      final BiConsumer<org.palladiosimulator.pcm.resourceenvironment.ResourceContainer, List<ProcessingResourceSpecification>> _function_4 = (org.palladiosimulator.pcm.resourceenvironment.ResourceContainer container, List<ProcessingResourceSpecification> resources) -> {
        EObjectExtensions.<ProcessingResourceSpecification>addAllUnOwned(container.getActiveResourceSpecifications_ResourceContainer(), resources);
      };
      it.<ProcessingResource, ProcessingResourceSpecification>mapAll(_function_3).thenSet(_function_4);
    };
    registry.<ResourceContainer, org.palladiosimulator.pcm.resourceenvironment.ResourceContainer>configure(ResourceContainer.class, org.palladiosimulator.pcm.resourceenvironment.ResourceContainer.class, _function_1);
    final Consumer<GeneratorRuleBuilder<ProcessingResource, ProcessingResourceSpecification>> _function_2 = (GeneratorRuleBuilder<ProcessingResource, ProcessingResourceSpecification> it) -> {
      final Function<ProcessingResource, ProcessingResourceSpecification> _function_3 = (ProcessingResource it_1) -> {
        return ResourceenvironmentFactory.eINSTANCE.createProcessingResourceSpecification();
      };
      it.setCreate(_function_3);
      final Function<ProcessingResource, EObject> _function_4 = (ProcessingResource it_1) -> {
        return ConfigurerHelper.getInitPropertyExpression(it_1.getInitialization(), ResourceEnvironmentConfigurer.PROCESSING_RATE_PROPERTY_NAME);
      };
      final BiConsumer<ProcessingResourceSpecification, PCMRandomVariable> _function_5 = (ProcessingResourceSpecification resource, PCMRandomVariable rate) -> {
        resource.setProcessingRate_ProcessingResourceSpecification(rate);
      };
      it.<EObject, PCMRandomVariable>map(_function_4, PCMRandomVariable.class).thenSet(_function_5);
      final Function<ProcessingResource, EObject> _function_6 = (ProcessingResource it_1) -> {
        return ConfigurerHelper.getInitPropertyExpression(it_1.getInitialization(), ResourceEnvironmentConfigurer.SCHEDULING_POLICY_PROPERTY_NAME);
      };
      final BiConsumer<ProcessingResourceSpecification, SchedulingPolicy> _function_7 = (ProcessingResourceSpecification resource, SchedulingPolicy policy) -> {
        resource.setSchedulingPolicy(policy);
      };
      it.<EObject, SchedulingPolicy>map(_function_6).thenSet(_function_7);
      final Function<ProcessingResource, ProcessingResourceType> _function_8 = (ProcessingResource it_1) -> {
        return it_1.getType();
      };
      final BiConsumer<ProcessingResourceSpecification, org.palladiosimulator.pcm.resourcetype.ProcessingResourceType> _function_9 = (ProcessingResourceSpecification resource, org.palladiosimulator.pcm.resourcetype.ProcessingResourceType type) -> {
        resource.setActiveResourceType_ActiveResourceSpecification(type);
      };
      it.<ProcessingResourceType, org.palladiosimulator.pcm.resourcetype.ProcessingResourceType>map(_function_8).thenSet(_function_9);
    };
    registry.<ProcessingResource, ProcessingResourceSpecification>configure(ProcessingResource.class, ProcessingResourceSpecification.class, _function_2);
    final Consumer<GeneratorRuleBuilder<LinkingResource, org.palladiosimulator.pcm.resourceenvironment.LinkingResource>> _function_3 = (GeneratorRuleBuilder<LinkingResource, org.palladiosimulator.pcm.resourceenvironment.LinkingResource> it) -> {
      final Function<LinkingResource, org.palladiosimulator.pcm.resourceenvironment.LinkingResource> _function_4 = (LinkingResource it_1) -> {
        org.palladiosimulator.pcm.resourceenvironment.LinkingResource _createLinkingResource = ResourceenvironmentFactory.eINSTANCE.createLinkingResource();
        final Procedure1<org.palladiosimulator.pcm.resourceenvironment.LinkingResource> _function_5 = (org.palladiosimulator.pcm.resourceenvironment.LinkingResource e) -> {
          e.setEntityName(it_1.getName());
        };
        return ObjectExtensions.<org.palladiosimulator.pcm.resourceenvironment.LinkingResource>operator_doubleArrow(_createLinkingResource, _function_5);
      };
      it.setCreate(_function_4);
      final Function<LinkingResource, CommunicationLinkType> _function_5 = (LinkingResource it_1) -> {
        return it_1.getType();
      };
      final BiConsumer<org.palladiosimulator.pcm.resourceenvironment.LinkingResource, CommunicationLinkResourceType> _function_6 = (org.palladiosimulator.pcm.resourceenvironment.LinkingResource link, CommunicationLinkResourceType type) -> {
        CommunicationLinkResourceSpecification _createCommunicationLinkResourceSpecification = ResourceenvironmentFactory.eINSTANCE.createCommunicationLinkResourceSpecification();
        final Procedure1<CommunicationLinkResourceSpecification> _function_7 = (CommunicationLinkResourceSpecification it_1) -> {
          it_1.setCommunicationLinkResourceType_CommunicationLinkResourceSpecification(type);
        };
        CommunicationLinkResourceSpecification spec = ObjectExtensions.<CommunicationLinkResourceSpecification>operator_doubleArrow(_createCommunicationLinkResourceSpecification, _function_7);
        link.setCommunicationLinkResourceSpecifications_LinkingResource(spec);
      };
      it.<CommunicationLinkType, CommunicationLinkResourceType>map(_function_5).thenSet(_function_6);
      final Function<LinkingResource, EObject> _function_7 = (LinkingResource it_1) -> {
        return ConfigurerHelper.getInitPropertyExpression(it_1.getInitialization(), ResourceEnvironmentConfigurer.LATENCY_PROPERTY_NAME);
      };
      final BiConsumer<org.palladiosimulator.pcm.resourceenvironment.LinkingResource, PCMRandomVariable> _function_8 = (org.palladiosimulator.pcm.resourceenvironment.LinkingResource link, PCMRandomVariable latency) -> {
        final CommunicationLinkResourceSpecification spec = link.getCommunicationLinkResourceSpecifications_LinkingResource();
        spec.setLatency_CommunicationLinkResourceSpecification(latency);
      };
      it.<EObject, PCMRandomVariable>map(_function_7, PCMRandomVariable.class).thenSet(_function_8);
      final Function<LinkingResource, EObject> _function_9 = (LinkingResource it_1) -> {
        return ConfigurerHelper.getInitPropertyExpression(it_1.getInitialization(), ResourceEnvironmentConfigurer.THROUGHPUT_PROPERTY_NAME);
      };
      final BiConsumer<org.palladiosimulator.pcm.resourceenvironment.LinkingResource, PCMRandomVariable> _function_10 = (org.palladiosimulator.pcm.resourceenvironment.LinkingResource link, PCMRandomVariable throughput) -> {
        final CommunicationLinkResourceSpecification spec = link.getCommunicationLinkResourceSpecifications_LinkingResource();
        spec.setThroughput_CommunicationLinkResourceSpecification(throughput);
      };
      it.<EObject, PCMRandomVariable>map(_function_9).thenSet(_function_10);
      final Function<LinkingResource, EList<ResourceContainer>> _function_11 = (LinkingResource it_1) -> {
        return it_1.getConnected();
      };
      final BiConsumer<org.palladiosimulator.pcm.resourceenvironment.LinkingResource, List<org.palladiosimulator.pcm.resourceenvironment.ResourceContainer>> _function_12 = (org.palladiosimulator.pcm.resourceenvironment.LinkingResource link, List<org.palladiosimulator.pcm.resourceenvironment.ResourceContainer> connected) -> {
        link.getConnectedResourceContainers_LinkingResource().addAll(connected);
      };
      it.<ResourceContainer, org.palladiosimulator.pcm.resourceenvironment.ResourceContainer>mapAll(_function_11).thenSet(_function_12);
    };
    registry.<LinkingResource, org.palladiosimulator.pcm.resourceenvironment.LinkingResource>configure(LinkingResource.class, org.palladiosimulator.pcm.resourceenvironment.LinkingResource.class, _function_3);
  }
}
