package org.palladiosimulator.textual.tpcm.generator.pcm;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.core.composition.ComposedStructure;
import org.palladiosimulator.pcm.core.composition.CompositionFactory;
import org.palladiosimulator.pcm.core.composition.ProvidedDelegationConnector;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RepositoryFactory;
import org.palladiosimulator.pcm.system.SystemFactory;
import org.palladiosimulator.textual.commons.generator.registry.GeneratorRuleRegistrationFacade;
import org.palladiosimulator.textual.commons.generator.registry.GeneratorRulesRegistrationDelegate;
import org.palladiosimulator.textual.commons.generator.rules.GeneratorRuleBuilder;
import org.palladiosimulator.textual.tpcm.language.AssemblyContext;
import org.palladiosimulator.textual.tpcm.language.Component;
import org.palladiosimulator.textual.tpcm.language.Connector;
import org.palladiosimulator.textual.tpcm.language.Interface;
import org.palladiosimulator.textual.tpcm.language.InterfaceRequiredRole;
import org.palladiosimulator.textual.tpcm.language.SystemProvidedRole;

@SuppressWarnings("all")
public class SystemRegistryConfigurer implements GeneratorRulesRegistrationDelegate {
  private static class RoleMatch {
    public final OperationProvidedRole providingRole;

    public final OperationRequiredRole requiringRole;

    public RoleMatch(final OperationProvidedRole providingRole, final OperationRequiredRole requiringRole) {
      this.providingRole = providingRole;
      this.requiringRole = requiringRole;
    }
  }

  @Override
  public void doRegistration(final GeneratorRuleRegistrationFacade registry) {
    final Consumer<GeneratorRuleBuilder<org.palladiosimulator.textual.tpcm.language.System, org.palladiosimulator.pcm.system.System>> _function = (GeneratorRuleBuilder<org.palladiosimulator.textual.tpcm.language.System, org.palladiosimulator.pcm.system.System> it) -> {
      final Function<org.palladiosimulator.textual.tpcm.language.System, org.palladiosimulator.pcm.system.System> _function_1 = (org.palladiosimulator.textual.tpcm.language.System it_1) -> {
        org.palladiosimulator.pcm.system.System _createSystem = SystemFactory.eINSTANCE.createSystem();
        final Procedure1<org.palladiosimulator.pcm.system.System> _function_2 = (org.palladiosimulator.pcm.system.System s) -> {
          s.setEntityName(it_1.getName());
        };
        return ObjectExtensions.<org.palladiosimulator.pcm.system.System>operator_doubleArrow(_createSystem, _function_2);
      };
      it.setCreate(_function_1);
      final Function<org.palladiosimulator.textual.tpcm.language.System, List<AssemblyContext>> _function_2 = (org.palladiosimulator.textual.tpcm.language.System it_1) -> {
        return IterableExtensions.<AssemblyContext>toList(Iterables.<AssemblyContext>filter(it_1.getContents(), AssemblyContext.class));
      };
      final BiConsumer<org.palladiosimulator.pcm.system.System, List<org.palladiosimulator.pcm.core.composition.AssemblyContext>> _function_3 = (org.palladiosimulator.pcm.system.System system, List<org.palladiosimulator.pcm.core.composition.AssemblyContext> assemblies) -> {
        EObjectExtensions.<org.palladiosimulator.pcm.core.composition.AssemblyContext>addAllUnOwned(system.getAssemblyContexts__ComposedStructure(), assemblies);
      };
      it.<AssemblyContext, org.palladiosimulator.pcm.core.composition.AssemblyContext>mapAll(_function_2).thenSet(_function_3);
      final Function<org.palladiosimulator.textual.tpcm.language.System, List<Connector>> _function_4 = (org.palladiosimulator.textual.tpcm.language.System it_1) -> {
        return IterableExtensions.<Connector>toList(Iterables.<Connector>filter(it_1.getContents(), Connector.class));
      };
      final BiConsumer<org.palladiosimulator.pcm.system.System, List<org.palladiosimulator.pcm.core.composition.Connector>> _function_5 = (org.palladiosimulator.pcm.system.System system, List<org.palladiosimulator.pcm.core.composition.Connector> connector) -> {
        EObjectExtensions.<org.palladiosimulator.pcm.core.composition.Connector>addAllUnOwned(system.getConnectors__ComposedStructure(), connector);
      };
      it.<Connector, org.palladiosimulator.pcm.core.composition.Connector>mapAll(_function_4).thenSet(_function_5);
      final Function<org.palladiosimulator.textual.tpcm.language.System, List<SystemProvidedRole>> _function_6 = (org.palladiosimulator.textual.tpcm.language.System it_1) -> {
        return IterableExtensions.<SystemProvidedRole>toList(Iterables.<SystemProvidedRole>filter(it_1.getContents(), SystemProvidedRole.class));
      };
      final BiConsumer<org.palladiosimulator.pcm.system.System, List<ProvidedDelegationConnector>> _function_7 = (org.palladiosimulator.pcm.system.System system, List<ProvidedDelegationConnector> roles) -> {
        system.getConnectors__ComposedStructure().addAll(roles);
        final Consumer<ProvidedDelegationConnector> _function_8 = (ProvidedDelegationConnector it_1) -> {
          it_1.setParentStructure__Connector(system);
          system.getProvidedRoles_InterfaceProvidingEntity().add(it_1.getOuterProvidedRole_ProvidedDelegationConnector());
        };
        roles.forEach(_function_8);
      };
      it.<SystemProvidedRole, ProvidedDelegationConnector>mapAll(_function_6, ProvidedDelegationConnector.class).thenSet(_function_7);
      final Consumer<org.palladiosimulator.pcm.system.System> _function_8 = (org.palladiosimulator.pcm.system.System it_1) -> {
        final ArrayList<AssemblyConnector> newConnectors = new ArrayList<AssemblyConnector>();
        final Function1<AssemblyConnector, Boolean> _function_9 = (AssemblyConnector it_2) -> {
          OperationProvidedRole _providedRole_AssemblyConnector = it_2.getProvidedRole_AssemblyConnector();
          return Boolean.valueOf((_providedRole_AssemblyConnector == null));
        };
        Iterable<AssemblyConnector> _filter = IterableExtensions.<AssemblyConnector>filter(Iterables.<AssemblyConnector>filter(it_1.getConnectors__ComposedStructure(), AssemblyConnector.class), _function_9);
        for (final AssemblyConnector connector : _filter) {
          {
            final List<OperationProvidedRole> providedRoles = IterableExtensions.<OperationProvidedRole>toList(Iterables.<OperationProvidedRole>filter(connector.getProvidingAssemblyContext_AssemblyConnector().getEncapsulatedComponent__AssemblyContext().getProvidedRoles_InterfaceProvidingEntity(), 
              OperationProvidedRole.class));
            final List<OperationRequiredRole> requiredRoles = IterableExtensions.<OperationRequiredRole>toList(Iterables.<OperationRequiredRole>filter(connector.getRequiringAssemblyContext_AssemblyConnector().getEncapsulatedComponent__AssemblyContext().getRequiredRoles_InterfaceRequiringEntity(), 
              OperationRequiredRole.class));
            final List<SystemRegistryConfigurer.RoleMatch> matches = SystemRegistryConfigurer.findMatchingRoles(providedRoles, requiredRoles);
            int _size = matches.size();
            boolean _equals = (_size == 1);
            if (_equals) {
              final SystemRegistryConfigurer.RoleMatch match = matches.get(0);
              connector.setProvidedRole_AssemblyConnector(match.providingRole);
              connector.setRequiredRole_AssemblyConnector(match.requiringRole);
            } else {
              final SystemRegistryConfigurer.RoleMatch firstMatch = matches.get(0);
              connector.setProvidedRole_AssemblyConnector(firstMatch.providingRole);
              connector.setRequiredRole_AssemblyConnector(firstMatch.requiringRole);
              for (int i = 1; (i < matches.size()); i++) {
                {
                  final AssemblyConnector copy = SystemRegistryConfigurer.copyConnector(connector);
                  final SystemRegistryConfigurer.RoleMatch match_1 = matches.get(i);
                  copy.setProvidedRole_AssemblyConnector(match_1.providingRole);
                  copy.setRequiredRole_AssemblyConnector(match_1.requiringRole);
                  newConnectors.add(copy);
                }
              }
            }
          }
        }
        it_1.getConnectors__ComposedStructure().addAll(newConnectors);
        final Consumer<ProvidedDelegationConnector> _function_10 = (ProvidedDelegationConnector connector_1) -> {
          ComposedStructure _parentStructure__AssemblyContext = connector_1.getAssemblyContext_ProvidedDelegationConnector().getParentStructure__AssemblyContext();
          boolean _tripleEquals = (_parentStructure__AssemblyContext == 
            null);
          if (_tripleEquals) {
            final org.palladiosimulator.pcm.core.composition.AssemblyContext context = connector_1.getAssemblyContext_ProvidedDelegationConnector();
            it_1.getAssemblyContexts__ComposedStructure().add(context);
          }
        };
        Iterables.<ProvidedDelegationConnector>filter(it_1.getConnectors__ComposedStructure(), ProvidedDelegationConnector.class).forEach(_function_10);
        final Consumer<AssemblyConnector> _function_11 = (AssemblyConnector connector_1) -> {
          boolean _contains = it_1.getAssemblyContexts__ComposedStructure().contains(
            connector_1.getProvidingAssemblyContext_AssemblyConnector());
          boolean _not = (!_contains);
          if (_not) {
            final org.palladiosimulator.pcm.core.composition.AssemblyContext provided = connector_1.getProvidingAssemblyContext_AssemblyConnector();
            it_1.getAssemblyContexts__ComposedStructure().add(provided);
          } else {
            boolean _contains_1 = it_1.getAssemblyContexts__ComposedStructure().contains(
              connector_1.getRequiringAssemblyContext_AssemblyConnector());
            boolean _not_1 = (!_contains_1);
            if (_not_1) {
              final org.palladiosimulator.pcm.core.composition.AssemblyContext required = connector_1.getRequiringAssemblyContext_AssemblyConnector();
              it_1.getAssemblyContexts__ComposedStructure().add(required);
            }
          }
        };
        Iterables.<AssemblyConnector>filter(it_1.getConnectors__ComposedStructure(), AssemblyConnector.class).forEach(_function_11);
      };
      it.setAfter(_function_8);
    };
    registry.<org.palladiosimulator.textual.tpcm.language.System, org.palladiosimulator.pcm.system.System>configure(org.palladiosimulator.textual.tpcm.language.System.class, org.palladiosimulator.pcm.system.System.class, _function);
    final Consumer<GeneratorRuleBuilder<Connector, AssemblyConnector>> _function_1 = (GeneratorRuleBuilder<Connector, AssemblyConnector> it) -> {
      final Function<Connector, AssemblyConnector> _function_2 = (Connector it_1) -> {
        AssemblyConnector _createAssemblyConnector = CompositionFactory.eINSTANCE.createAssemblyConnector();
        final Procedure1<AssemblyConnector> _function_3 = (AssemblyConnector a) -> {
          a.setEntityName(it_1.getName());
        };
        return ObjectExtensions.<AssemblyConnector>operator_doubleArrow(_createAssemblyConnector, _function_3);
      };
      it.setCreate(_function_2);
      final Function<Connector, AssemblyContext> _function_3 = (Connector it_1) -> {
        return it_1.getFrom();
      };
      final BiConsumer<AssemblyConnector, org.palladiosimulator.pcm.core.composition.AssemblyContext> _function_4 = (AssemblyConnector connector, org.palladiosimulator.pcm.core.composition.AssemblyContext from) -> {
        connector.setProvidingAssemblyContext_AssemblyConnector(from);
      };
      it.<AssemblyContext, org.palladiosimulator.pcm.core.composition.AssemblyContext>map(_function_3).thenSet(_function_4);
      final Function<Connector, AssemblyContext> _function_5 = (Connector it_1) -> {
        return it_1.getTo();
      };
      final BiConsumer<AssemblyConnector, org.palladiosimulator.pcm.core.composition.AssemblyContext> _function_6 = (AssemblyConnector connector, org.palladiosimulator.pcm.core.composition.AssemblyContext to) -> {
        connector.setRequiringAssemblyContext_AssemblyConnector(to);
      };
      it.<AssemblyContext, org.palladiosimulator.pcm.core.composition.AssemblyContext>map(_function_5).thenSet(_function_6);
      final Function<Connector, AssemblyContext> _function_7 = (Connector it_1) -> {
        return it_1.getTarget();
      };
      final BiConsumer<AssemblyConnector, org.palladiosimulator.pcm.core.composition.AssemblyContext> _function_8 = (AssemblyConnector connector, org.palladiosimulator.pcm.core.composition.AssemblyContext to) -> {
        connector.setRequiringAssemblyContext_AssemblyConnector(to);
      };
      it.<AssemblyContext, org.palladiosimulator.pcm.core.composition.AssemblyContext>map(_function_7).thenSet(_function_8);
      final Function<Connector, InterfaceRequiredRole> _function_9 = (Connector it_1) -> {
        return it_1.getRequiringRole();
      };
      final BiConsumer<AssemblyConnector, OperationRequiredRole> _function_10 = (AssemblyConnector connector, OperationRequiredRole requiringRole) -> {
        connector.setRequiredRole_AssemblyConnector(requiringRole);
        final Function1<OperationProvidedRole, Boolean> _function_11 = (OperationProvidedRole it_1) -> {
          OperationInterface _providedInterface__OperationProvidedRole = it_1.getProvidedInterface__OperationProvidedRole();
          OperationInterface _requiredInterface__OperationRequiredRole = requiringRole.getRequiredInterface__OperationRequiredRole();
          return Boolean.valueOf((_providedInterface__OperationProvidedRole == _requiredInterface__OperationRequiredRole));
        };
        final OperationProvidedRole providingRole = IterableExtensions.<OperationProvidedRole>findFirst(Iterables.<OperationProvidedRole>filter(connector.getProvidingAssemblyContext_AssemblyConnector().getEncapsulatedComponent__AssemblyContext().getProvidedRoles_InterfaceProvidingEntity(), 
          OperationProvidedRole.class), _function_11);
        connector.setProvidedRole_AssemblyConnector(providingRole);
      };
      it.<InterfaceRequiredRole, OperationRequiredRole>map(_function_9).thenSet(_function_10);
      final Consumer<AssemblyConnector> _function_11 = (AssemblyConnector it_1) -> {
        boolean _hasEmptyName = ConfigurerHelper.hasEmptyName(it_1);
        if (_hasEmptyName) {
          String _entityName = it_1.getProvidingAssemblyContext_AssemblyConnector().getEntityName();
          String _plus = (_entityName + "->");
          String _entityName_1 = it_1.getRequiringAssemblyContext_AssemblyConnector().getEntityName();
          String _plus_1 = (_plus + _entityName_1);
          it_1.setEntityName(_plus_1);
        }
      };
      it.setAfter(_function_11);
    };
    registry.<Connector, AssemblyConnector>configure(Connector.class, AssemblyConnector.class, _function_1);
    final Consumer<GeneratorRuleBuilder<AssemblyContext, org.palladiosimulator.pcm.core.composition.AssemblyContext>> _function_2 = (GeneratorRuleBuilder<AssemblyContext, org.palladiosimulator.pcm.core.composition.AssemblyContext> it) -> {
      final Function<AssemblyContext, org.palladiosimulator.pcm.core.composition.AssemblyContext> _function_3 = (AssemblyContext it_1) -> {
        org.palladiosimulator.pcm.core.composition.AssemblyContext _createAssemblyContext = CompositionFactory.eINSTANCE.createAssemblyContext();
        final Procedure1<org.palladiosimulator.pcm.core.composition.AssemblyContext> _function_4 = (org.palladiosimulator.pcm.core.composition.AssemblyContext a) -> {
          a.setEntityName(it_1.getName());
        };
        return ObjectExtensions.<org.palladiosimulator.pcm.core.composition.AssemblyContext>operator_doubleArrow(_createAssemblyContext, _function_4);
      };
      it.setCreate(_function_3);
      final Function<AssemblyContext, Component> _function_4 = (AssemblyContext it_1) -> {
        return it_1.getComponent();
      };
      final BiConsumer<org.palladiosimulator.pcm.core.composition.AssemblyContext, RepositoryComponent> _function_5 = (org.palladiosimulator.pcm.core.composition.AssemblyContext context, RepositoryComponent component) -> {
        context.setEncapsulatedComponent__AssemblyContext(component);
      };
      it.<Component, RepositoryComponent>map(_function_4).thenSet(_function_5);
    };
    registry.<AssemblyContext, org.palladiosimulator.pcm.core.composition.AssemblyContext>configure(AssemblyContext.class, org.palladiosimulator.pcm.core.composition.AssemblyContext.class, _function_2);
    final Consumer<GeneratorRuleBuilder<SystemProvidedRole, ProvidedDelegationConnector>> _function_3 = (GeneratorRuleBuilder<SystemProvidedRole, ProvidedDelegationConnector> it) -> {
      final Function<SystemProvidedRole, ProvidedDelegationConnector> _function_4 = (SystemProvidedRole it_1) -> {
        ProvidedDelegationConnector _createProvidedDelegationConnector = CompositionFactory.eINSTANCE.createProvidedDelegationConnector();
        final Procedure1<ProvidedDelegationConnector> _function_5 = (ProvidedDelegationConnector c) -> {
          c.setEntityName(it_1.getName());
        };
        return ObjectExtensions.<ProvidedDelegationConnector>operator_doubleArrow(_createProvidedDelegationConnector, _function_5);
      };
      it.setCreate(_function_4);
      final Function<SystemProvidedRole, Interface> _function_5 = (SystemProvidedRole it_1) -> {
        return it_1.getType();
      };
      final BiConsumer<ProvidedDelegationConnector, OperationInterface> _function_6 = (ProvidedDelegationConnector connector, OperationInterface iface) -> {
        OperationProvidedRole _createOperationProvidedRole = RepositoryFactory.eINSTANCE.createOperationProvidedRole();
        final Procedure1<OperationProvidedRole> _function_7 = (OperationProvidedRole r) -> {
          r.setEntityName(iface.getEntityName());
        };
        final OperationProvidedRole role = ObjectExtensions.<OperationProvidedRole>operator_doubleArrow(_createOperationProvidedRole, _function_7);
        role.setProvidedInterface__OperationProvidedRole(iface);
        connector.setOuterProvidedRole_ProvidedDelegationConnector(role);
      };
      it.<Interface, OperationInterface>map(_function_5).thenSet(_function_6);
      final Function<SystemProvidedRole, AssemblyContext> _function_7 = (SystemProvidedRole it_1) -> {
        return it_1.getTo();
      };
      final BiConsumer<ProvidedDelegationConnector, org.palladiosimulator.pcm.core.composition.AssemblyContext> _function_8 = (ProvidedDelegationConnector connector, org.palladiosimulator.pcm.core.composition.AssemblyContext to) -> {
        connector.setAssemblyContext_ProvidedDelegationConnector(to);
        final OperationInterface requiredInterface = connector.getOuterProvidedRole_ProvidedDelegationConnector().getProvidedInterface__OperationProvidedRole();
        final EList<ProvidedRole> providedRoles = to.getEncapsulatedComponent__AssemblyContext().getProvidedRoles_InterfaceProvidingEntity();
        final Function1<OperationProvidedRole, Boolean> _function_9 = (OperationProvidedRole it_1) -> {
          OperationInterface _providedInterface__OperationProvidedRole = it_1.getProvidedInterface__OperationProvidedRole();
          return Boolean.valueOf((_providedInterface__OperationProvidedRole == requiredInterface));
        };
        final OperationProvidedRole matchedRole = IterableExtensions.<OperationProvidedRole>findFirst(Iterables.<OperationProvidedRole>filter(providedRoles, OperationProvidedRole.class), _function_9);
        connector.setInnerProvidedRole_ProvidedDelegationConnector(matchedRole);
      };
      it.<AssemblyContext, org.palladiosimulator.pcm.core.composition.AssemblyContext>map(_function_7).thenSet(_function_8);
      final Function<SystemProvidedRole, AssemblyContext> _function_9 = (SystemProvidedRole it_1) -> {
        return it_1.getTarget();
      };
      final BiConsumer<ProvidedDelegationConnector, org.palladiosimulator.pcm.core.composition.AssemblyContext> _function_10 = (ProvidedDelegationConnector connector, org.palladiosimulator.pcm.core.composition.AssemblyContext to) -> {
        connector.setAssemblyContext_ProvidedDelegationConnector(to);
        final OperationInterface requiredInterface = connector.getOuterProvidedRole_ProvidedDelegationConnector().getProvidedInterface__OperationProvidedRole();
        final EList<ProvidedRole> providedRoles = to.getEncapsulatedComponent__AssemblyContext().getProvidedRoles_InterfaceProvidingEntity();
        final Function1<OperationProvidedRole, Boolean> _function_11 = (OperationProvidedRole it_1) -> {
          OperationInterface _providedInterface__OperationProvidedRole = it_1.getProvidedInterface__OperationProvidedRole();
          return Boolean.valueOf((_providedInterface__OperationProvidedRole == requiredInterface));
        };
        final OperationProvidedRole matchedRole = IterableExtensions.<OperationProvidedRole>findFirst(Iterables.<OperationProvidedRole>filter(providedRoles, OperationProvidedRole.class), _function_11);
        connector.setInnerProvidedRole_ProvidedDelegationConnector(matchedRole);
      };
      it.<AssemblyContext, org.palladiosimulator.pcm.core.composition.AssemblyContext>map(_function_9).thenSet(_function_10);
    };
    registry.<SystemProvidedRole, ProvidedDelegationConnector>configure(SystemProvidedRole.class, ProvidedDelegationConnector.class, _function_3);
  }

  private static AssemblyConnector copyConnector(final AssemblyConnector connector) {
    AssemblyConnector _createAssemblyConnector = CompositionFactory.eINSTANCE.createAssemblyConnector();
    final Procedure1<AssemblyConnector> _function = (AssemblyConnector it) -> {
      it.setEntityName(connector.getEntityName());
      it.setParentStructure__Connector(connector.getParentStructure__Connector());
      it.setProvidingAssemblyContext_AssemblyConnector(connector.getProvidingAssemblyContext_AssemblyConnector());
      it.setRequiringAssemblyContext_AssemblyConnector(connector.getRequiringAssemblyContext_AssemblyConnector());
    };
    return ObjectExtensions.<AssemblyConnector>operator_doubleArrow(_createAssemblyConnector, _function);
  }

  private static List<SystemRegistryConfigurer.RoleMatch> findMatchingRoles(final List<OperationProvidedRole> providingRoles, final List<OperationRequiredRole> requiringRole) {
    final ArrayList<SystemRegistryConfigurer.RoleMatch> matches = new ArrayList<SystemRegistryConfigurer.RoleMatch>();
    for (final OperationProvidedRole provided : providingRoles) {
      {
        final Function1<OperationRequiredRole, Boolean> _function = (OperationRequiredRole it) -> {
          OperationInterface _requiredInterface__OperationRequiredRole = it.getRequiredInterface__OperationRequiredRole();
          OperationInterface _providedInterface__OperationProvidedRole = provided.getProvidedInterface__OperationProvidedRole();
          return Boolean.valueOf((_requiredInterface__OperationRequiredRole == _providedInterface__OperationProvidedRole));
        };
        final List<OperationRequiredRole> allRequiring = IterableExtensions.<OperationRequiredRole>toList(IterableExtensions.<OperationRequiredRole>filter(requiringRole, _function));
        int _size = allRequiring.size();
        boolean _greaterThan = (_size > 1);
        if (_greaterThan) {
          throw new IllegalStateException("Got a connector that isn\'t specific enough.");
        } else {
          int _size_1 = allRequiring.size();
          boolean _equals = (_size_1 == 1);
          if (_equals) {
            OperationRequiredRole _get = allRequiring.get(0);
            SystemRegistryConfigurer.RoleMatch _roleMatch = new SystemRegistryConfigurer.RoleMatch(provided, _get);
            matches.add(_roleMatch);
          }
        }
      }
    }
    return matches;
  }
}
