package org.palladiosimulator.textual.tpcm.generator.pcm;

import com.google.common.collect.Iterables;
import de.uka.ipd.sdq.stoex.Expression;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.core.composition.ProvidedDelegationConnector;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.usagemodel.AbstractUserAction;
import org.palladiosimulator.pcm.usagemodel.Branch;
import org.palladiosimulator.pcm.usagemodel.BranchTransition;
import org.palladiosimulator.pcm.usagemodel.Delay;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.Loop;
import org.palladiosimulator.pcm.usagemodel.ScenarioBehaviour;
import org.palladiosimulator.pcm.usagemodel.UsageModel;
import org.palladiosimulator.pcm.usagemodel.UsagemodelFactory;
import org.palladiosimulator.textual.commons.generator.registry.GeneratorRuleRegistrationFacade;
import org.palladiosimulator.textual.commons.generator.registry.GeneratorRulesRegistrationDelegate;
import org.palladiosimulator.textual.commons.generator.rules.GeneratorRuleBuilder;
import org.palladiosimulator.textual.tpcm.language.ClosedWorkload;
import org.palladiosimulator.textual.tpcm.language.ComplexResultAssignment;
import org.palladiosimulator.textual.tpcm.language.EntryLevelSystemCallAction;
import org.palladiosimulator.textual.tpcm.language.OpenWorkload;
import org.palladiosimulator.textual.tpcm.language.ParameterSpecification;
import org.palladiosimulator.textual.tpcm.language.ResultAssignment;
import org.palladiosimulator.textual.tpcm.language.ResultSpecification;
import org.palladiosimulator.textual.tpcm.language.ScenarioBranch;
import org.palladiosimulator.textual.tpcm.language.ScenarioBranchAction;
import org.palladiosimulator.textual.tpcm.language.ScenarioContent;
import org.palladiosimulator.textual.tpcm.language.ScenarioDelayAction;
import org.palladiosimulator.textual.tpcm.language.ScenarioLoopAction;
import org.palladiosimulator.textual.tpcm.language.Signature;
import org.palladiosimulator.textual.tpcm.language.SystemProvidedRole;
import org.palladiosimulator.textual.tpcm.language.Usage;
import org.palladiosimulator.textual.tpcm.language.UsageScenario;
import org.palladiosimulator.textual.tpcm.language.Workload;

@SuppressWarnings("all")
public class UsageProfileConfigurer implements GeneratorRulesRegistrationDelegate {
  @Override
  public void doRegistration(final GeneratorRuleRegistrationFacade registry) {
    final Consumer<GeneratorRuleBuilder<Usage, UsageModel>> _function = (GeneratorRuleBuilder<Usage, UsageModel> it) -> {
      final Function<Usage, UsageModel> _function_1 = (Usage it_1) -> {
        return UsagemodelFactory.eINSTANCE.createUsageModel();
      };
      it.setCreate(_function_1);
      final Function<Usage, List<UsageScenario>> _function_2 = (Usage it_1) -> {
        return IterableExtensions.<UsageScenario>toList(Iterables.<UsageScenario>filter(it_1.getContents(), UsageScenario.class));
      };
      final BiConsumer<UsageModel, List<org.palladiosimulator.pcm.usagemodel.UsageScenario>> _function_3 = (UsageModel model, List<org.palladiosimulator.pcm.usagemodel.UsageScenario> scenarios) -> {
        EObjectExtensions.<org.palladiosimulator.pcm.usagemodel.UsageScenario>addAllUnOwned(model.getUsageScenario_UsageModel(), scenarios);
        final Consumer<org.palladiosimulator.pcm.usagemodel.UsageScenario> _function_4 = (org.palladiosimulator.pcm.usagemodel.UsageScenario it_1) -> {
          it_1.setUsageModel_UsageScenario(model);
        };
        scenarios.forEach(_function_4);
      };
      it.<UsageScenario, org.palladiosimulator.pcm.usagemodel.UsageScenario>mapAll(_function_2).thenSet(_function_3);
    };
    registry.<Usage, UsageModel>configure(Usage.class, UsageModel.class, _function);
    final Consumer<GeneratorRuleBuilder<UsageScenario, org.palladiosimulator.pcm.usagemodel.UsageScenario>> _function_1 = (GeneratorRuleBuilder<UsageScenario, org.palladiosimulator.pcm.usagemodel.UsageScenario> it) -> {
      final Function<UsageScenario, org.palladiosimulator.pcm.usagemodel.UsageScenario> _function_2 = (UsageScenario it_1) -> {
        org.palladiosimulator.pcm.usagemodel.UsageScenario _createUsageScenario = UsagemodelFactory.eINSTANCE.createUsageScenario();
        final Procedure1<org.palladiosimulator.pcm.usagemodel.UsageScenario> _function_3 = (org.palladiosimulator.pcm.usagemodel.UsageScenario m) -> {
          m.setEntityName(it_1.getName());
        };
        return ObjectExtensions.<org.palladiosimulator.pcm.usagemodel.UsageScenario>operator_doubleArrow(_createUsageScenario, _function_3);
      };
      it.setCreate(_function_2);
      final Function<UsageScenario, Workload> _function_3 = (UsageScenario it_1) -> {
        return it_1.getWorkload();
      };
      final BiConsumer<org.palladiosimulator.pcm.usagemodel.UsageScenario, org.palladiosimulator.pcm.usagemodel.Workload> _function_4 = (org.palladiosimulator.pcm.usagemodel.UsageScenario scenario, org.palladiosimulator.pcm.usagemodel.Workload workload) -> {
        scenario.setWorkload_UsageScenario(workload);
        workload.setUsageScenario_Workload(scenario);
      };
      it.<Workload, org.palladiosimulator.pcm.usagemodel.Workload>map(_function_3).thenSet(_function_4);
      final Function<UsageScenario, EList<ScenarioContent>> _function_5 = (UsageScenario it_1) -> {
        return it_1.getContents();
      };
      final BiConsumer<org.palladiosimulator.pcm.usagemodel.UsageScenario, List<AbstractUserAction>> _function_6 = (org.palladiosimulator.pcm.usagemodel.UsageScenario scenario, List<AbstractUserAction> actions) -> {
        final ScenarioBehaviour behavior = UsageProfileConfigurer.createScenarioBehavior(actions);
        scenario.setScenarioBehaviour_UsageScenario(behavior);
        behavior.setUsageScenario_SenarioBehaviour(scenario);
      };
      it.<ScenarioContent, AbstractUserAction>mapAll(_function_5).thenSet(_function_6);
    };
    registry.<UsageScenario, org.palladiosimulator.pcm.usagemodel.UsageScenario>configure(UsageScenario.class, org.palladiosimulator.pcm.usagemodel.UsageScenario.class, _function_1);
    final Consumer<GeneratorRuleBuilder<OpenWorkload, org.palladiosimulator.pcm.usagemodel.OpenWorkload>> _function_2 = (GeneratorRuleBuilder<OpenWorkload, org.palladiosimulator.pcm.usagemodel.OpenWorkload> it) -> {
      final Function<OpenWorkload, org.palladiosimulator.pcm.usagemodel.OpenWorkload> _function_3 = (OpenWorkload it_1) -> {
        return UsagemodelFactory.eINSTANCE.createOpenWorkload();
      };
      it.setCreate(_function_3);
      final Function<OpenWorkload, Expression> _function_4 = (OpenWorkload it_1) -> {
        return it_1.getInterArrivalTime();
      };
      final BiConsumer<org.palladiosimulator.pcm.usagemodel.OpenWorkload, PCMRandomVariable> _function_5 = (org.palladiosimulator.pcm.usagemodel.OpenWorkload workload, PCMRandomVariable arrivalTime) -> {
        workload.setInterArrivalTime_OpenWorkload(arrivalTime);
        arrivalTime.setOpenWorkload_PCMRandomVariable(workload);
      };
      it.<Expression, PCMRandomVariable>map(_function_4, PCMRandomVariable.class).thenSet(_function_5);
    };
    registry.<OpenWorkload, org.palladiosimulator.pcm.usagemodel.OpenWorkload>configure(OpenWorkload.class, org.palladiosimulator.pcm.usagemodel.OpenWorkload.class, _function_2);
    final Consumer<GeneratorRuleBuilder<ClosedWorkload, org.palladiosimulator.pcm.usagemodel.ClosedWorkload>> _function_3 = (GeneratorRuleBuilder<ClosedWorkload, org.palladiosimulator.pcm.usagemodel.ClosedWorkload> it) -> {
      final Function<ClosedWorkload, org.palladiosimulator.pcm.usagemodel.ClosedWorkload> _function_4 = (ClosedWorkload it_1) -> {
        org.palladiosimulator.pcm.usagemodel.ClosedWorkload _createClosedWorkload = UsagemodelFactory.eINSTANCE.createClosedWorkload();
        final Procedure1<org.palladiosimulator.pcm.usagemodel.ClosedWorkload> _function_5 = (org.palladiosimulator.pcm.usagemodel.ClosedWorkload w) -> {
          w.setPopulation(it_1.getNumberOfUsers());
        };
        return ObjectExtensions.<org.palladiosimulator.pcm.usagemodel.ClosedWorkload>operator_doubleArrow(_createClosedWorkload, _function_5);
      };
      it.setCreate(_function_4);
      final Function<ClosedWorkload, Expression> _function_5 = (ClosedWorkload it_1) -> {
        return it_1.getThinkTime();
      };
      final BiConsumer<org.palladiosimulator.pcm.usagemodel.ClosedWorkload, PCMRandomVariable> _function_6 = (org.palladiosimulator.pcm.usagemodel.ClosedWorkload workload, PCMRandomVariable time) -> {
        workload.setThinkTime_ClosedWorkload(time);
        time.setClosedWorkload_PCMRandomVariable(workload);
      };
      it.<Expression, PCMRandomVariable>map(_function_5, PCMRandomVariable.class).thenSet(_function_6);
    };
    registry.<ClosedWorkload, org.palladiosimulator.pcm.usagemodel.ClosedWorkload>configure(ClosedWorkload.class, org.palladiosimulator.pcm.usagemodel.ClosedWorkload.class, _function_3);
    final Consumer<GeneratorRuleBuilder<ScenarioLoopAction, Loop>> _function_4 = (GeneratorRuleBuilder<ScenarioLoopAction, Loop> it) -> {
      final Function<ScenarioLoopAction, Loop> _function_5 = (ScenarioLoopAction it_1) -> {
        return UsagemodelFactory.eINSTANCE.createLoop();
      };
      it.setCreate(_function_5);
      final Function<ScenarioLoopAction, Expression> _function_6 = (ScenarioLoopAction it_1) -> {
        return it_1.getCondition();
      };
      final BiConsumer<Loop, PCMRandomVariable> _function_7 = (Loop loop, PCMRandomVariable condition) -> {
        loop.setLoopIteration_Loop(condition);
        condition.setLoop_LoopIteration(loop);
      };
      it.<Expression, PCMRandomVariable>map(_function_6, PCMRandomVariable.class).thenSet(_function_7);
      final Function<ScenarioLoopAction, EList<ScenarioContent>> _function_8 = (ScenarioLoopAction it_1) -> {
        return it_1.getContents();
      };
      final BiConsumer<Loop, List<AbstractUserAction>> _function_9 = (Loop loop, List<AbstractUserAction> actions) -> {
        final ScenarioBehaviour behavior = UsageProfileConfigurer.createScenarioBehavior(actions);
        loop.setBodyBehaviour_Loop(behavior);
        behavior.setLoop_ScenarioBehaviour(loop);
      };
      it.<ScenarioContent, AbstractUserAction>mapAll(_function_8).thenSet(_function_9);
    };
    registry.<ScenarioLoopAction, Loop>configure(ScenarioLoopAction.class, Loop.class, _function_4);
    final Consumer<GeneratorRuleBuilder<ScenarioBranchAction, Branch>> _function_5 = (GeneratorRuleBuilder<ScenarioBranchAction, Branch> it) -> {
      final Function<ScenarioBranchAction, Branch> _function_6 = (ScenarioBranchAction it_1) -> {
        return UsagemodelFactory.eINSTANCE.createBranch();
      };
      it.setCreate(_function_6);
      final Function<ScenarioBranchAction, EList<ScenarioBranch>> _function_7 = (ScenarioBranchAction it_1) -> {
        return it_1.getBranches();
      };
      final BiConsumer<Branch, List<BranchTransition>> _function_8 = (Branch branch, List<BranchTransition> branches) -> {
        EObjectExtensions.<BranchTransition>addAllUnOwned(branch.getBranchTransitions_Branch(), branches);
        final Consumer<BranchTransition> _function_9 = (BranchTransition it_1) -> {
          it_1.setBranch_BranchTransition(branch);
        };
        branches.forEach(_function_9);
      };
      it.<ScenarioBranch, BranchTransition>mapAll(_function_7).thenSet(_function_8);
    };
    registry.<ScenarioBranchAction, Branch>configure(ScenarioBranchAction.class, Branch.class, _function_5);
    final Consumer<GeneratorRuleBuilder<ScenarioBranch, BranchTransition>> _function_6 = (GeneratorRuleBuilder<ScenarioBranch, BranchTransition> it) -> {
      final Function<ScenarioBranch, BranchTransition> _function_7 = (ScenarioBranch it_1) -> {
        BranchTransition _createBranchTransition = UsagemodelFactory.eINSTANCE.createBranchTransition();
        final Procedure1<BranchTransition> _function_8 = (BranchTransition b) -> {
          b.setBranchProbability(it_1.getProbability());
        };
        return ObjectExtensions.<BranchTransition>operator_doubleArrow(_createBranchTransition, _function_8);
      };
      it.setCreate(_function_7);
      final Function<ScenarioBranch, EList<ScenarioContent>> _function_8 = (ScenarioBranch it_1) -> {
        return it_1.getContents();
      };
      final BiConsumer<BranchTransition, List<AbstractUserAction>> _function_9 = (BranchTransition branch, List<AbstractUserAction> actions) -> {
        final ScenarioBehaviour behavior = UsageProfileConfigurer.createScenarioBehavior(actions);
        branch.setBranchedBehaviour_BranchTransition(behavior);
        behavior.setBranchTransition_ScenarioBehaviour(branch);
      };
      it.<ScenarioContent, AbstractUserAction>mapAll(_function_8).thenSet(_function_9);
    };
    registry.<ScenarioBranch, BranchTransition>configure(ScenarioBranch.class, BranchTransition.class, _function_6);
    final Consumer<GeneratorRuleBuilder<ScenarioDelayAction, Delay>> _function_7 = (GeneratorRuleBuilder<ScenarioDelayAction, Delay> it) -> {
      final Function<ScenarioDelayAction, Delay> _function_8 = (ScenarioDelayAction it_1) -> {
        return UsagemodelFactory.eINSTANCE.createDelay();
      };
      it.setCreate(_function_8);
      final Function<ScenarioDelayAction, Expression> _function_9 = (ScenarioDelayAction it_1) -> {
        return it_1.getDuration();
      };
      final BiConsumer<Delay, PCMRandomVariable> _function_10 = (Delay delay, PCMRandomVariable duration) -> {
        delay.setTimeSpecification_Delay(duration);
        duration.setDelay_TimeSpecification(delay);
      };
      it.<Expression, PCMRandomVariable>map(_function_9, PCMRandomVariable.class).thenSet(_function_10);
    };
    registry.<ScenarioDelayAction, Delay>configure(ScenarioDelayAction.class, Delay.class, _function_7);
    final Consumer<GeneratorRuleBuilder<EntryLevelSystemCallAction, EntryLevelSystemCall>> _function_8 = (GeneratorRuleBuilder<EntryLevelSystemCallAction, EntryLevelSystemCall> it) -> {
      final Function<EntryLevelSystemCallAction, EntryLevelSystemCall> _function_9 = (EntryLevelSystemCallAction it_1) -> {
        EntryLevelSystemCall _createEntryLevelSystemCall = UsagemodelFactory.eINSTANCE.createEntryLevelSystemCall();
        final Procedure1<EntryLevelSystemCall> _function_10 = (EntryLevelSystemCall c) -> {
          c.setEntityName(it_1.getSignature().getName());
        };
        return ObjectExtensions.<EntryLevelSystemCall>operator_doubleArrow(_createEntryLevelSystemCall, _function_10);
      };
      it.setCreate(_function_9);
      final Function<EntryLevelSystemCallAction, SystemProvidedRole> _function_10 = (EntryLevelSystemCallAction it_1) -> {
        return it_1.getRole();
      };
      final BiConsumer<EntryLevelSystemCall, ProvidedDelegationConnector> _function_11 = (EntryLevelSystemCall call, ProvidedDelegationConnector role) -> {
        call.setProvidedRole_EntryLevelSystemCall(role.getOuterProvidedRole_ProvidedDelegationConnector());
      };
      it.<SystemProvidedRole, ProvidedDelegationConnector>map(_function_10, ProvidedDelegationConnector.class).thenSet(_function_11);
      final Function<EntryLevelSystemCallAction, Signature> _function_12 = (EntryLevelSystemCallAction it_1) -> {
        return it_1.getSignature();
      };
      final BiConsumer<EntryLevelSystemCall, OperationSignature> _function_13 = (EntryLevelSystemCall call, OperationSignature signature) -> {
        call.setOperationSignature__EntryLevelSystemCall(signature);
      };
      it.<Signature, OperationSignature>map(_function_12).thenSet(_function_13);
      final Function<EntryLevelSystemCallAction, EList<ParameterSpecification>> _function_14 = (EntryLevelSystemCallAction it_1) -> {
        return it_1.getParameters();
      };
      final BiConsumer<EntryLevelSystemCall, List<VariableUsage>> _function_15 = (EntryLevelSystemCall call, List<VariableUsage> params) -> {
        EObjectExtensions.<VariableUsage>addAllUnOwned(call.getInputParameterUsages_EntryLevelSystemCall(), params);
        final Consumer<VariableUsage> _function_16 = (VariableUsage it_1) -> {
          it_1.setEntryLevelSystemCall_InputParameterUsage(call);
        };
        params.forEach(_function_16);
      };
      it.<ParameterSpecification, VariableUsage>mapAll(_function_14).thenSet(_function_15);
      final Function<EntryLevelSystemCallAction, List<ResultSpecification>> _function_16 = (EntryLevelSystemCallAction it_1) -> {
        List<ResultSpecification> _xifexpression = null;
        ResultAssignment _result = it_1.getResult();
        if ((_result instanceof ComplexResultAssignment)) {
          ResultAssignment _result_1 = it_1.getResult();
          _xifexpression = ((ComplexResultAssignment) _result_1).getSpecification();
        } else {
          _xifexpression = CollectionLiterals.<ResultSpecification>emptyList();
        }
        return _xifexpression;
      };
      final BiConsumer<EntryLevelSystemCall, List<VariableUsage>> _function_17 = (EntryLevelSystemCall action, List<VariableUsage> specs) -> {
        EObjectExtensions.<VariableUsage>addAllUnOwned(action.getOutputParameterUsages_EntryLevelSystemCall(), specs);
        final Consumer<VariableUsage> _function_18 = (VariableUsage it_1) -> {
          it_1.setEntryLevelSystemCall_OutputParameterUsage(action);
        };
        specs.forEach(_function_18);
      };
      it.<ResultSpecification, VariableUsage>mapAll(_function_16).thenSet(_function_17);
      final Function<EntryLevelSystemCallAction, ResultAssignment> _function_18 = (EntryLevelSystemCallAction it_1) -> {
        ResultAssignment _xifexpression = null;
        ResultAssignment _result = it_1.getResult();
        if ((_result instanceof ComplexResultAssignment)) {
          _xifexpression = null;
        } else {
          _xifexpression = it_1.getResult();
        }
        return _xifexpression;
      };
      final BiConsumer<EntryLevelSystemCall, VariableUsage> _function_19 = (EntryLevelSystemCall action, VariableUsage result) -> {
        action.getOutputParameterUsages_EntryLevelSystemCall().add(result);
        result.setEntryLevelSystemCall_OutputParameterUsage(action);
      };
      it.<ResultAssignment, VariableUsage>map(_function_18).thenSet(_function_19);
    };
    registry.<EntryLevelSystemCallAction, EntryLevelSystemCall>configure(EntryLevelSystemCallAction.class, EntryLevelSystemCall.class, _function_8);
  }

  private static ScenarioBehaviour createScenarioBehavior(final List<? extends AbstractUserAction> actions) {
    final ScenarioBehaviour behavior = UsagemodelFactory.eINSTANCE.createScenarioBehaviour();
    behavior.getActions_ScenarioBehaviour().add(UsagemodelFactory.eINSTANCE.createStart());
    behavior.getActions_ScenarioBehaviour().addAll(actions);
    behavior.getActions_ScenarioBehaviour().add(UsagemodelFactory.eINSTANCE.createStop());
    final Consumer<AbstractUserAction> _function = (AbstractUserAction it) -> {
      it.setScenarioBehaviour_AbstractUserAction(behavior);
    };
    actions.forEach(_function);
    UsageProfileConfigurer.updatePreviousAssignmentsForUser(behavior.getActions_ScenarioBehaviour());
    UsageProfileConfigurer.updateSuccessorAssignmentsforUser(behavior.getActions_ScenarioBehaviour());
    return behavior;
  }

  private static void updatePreviousAssignmentsForUser(final EList<? extends AbstractUserAction> actions) {
    for (int i = 1; (i < ((Object[])Conversions.unwrapArray(actions, Object.class)).length); i++) {
      AbstractUserAction _get = actions.get(i);
      _get.setPredecessor(actions.get((i - 1)));
    }
  }

  private static void updateSuccessorAssignmentsforUser(final EList<? extends AbstractUserAction> actions) {
    for (int i = 0; (i < (((Object[])Conversions.unwrapArray(actions, Object.class)).length - 1)); i++) {
      AbstractUserAction _get = actions.get(i);
      _get.setSuccessor(actions.get((i + 1)));
    }
  }
}
