package org.palladiosimulator.textual.tpcm.generator.pcm;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.palladiosimulator.pcm.allocation.AllocationFactory;
import org.palladiosimulator.textual.commons.generator.registry.GeneratorRuleRegistrationFacade;
import org.palladiosimulator.textual.commons.generator.registry.GeneratorRulesRegistrationDelegate;
import org.palladiosimulator.textual.commons.generator.rules.GeneratorRuleBuilder;
import org.palladiosimulator.textual.tpcm.language.Allocation;
import org.palladiosimulator.textual.tpcm.language.AllocationContext;
import org.palladiosimulator.textual.tpcm.language.AssemblyContext;
import org.palladiosimulator.textual.tpcm.language.ResourceContainer;
import org.palladiosimulator.textual.tpcm.language.ResourceEnvironment;

@SuppressWarnings("all")
public class AllocationConfigurer implements GeneratorRulesRegistrationDelegate {
  @Override
  public void doRegistration(final GeneratorRuleRegistrationFacade registry) {
    final Consumer<GeneratorRuleBuilder<Allocation, org.palladiosimulator.pcm.allocation.Allocation>> _function = (GeneratorRuleBuilder<Allocation, org.palladiosimulator.pcm.allocation.Allocation> it) -> {
      final Function<Allocation, org.palladiosimulator.pcm.allocation.Allocation> _function_1 = (Allocation it_1) -> {
        org.palladiosimulator.pcm.allocation.Allocation _createAllocation = AllocationFactory.eINSTANCE.createAllocation();
        final Procedure1<org.palladiosimulator.pcm.allocation.Allocation> _function_2 = (org.palladiosimulator.pcm.allocation.Allocation a) -> {
          a.setEntityName(it_1.getName());
        };
        return ObjectExtensions.<org.palladiosimulator.pcm.allocation.Allocation>operator_doubleArrow(_createAllocation, _function_2);
      };
      it.setCreate(_function_1);
      final Function<Allocation, List<SingleAssemblyAllocation>> _function_2 = (Allocation it_1) -> {
        final Function1<AllocationContext, List<SingleAssemblyAllocation>> _function_3 = (AllocationContext it_2) -> {
          return SingleAssemblyAllocation.getAllFrom(it_2);
        };
        return IterableExtensions.<SingleAssemblyAllocation>toList(IterableExtensions.<AllocationContext, SingleAssemblyAllocation>flatMap(Iterables.<AllocationContext>filter(it_1.getContents(), AllocationContext.class), _function_3));
      };
      final BiConsumer<org.palladiosimulator.pcm.allocation.Allocation, List<org.palladiosimulator.pcm.allocation.AllocationContext>> _function_3 = (org.palladiosimulator.pcm.allocation.Allocation allocation, List<org.palladiosimulator.pcm.allocation.AllocationContext> contexts) -> {
        EObjectExtensions.<org.palladiosimulator.pcm.allocation.AllocationContext>addAllUnOwned(allocation.getAllocationContexts_Allocation(), contexts);
      };
      it.<SingleAssemblyAllocation, org.palladiosimulator.pcm.allocation.AllocationContext>mapAll(_function_2).thenSet(_function_3);
      final Function<Allocation, EObject> _function_4 = (Allocation it_1) -> {
        final Function1<AllocationContext, EObject> _function_5 = (AllocationContext it_2) -> {
          return it_2.getSpec().getContainer().eContainer();
        };
        final Function1<EObject, Boolean> _function_6 = (EObject it_2) -> {
          return Boolean.valueOf((it_2 instanceof ResourceEnvironment));
        };
        return IterableExtensions.<EObject>findFirst(IterableExtensions.<AllocationContext, EObject>map(Iterables.<AllocationContext>filter(it_1.getContents(), AllocationContext.class), _function_5), _function_6);
      };
      final BiConsumer<org.palladiosimulator.pcm.allocation.Allocation, org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment> _function_5 = (org.palladiosimulator.pcm.allocation.Allocation alloc, org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment env) -> {
        alloc.setTargetResourceEnvironment_Allocation(env);
      };
      it.<EObject, org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment>map(_function_4).thenSet(_function_5);
      final Function<Allocation, EObject> _function_6 = (Allocation it_1) -> {
        final Function1<AllocationContext, List<SingleAssemblyAllocation>> _function_7 = (AllocationContext it_2) -> {
          return SingleAssemblyAllocation.getAllFrom(it_2);
        };
        final Function1<SingleAssemblyAllocation, EObject> _function_8 = (SingleAssemblyAllocation it_2) -> {
          return it_2.context.eContainer();
        };
        final Function1<EObject, Boolean> _function_9 = (EObject it_2) -> {
          return Boolean.valueOf((it_2 instanceof org.palladiosimulator.textual.tpcm.language.System));
        };
        return IterableExtensions.<EObject>findFirst(IterableExtensions.<SingleAssemblyAllocation, EObject>map(IterableExtensions.<AllocationContext, SingleAssemblyAllocation>flatMap(Iterables.<AllocationContext>filter(it_1.getContents(), AllocationContext.class), _function_7), _function_8), _function_9);
      };
      final BiConsumer<org.palladiosimulator.pcm.allocation.Allocation, org.palladiosimulator.pcm.system.System> _function_7 = (org.palladiosimulator.pcm.allocation.Allocation alloc, org.palladiosimulator.pcm.system.System sys) -> {
        alloc.setSystem_Allocation(sys);
      };
      it.<EObject, org.palladiosimulator.pcm.system.System>map(_function_6).thenSet(_function_7);
    };
    registry.<Allocation, org.palladiosimulator.pcm.allocation.Allocation>configure(Allocation.class, org.palladiosimulator.pcm.allocation.Allocation.class, _function);
    final Consumer<GeneratorRuleBuilder<SingleAssemblyAllocation, org.palladiosimulator.pcm.allocation.AllocationContext>> _function_1 = (GeneratorRuleBuilder<SingleAssemblyAllocation, org.palladiosimulator.pcm.allocation.AllocationContext> it) -> {
      final Function<SingleAssemblyAllocation, org.palladiosimulator.pcm.allocation.AllocationContext> _function_2 = (SingleAssemblyAllocation it_1) -> {
        org.palladiosimulator.pcm.allocation.AllocationContext _createAllocationContext = AllocationFactory.eINSTANCE.createAllocationContext();
        final Procedure1<org.palladiosimulator.pcm.allocation.AllocationContext> _function_3 = (org.palladiosimulator.pcm.allocation.AllocationContext a) -> {
          a.setEntityName(it_1.name);
        };
        return ObjectExtensions.<org.palladiosimulator.pcm.allocation.AllocationContext>operator_doubleArrow(_createAllocationContext, _function_3);
      };
      it.setCreate(_function_2);
      final Function<SingleAssemblyAllocation, AssemblyContext> _function_3 = (SingleAssemblyAllocation it_1) -> {
        return it_1.context;
      };
      final BiConsumer<org.palladiosimulator.pcm.allocation.AllocationContext, org.palladiosimulator.pcm.core.composition.AssemblyContext> _function_4 = (org.palladiosimulator.pcm.allocation.AllocationContext context, org.palladiosimulator.pcm.core.composition.AssemblyContext assembly) -> {
        context.setAssemblyContext_AllocationContext(assembly);
      };
      it.<AssemblyContext, org.palladiosimulator.pcm.core.composition.AssemblyContext>map(_function_3).thenSet(_function_4);
      final Function<SingleAssemblyAllocation, ResourceContainer> _function_5 = (SingleAssemblyAllocation it_1) -> {
        return it_1.container;
      };
      final BiConsumer<org.palladiosimulator.pcm.allocation.AllocationContext, org.palladiosimulator.pcm.resourceenvironment.ResourceContainer> _function_6 = (org.palladiosimulator.pcm.allocation.AllocationContext context, org.palladiosimulator.pcm.resourceenvironment.ResourceContainer container) -> {
        context.setResourceContainer_AllocationContext(container);
      };
      it.<ResourceContainer, org.palladiosimulator.pcm.resourceenvironment.ResourceContainer>map(_function_5).thenSet(_function_6);
    };
    registry.<SingleAssemblyAllocation, org.palladiosimulator.pcm.allocation.AllocationContext>configure(SingleAssemblyAllocation.class, org.palladiosimulator.pcm.allocation.AllocationContext.class, _function_1);
  }
}
