package org.palladiosimulator.textual.tpcm.generator.pcm;

import com.google.common.base.Objects;
import de.uka.ipd.sdq.stoex.Expression;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.palladiosimulator.pcm.core.entity.NamedElement;
import org.palladiosimulator.textual.tpcm.language.Initialization;
import org.palladiosimulator.textual.tpcm.language.PropertyInitializer;

@SuppressWarnings("all")
public class ConfigurerHelper {
  public static boolean hasEmptyName(final NamedElement entity) {
    return (((entity.getEntityName() == null) || entity.getEntityName().isEmpty()) || Objects.equal(entity.getEntityName(), "aName"));
  }

  public static EObject getInitPropertyExpression(final Initialization init, final String propertyName) {
    EList<PropertyInitializer> _contents = null;
    if (init!=null) {
      _contents=init.getContents();
    }
    PropertyInitializer _findFirst = null;
    if (_contents!=null) {
      final Function1<PropertyInitializer, Boolean> _function = (PropertyInitializer it) -> {
        String _name = it.getProperty().getName();
        return Boolean.valueOf(Objects.equal(_name, propertyName));
      };
      _findFirst=IterableExtensions.<PropertyInitializer>findFirst(_contents, _function);
    }
    final PropertyInitializer prop = _findFirst;
    EObject _elvis = null;
    Expression _specification = null;
    if (prop!=null) {
      _specification=prop.getSpecification();
    }
    if (_specification != null) {
      _elvis = _specification;
    } else {
      EObject _referencedElement = null;
      if (prop!=null) {
        _referencedElement=prop.getReferencedElement();
      }
      _elvis = _referencedElement;
    }
    return _elvis;
  }
}
