package org.palladiosimulator.textual.tpcm.generator.pcm;

import com.google.common.collect.Iterables;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class EObjectExtensions {
  public static <T extends EObject> boolean addAllUnOwned(final EList<T> list, final Iterable<T> toAdd) {
    final Function1<T, Boolean> _function = (T it) -> {
      EObject _eContainer = it.eContainer();
      return Boolean.valueOf((_eContainer == null));
    };
    return Iterables.<T>addAll(list, IterableExtensions.<T>filter(toAdd, _function));
  }
}
