package org.palladiosimulator.textual.tpcm.generator.pcm;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.uka.ipd.sdq.stoex.AbstractNamedReference;
import de.uka.ipd.sdq.stoex.Expression;
import de.uka.ipd.sdq.stoex.NamespaceReference;
import de.uka.ipd.sdq.stoex.StoexFactory;
import de.uka.ipd.sdq.stoex.VariableReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure2;
import org.palladiosimulator.pcm.core.CoreFactory;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.core.entity.EntityFactory;
import org.palladiosimulator.pcm.core.entity.ResourceRequiredRole;
import org.palladiosimulator.pcm.parameter.ParameterFactory;
import org.palladiosimulator.pcm.parameter.VariableCharacterisation;
import org.palladiosimulator.pcm.parameter.VariableCharacterisationType;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.CollectionDataType;
import org.palladiosimulator.pcm.repository.CompositeDataType;
import org.palladiosimulator.pcm.repository.DataType;
import org.palladiosimulator.pcm.repository.EventGroup;
import org.palladiosimulator.pcm.repository.EventType;
import org.palladiosimulator.pcm.repository.InfrastructureInterface;
import org.palladiosimulator.pcm.repository.InfrastructureProvidedRole;
import org.palladiosimulator.pcm.repository.InnerDeclaration;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.Parameter;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.repository.PrimitiveDataType;
import org.palladiosimulator.pcm.repository.PrimitiveTypeEnum;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RepositoryFactory;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.SinkRole;
import org.palladiosimulator.pcm.repository.SourceRole;
import org.palladiosimulator.pcm.resourcetype.ResourceSignature;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.AbstractBranchTransition;
import org.palladiosimulator.pcm.seff.AcquireAction;
import org.palladiosimulator.pcm.seff.BranchAction;
import org.palladiosimulator.pcm.seff.CollectionIteratorAction;
import org.palladiosimulator.pcm.seff.EmitEventAction;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.GuardedBranchTransition;
import org.palladiosimulator.pcm.seff.InternalAction;
import org.palladiosimulator.pcm.seff.LoopAction;
import org.palladiosimulator.pcm.seff.ProbabilisticBranchTransition;
import org.palladiosimulator.pcm.seff.ReleaseAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.SeffFactory;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.pcm.seff.SetVariableAction;
import org.palladiosimulator.pcm.seff.seff_performance.ResourceCall;
import org.palladiosimulator.pcm.seff.seff_performance.SeffPerformanceFactory;
import org.palladiosimulator.textual.commons.generator.registry.GeneratorRuleRegistrationFacade;
import org.palladiosimulator.textual.commons.generator.registry.GeneratorRulesRegistrationDelegate;
import org.palladiosimulator.textual.commons.generator.rules.GeneratorRuleBuilder;
import org.palladiosimulator.textual.tpcm.language.AbsoluteReference;
import org.palladiosimulator.textual.tpcm.language.CharacteristicReference;
import org.palladiosimulator.textual.tpcm.language.CollectionDatatype;
import org.palladiosimulator.textual.tpcm.language.ComplexResultAssignment;
import org.palladiosimulator.textual.tpcm.language.Component;
import org.palladiosimulator.textual.tpcm.language.ComposedDatatype;
import org.palladiosimulator.textual.tpcm.language.ComposedDatatypeElement;
import org.palladiosimulator.textual.tpcm.language.Datatype;
import org.palladiosimulator.textual.tpcm.language.DomainInterface;
import org.palladiosimulator.textual.tpcm.language.DomainInterfaceProvidedRole;
import org.palladiosimulator.textual.tpcm.language.EventSignature;
import org.palladiosimulator.textual.tpcm.language.FailureType;
import org.palladiosimulator.textual.tpcm.language.Interface;
import org.palladiosimulator.textual.tpcm.language.InterfaceContent;
import org.palladiosimulator.textual.tpcm.language.InterfaceRequiredRole;
import org.palladiosimulator.textual.tpcm.language.InternalInterfaceProvidedRole;
import org.palladiosimulator.textual.tpcm.language.ParameterSpecification;
import org.palladiosimulator.textual.tpcm.language.PrimitiveDatatype;
import org.palladiosimulator.textual.tpcm.language.PrimitiveResultAssignment;
import org.palladiosimulator.textual.tpcm.language.RelativeReference;
import org.palladiosimulator.textual.tpcm.language.Repository;
import org.palladiosimulator.textual.tpcm.language.ResourceInterface;
import org.palladiosimulator.textual.tpcm.language.ResourceTypeRepository;
import org.palladiosimulator.textual.tpcm.language.ResultAssignment;
import org.palladiosimulator.textual.tpcm.language.ResultSpecification;
import org.palladiosimulator.textual.tpcm.language.Role;
import org.palladiosimulator.textual.tpcm.language.SEFF;
import org.palladiosimulator.textual.tpcm.language.SEFFAssignment;
import org.palladiosimulator.textual.tpcm.language.SEFFCallAction;
import org.palladiosimulator.textual.tpcm.language.SEFFConditionalAction;
import org.palladiosimulator.textual.tpcm.language.SEFFConditionalAlternative;
import org.palladiosimulator.textual.tpcm.language.SEFFConditionalElse;
import org.palladiosimulator.textual.tpcm.language.SEFFConditionalElseIf;
import org.palladiosimulator.textual.tpcm.language.SEFFContent;
import org.palladiosimulator.textual.tpcm.language.SEFFIterateAction;
import org.palladiosimulator.textual.tpcm.language.SEFFLoopAction;
import org.palladiosimulator.textual.tpcm.language.SEFFProbabilisticAction;
import org.palladiosimulator.textual.tpcm.language.SEFFProbabilisticBranch;
import org.palladiosimulator.textual.tpcm.language.Signature;

@SuppressWarnings("all")
public class RepositoryConfigurer implements GeneratorRulesRegistrationDelegate {
  private static final String CAPACITY_PROPERTY_NAME = "capacity";

  private static final String ACQUIRE_SIGNATURE_NAME = "acquire";

  private static final String RELEASE_SIGNATURE_NAME = "release";

  @Override
  public void doRegistration(final GeneratorRuleRegistrationFacade registry) {
    final Consumer<GeneratorRuleBuilder<Repository, org.palladiosimulator.pcm.repository.Repository>> _function = (GeneratorRuleBuilder<Repository, org.palladiosimulator.pcm.repository.Repository> it) -> {
      final Function<Repository, org.palladiosimulator.pcm.repository.Repository> _function_1 = (Repository repo) -> {
        org.palladiosimulator.pcm.repository.Repository _createRepository = RepositoryFactory.eINSTANCE.createRepository();
        final Procedure1<org.palladiosimulator.pcm.repository.Repository> _function_2 = (org.palladiosimulator.pcm.repository.Repository it_1) -> {
          it_1.setEntityName(repo.getName());
        };
        return ObjectExtensions.<org.palladiosimulator.pcm.repository.Repository>operator_doubleArrow(_createRepository, _function_2);
      };
      it.setCreate(_function_1);
      final Function<Repository, List<Datatype>> _function_2 = (Repository it_1) -> {
        return IterableExtensions.<Datatype>toList(Iterables.<Datatype>filter(it_1.getContents(), Datatype.class));
      };
      final BiConsumer<org.palladiosimulator.pcm.repository.Repository, List<DataType>> _function_3 = (org.palladiosimulator.pcm.repository.Repository repo, List<DataType> types) -> {
        final Function1<DataType, Boolean> _function_4 = (DataType it_1) -> {
          org.palladiosimulator.pcm.repository.Repository _repository__DataType = it_1.getRepository__DataType();
          return Boolean.valueOf((_repository__DataType == null));
        };
        final Iterable<DataType> unownedDataTypes = IterableExtensions.<DataType>filter(types, _function_4);
        Iterables.<DataType>addAll(repo.getDataTypes__Repository(), unownedDataTypes);
        final Consumer<DataType> _function_5 = (DataType it_1) -> {
          RepositoryConfigurer.assignRepository(it_1, repo);
        };
        unownedDataTypes.forEach(_function_5);
      };
      it.<Datatype, DataType>mapAll(_function_2).thenSet(_function_3);
      final Function<Repository, List<FailureType>> _function_4 = (Repository it_1) -> {
        return IterableExtensions.<FailureType>toList(Iterables.<FailureType>filter(it_1.getContents(), FailureType.class));
      };
      final BiConsumer<org.palladiosimulator.pcm.repository.Repository, List<org.palladiosimulator.pcm.reliability.FailureType>> _function_5 = (org.palladiosimulator.pcm.repository.Repository repo, List<org.palladiosimulator.pcm.reliability.FailureType> failures) -> {
        EObjectExtensions.<org.palladiosimulator.pcm.reliability.FailureType>addAllUnOwned(repo.getFailureTypes__Repository(), failures);
      };
      it.<FailureType, org.palladiosimulator.pcm.reliability.FailureType>mapAll(_function_4).thenSet(_function_5);
      final Function<Repository, List<Component>> _function_6 = (Repository it_1) -> {
        return IterableExtensions.<Component>toList(Iterables.<Component>filter(it_1.getContents(), Component.class));
      };
      final BiConsumer<org.palladiosimulator.pcm.repository.Repository, List<RepositoryComponent>> _function_7 = (org.palladiosimulator.pcm.repository.Repository repo, List<RepositoryComponent> components) -> {
        EObjectExtensions.<RepositoryComponent>addAllUnOwned(repo.getComponents__Repository(), components);
      };
      it.<Component, RepositoryComponent>mapAll(_function_6).thenSet(_function_7);
      final Function<Repository, List<Interface>> _function_8 = (Repository it_1) -> {
        return IterableExtensions.<Interface>toList(Iterables.<Interface>filter(it_1.getContents(), Interface.class));
      };
      final BiConsumer<org.palladiosimulator.pcm.repository.Repository, List<org.palladiosimulator.pcm.repository.Interface>> _function_9 = (org.palladiosimulator.pcm.repository.Repository repo, List<org.palladiosimulator.pcm.repository.Interface> interfaces) -> {
        EObjectExtensions.<org.palladiosimulator.pcm.repository.Interface>addAllUnOwned(repo.getInterfaces__Repository(), interfaces);
      };
      it.<Interface, org.palladiosimulator.pcm.repository.Interface>mapAll(_function_8).thenSet(_function_9);
    };
    registry.<Repository, org.palladiosimulator.pcm.repository.Repository>configure(Repository.class, org.palladiosimulator.pcm.repository.Repository.class, _function);
    RepositoryConfigurer.configureRepositoryDatatypes(registry);
    RepositoryConfigurer.configureRepositoryComponent(registry);
  }

  protected static void configureRepositoryComponent(final GeneratorRuleRegistrationFacade registry) {
    final Consumer<GeneratorRuleBuilder<Component, BasicComponent>> _function = (GeneratorRuleBuilder<Component, BasicComponent> it) -> {
      final Function<Component, BasicComponent> _function_1 = (Component it_1) -> {
        BasicComponent _createBasicComponent = RepositoryFactory.eINSTANCE.createBasicComponent();
        final Procedure1<BasicComponent> _function_2 = (BasicComponent c) -> {
          c.setEntityName(it_1.getName());
        };
        return ObjectExtensions.<BasicComponent>operator_doubleArrow(_createBasicComponent, _function_2);
      };
      it.setCreate(_function_1);
      final Function<Component, List<DomainInterfaceProvidedRole>> _function_2 = (Component it_1) -> {
        return IterableExtensions.<DomainInterfaceProvidedRole>toList(Iterables.<DomainInterfaceProvidedRole>filter(it_1.getContents(), DomainInterfaceProvidedRole.class));
      };
      final BiConsumer<BasicComponent, List<ProvidedRole>> _function_3 = (BasicComponent component, List<ProvidedRole> provided) -> {
        EObjectExtensions.<ProvidedRole>addAllUnOwned(component.getProvidedRoles_InterfaceProvidingEntity(), provided);
      };
      it.<DomainInterfaceProvidedRole, ProvidedRole>mapAll(_function_2).thenSet(_function_3);
      final Function<Component, List<InterfaceRequiredRole>> _function_4 = (Component it_1) -> {
        return IterableExtensions.<InterfaceRequiredRole>toList(Iterables.<InterfaceRequiredRole>filter(it_1.getContents(), InterfaceRequiredRole.class));
      };
      final BiConsumer<BasicComponent, List<Object>> _function_5 = (BasicComponent component, List<Object> required) -> {
        EObjectExtensions.<RequiredRole>addAllUnOwned(component.getRequiredRoles_InterfaceRequiringEntity(), Iterables.<RequiredRole>filter(required, RequiredRole.class));
        EObjectExtensions.<ResourceRequiredRole>addAllUnOwned(component.getResourceRequiredRoles__ResourceInterfaceRequiringEntity(), 
          Iterables.<ResourceRequiredRole>filter(required, ResourceRequiredRole.class));
      };
      it.<InterfaceRequiredRole, Object>mapAll(_function_4).thenSet(_function_5);
      final Function<Component, List<InternalInterfaceProvidedRole>> _function_6 = (Component it_1) -> {
        final Function1<InternalInterfaceProvidedRole, Boolean> _function_7 = (InternalInterfaceProvidedRole it_2) -> {
          EObject _eContainer = it_2.getType().eContainer();
          return Boolean.valueOf((_eContainer instanceof ResourceTypeRepository));
        };
        return IterableExtensions.<InternalInterfaceProvidedRole>toList(IterableExtensions.<InternalInterfaceProvidedRole>filter(Iterables.<InternalInterfaceProvidedRole>filter(it_1.getContents(), InternalInterfaceProvidedRole.class), _function_7));
      };
      final BiConsumer<BasicComponent, List<PassiveResource>> _function_7 = (BasicComponent component, List<PassiveResource> resources) -> {
        EObjectExtensions.<PassiveResource>addAllUnOwned(component.getPassiveResource_BasicComponent(), resources);
      };
      it.<InternalInterfaceProvidedRole, PassiveResource>mapAll(_function_6, PassiveResource.class).thenSet(_function_7);
      final Function<Component, List<SEFF>> _function_8 = (Component it_1) -> {
        return IterableExtensions.<SEFF>toList(Iterables.<SEFF>filter(it_1.getContents(), SEFF.class));
      };
      final BiConsumer<BasicComponent, List<ServiceEffectSpecification>> _function_9 = (BasicComponent component, List<ServiceEffectSpecification> seffs) -> {
        EObjectExtensions.<ServiceEffectSpecification>addAllUnOwned(component.getServiceEffectSpecifications__BasicComponent(), seffs);
      };
      it.<SEFF, ServiceEffectSpecification>mapAll(_function_8).thenSet(_function_9);
    };
    registry.<Component, BasicComponent>configure(Component.class, BasicComponent.class, _function);
    final Consumer<GeneratorRuleBuilder<InternalInterfaceProvidedRole, InfrastructureProvidedRole>> _function_1 = (GeneratorRuleBuilder<InternalInterfaceProvidedRole, InfrastructureProvidedRole> it) -> {
      final Function<InternalInterfaceProvidedRole, InfrastructureProvidedRole> _function_2 = (InternalInterfaceProvidedRole it_1) -> {
        InfrastructureProvidedRole _createInfrastructureProvidedRole = RepositoryFactory.eINSTANCE.createInfrastructureProvidedRole();
        final Procedure1<InfrastructureProvidedRole> _function_3 = (InfrastructureProvidedRole r) -> {
          r.setEntityName(it_1.getName());
        };
        return ObjectExtensions.<InfrastructureProvidedRole>operator_doubleArrow(_createInfrastructureProvidedRole, _function_3);
      };
      it.setCreate(_function_2);
      final Predicate<InternalInterfaceProvidedRole> _function_3 = (InternalInterfaceProvidedRole it_1) -> {
        EObject _eContainer = it_1.getType().eContainer();
        return (!(_eContainer instanceof ResourceTypeRepository));
      };
      it.setWhen(_function_3);
      final Function<InternalInterfaceProvidedRole, Interface> _function_4 = (InternalInterfaceProvidedRole it_1) -> {
        return it_1.getType();
      };
      final BiConsumer<InfrastructureProvidedRole, InfrastructureInterface> _function_5 = (InfrastructureProvidedRole role, InfrastructureInterface iface) -> {
        role.setProvidedInterface__InfrastructureProvidedRole(iface);
      };
      it.<Interface, InfrastructureInterface>map(_function_4).thenSet(_function_5);
    };
    registry.<InternalInterfaceProvidedRole, InfrastructureProvidedRole>configure(InternalInterfaceProvidedRole.class, InfrastructureProvidedRole.class, _function_1);
    final Consumer<GeneratorRuleBuilder<InternalInterfaceProvidedRole, PassiveResource>> _function_2 = (GeneratorRuleBuilder<InternalInterfaceProvidedRole, PassiveResource> it) -> {
      final Function<InternalInterfaceProvidedRole, PassiveResource> _function_3 = (InternalInterfaceProvidedRole it_1) -> {
        PassiveResource _createPassiveResource = RepositoryFactory.eINSTANCE.createPassiveResource();
        final Procedure1<PassiveResource> _function_4 = (PassiveResource r) -> {
          r.setEntityName(it_1.getName());
        };
        return ObjectExtensions.<PassiveResource>operator_doubleArrow(_createPassiveResource, _function_4);
      };
      it.setCreate(_function_3);
      final Predicate<InternalInterfaceProvidedRole> _function_4 = (InternalInterfaceProvidedRole it_1) -> {
        EObject _eContainer = it_1.getType().eContainer();
        return (_eContainer instanceof ResourceTypeRepository);
      };
      it.setWhen(_function_4);
      final Function<InternalInterfaceProvidedRole, EObject> _function_5 = (InternalInterfaceProvidedRole it_1) -> {
        return ConfigurerHelper.getInitPropertyExpression(it_1.getInitialization(), RepositoryConfigurer.CAPACITY_PROPERTY_NAME);
      };
      final BiConsumer<PassiveResource, PCMRandomVariable> _function_6 = (PassiveResource resource, PCMRandomVariable capacity) -> {
        resource.setCapacity_PassiveResource(capacity);
      };
      it.<EObject, PCMRandomVariable>map(_function_5, PCMRandomVariable.class).thenSet(_function_6);
    };
    registry.<InternalInterfaceProvidedRole, PassiveResource>configure(InternalInterfaceProvidedRole.class, PassiveResource.class, _function_2);
    RepositoryConfigurer.configureRepositoryComponentSEFF(registry);
    final Consumer<GeneratorRuleBuilder<DomainInterfaceProvidedRole, OperationProvidedRole>> _function_3 = (GeneratorRuleBuilder<DomainInterfaceProvidedRole, OperationProvidedRole> it) -> {
      final Function<DomainInterfaceProvidedRole, OperationProvidedRole> _function_4 = (DomainInterfaceProvidedRole it_1) -> {
        OperationProvidedRole _createOperationProvidedRole = RepositoryFactory.eINSTANCE.createOperationProvidedRole();
        final Procedure1<OperationProvidedRole> _function_5 = (OperationProvidedRole r) -> {
          r.setEntityName(it_1.getName());
        };
        return ObjectExtensions.<OperationProvidedRole>operator_doubleArrow(_createOperationProvidedRole, _function_5);
      };
      it.setCreate(_function_4);
      final Predicate<DomainInterfaceProvidedRole> _function_5 = (DomainInterfaceProvidedRole it_1) -> {
        final Function1<InterfaceContent, Boolean> _function_6 = (InterfaceContent it_2) -> {
          return Boolean.valueOf((it_2 instanceof EventSignature));
        };
        boolean _exists = IterableExtensions.<InterfaceContent>exists(it_1.getType().getContents(), _function_6);
        return (!_exists);
      };
      it.setWhen(_function_5);
      final Function<DomainInterfaceProvidedRole, Interface> _function_6 = (DomainInterfaceProvidedRole it_1) -> {
        return it_1.getType();
      };
      final BiConsumer<OperationProvidedRole, OperationInterface> _function_7 = (OperationProvidedRole role, OperationInterface iface) -> {
        role.setProvidedInterface__OperationProvidedRole(iface);
      };
      it.<Interface, OperationInterface>map(_function_6).thenSet(_function_7);
    };
    registry.<DomainInterfaceProvidedRole, OperationProvidedRole>configure(DomainInterfaceProvidedRole.class, OperationProvidedRole.class, _function_3);
    final Consumer<GeneratorRuleBuilder<DomainInterfaceProvidedRole, SinkRole>> _function_4 = (GeneratorRuleBuilder<DomainInterfaceProvidedRole, SinkRole> it) -> {
      final Function<DomainInterfaceProvidedRole, SinkRole> _function_5 = (DomainInterfaceProvidedRole it_1) -> {
        SinkRole _createSinkRole = RepositoryFactory.eINSTANCE.createSinkRole();
        final Procedure1<SinkRole> _function_6 = (SinkRole r) -> {
          r.setEntityName(it_1.getName());
        };
        return ObjectExtensions.<SinkRole>operator_doubleArrow(_createSinkRole, _function_6);
      };
      it.setCreate(_function_5);
      final Predicate<DomainInterfaceProvidedRole> _function_6 = (DomainInterfaceProvidedRole it_1) -> {
        final Function1<InterfaceContent, Boolean> _function_7 = (InterfaceContent it_2) -> {
          return Boolean.valueOf((it_2 instanceof EventSignature));
        };
        return IterableExtensions.<InterfaceContent>exists(it_1.getType().getContents(), _function_7);
      };
      it.setWhen(_function_6);
      final Function<DomainInterfaceProvidedRole, Interface> _function_7 = (DomainInterfaceProvidedRole it_1) -> {
        return it_1.getType();
      };
      final BiConsumer<SinkRole, EventGroup> _function_8 = (SinkRole role, EventGroup iface) -> {
        role.setEventGroup__SinkRole(iface);
      };
      it.<Interface, EventGroup>map(_function_7).thenSet(_function_8);
    };
    registry.<DomainInterfaceProvidedRole, SinkRole>configure(DomainInterfaceProvidedRole.class, SinkRole.class, _function_4);
    final Consumer<GeneratorRuleBuilder<InterfaceRequiredRole, OperationRequiredRole>> _function_5 = (GeneratorRuleBuilder<InterfaceRequiredRole, OperationRequiredRole> it) -> {
      final Function<InterfaceRequiredRole, OperationRequiredRole> _function_6 = (InterfaceRequiredRole it_1) -> {
        OperationRequiredRole _createOperationRequiredRole = RepositoryFactory.eINSTANCE.createOperationRequiredRole();
        final Procedure1<OperationRequiredRole> _function_7 = (OperationRequiredRole r) -> {
          r.setEntityName(it_1.getName());
        };
        return ObjectExtensions.<OperationRequiredRole>operator_doubleArrow(_createOperationRequiredRole, _function_7);
      };
      it.setCreate(_function_6);
      final Predicate<InterfaceRequiredRole> _function_7 = (InterfaceRequiredRole it_1) -> {
        return ((!IterableExtensions.<InterfaceContent>exists(it_1.getType().getContents(), ((Function1<InterfaceContent, Boolean>) (InterfaceContent it_2) -> {
          return Boolean.valueOf((it_2 instanceof EventSignature));
        }))) && 
          (!(it_1.getType() instanceof ResourceInterface)));
      };
      it.setWhen(_function_7);
      final Function<InterfaceRequiredRole, Interface> _function_8 = (InterfaceRequiredRole it_1) -> {
        return it_1.getType();
      };
      final BiConsumer<OperationRequiredRole, OperationInterface> _function_9 = (OperationRequiredRole role, OperationInterface iface) -> {
        role.setRequiredInterface__OperationRequiredRole(iface);
      };
      it.<Interface, OperationInterface>map(_function_8).thenSet(_function_9);
    };
    registry.<InterfaceRequiredRole, OperationRequiredRole>configure(InterfaceRequiredRole.class, OperationRequiredRole.class, _function_5);
    final Consumer<GeneratorRuleBuilder<InterfaceRequiredRole, SourceRole>> _function_6 = (GeneratorRuleBuilder<InterfaceRequiredRole, SourceRole> it) -> {
      final Function<InterfaceRequiredRole, SourceRole> _function_7 = (InterfaceRequiredRole it_1) -> {
        SourceRole _createSourceRole = RepositoryFactory.eINSTANCE.createSourceRole();
        final Procedure1<SourceRole> _function_8 = (SourceRole r) -> {
          r.setEntityName(it_1.getName());
        };
        return ObjectExtensions.<SourceRole>operator_doubleArrow(_createSourceRole, _function_8);
      };
      it.setCreate(_function_7);
      final Predicate<InterfaceRequiredRole> _function_8 = (InterfaceRequiredRole it_1) -> {
        return (IterableExtensions.<InterfaceContent>exists(it_1.getType().getContents(), ((Function1<InterfaceContent, Boolean>) (InterfaceContent it_2) -> {
          return Boolean.valueOf((it_2 instanceof EventSignature));
        })) && 
          (!(it_1.getType() instanceof ResourceInterface)));
      };
      it.setWhen(_function_8);
      final Function<InterfaceRequiredRole, Interface> _function_9 = (InterfaceRequiredRole it_1) -> {
        return it_1.getType();
      };
      final BiConsumer<SourceRole, EventGroup> _function_10 = (SourceRole role, EventGroup iface) -> {
        role.setEventGroup__SourceRole(iface);
      };
      it.<Interface, EventGroup>map(_function_9).thenSet(_function_10);
    };
    registry.<InterfaceRequiredRole, SourceRole>configure(InterfaceRequiredRole.class, SourceRole.class, _function_6);
    final Consumer<GeneratorRuleBuilder<InterfaceRequiredRole, ResourceRequiredRole>> _function_7 = (GeneratorRuleBuilder<InterfaceRequiredRole, ResourceRequiredRole> it) -> {
      final Function<InterfaceRequiredRole, ResourceRequiredRole> _function_8 = (InterfaceRequiredRole it_1) -> {
        ResourceRequiredRole _createResourceRequiredRole = EntityFactory.eINSTANCE.createResourceRequiredRole();
        final Procedure1<ResourceRequiredRole> _function_9 = (ResourceRequiredRole r) -> {
          r.setEntityName(it_1.getName());
        };
        return ObjectExtensions.<ResourceRequiredRole>operator_doubleArrow(_createResourceRequiredRole, _function_9);
      };
      it.setCreate(_function_8);
      final Predicate<InterfaceRequiredRole> _function_9 = (InterfaceRequiredRole it_1) -> {
        Interface _type = it_1.getType();
        return (_type instanceof ResourceInterface);
      };
      it.setWhen(_function_9);
      final Function<InterfaceRequiredRole, Interface> _function_10 = (InterfaceRequiredRole it_1) -> {
        return it_1.getType();
      };
      final BiConsumer<ResourceRequiredRole, org.palladiosimulator.pcm.resourcetype.ResourceInterface> _function_11 = (ResourceRequiredRole role, org.palladiosimulator.pcm.resourcetype.ResourceInterface iface) -> {
        role.setRequiredResourceInterface__ResourceRequiredRole(iface);
      };
      it.<Interface, org.palladiosimulator.pcm.resourcetype.ResourceInterface>map(_function_10, org.palladiosimulator.pcm.resourcetype.ResourceInterface.class).thenSet(_function_11);
    };
    registry.<InterfaceRequiredRole, ResourceRequiredRole>configure(InterfaceRequiredRole.class, ResourceRequiredRole.class, _function_7);
  }

  protected static void configureRepositoryComponentSEFF(final GeneratorRuleRegistrationFacade registry) {
    final Consumer<GeneratorRuleBuilder<SEFF, ResourceDemandingSEFF>> _function = (GeneratorRuleBuilder<SEFF, ResourceDemandingSEFF> it) -> {
      final Function<SEFF, ResourceDemandingSEFF> _function_1 = (SEFF it_1) -> {
        return SeffFactory.eINSTANCE.createResourceDemandingSEFF();
      };
      it.setCreate(_function_1);
      final Function<SEFF, Signature> _function_2 = (SEFF it_1) -> {
        return it_1.getSignatur();
      };
      final BiConsumer<ResourceDemandingSEFF, OperationSignature> _function_3 = (ResourceDemandingSEFF seff, OperationSignature sig) -> {
        seff.setDescribedService__SEFF(sig);
      };
      it.<Signature, OperationSignature>map(_function_2, OperationSignature.class).thenSet(_function_3);
      final Function<SEFF, EList<SEFFContent>> _function_4 = (SEFF it_1) -> {
        return it_1.getContents();
      };
      final BiConsumer<ResourceDemandingSEFF, List<AbstractAction>> _function_5 = (ResourceDemandingSEFF seff, List<AbstractAction> calls) -> {
        seff.getSteps_Behaviour().add(SeffFactory.eINSTANCE.createStartAction());
        seff.getSteps_Behaviour().addAll(calls);
        seff.getSteps_Behaviour().add(SeffFactory.eINSTANCE.createStopAction());
        RepositoryConfigurer.updatePreviousAssignments(seff.getSteps_Behaviour());
        RepositoryConfigurer.updateSuccessorAssignments(seff.getSteps_Behaviour());
      };
      it.<SEFFContent, AbstractAction>mapAll(_function_4).thenSet(_function_5);
    };
    registry.<SEFF, ResourceDemandingSEFF>configure(SEFF.class, ResourceDemandingSEFF.class, _function);
    final Consumer<GeneratorRuleBuilder<SEFFCallAction, AcquireAction>> _function_1 = (GeneratorRuleBuilder<SEFFCallAction, AcquireAction> it) -> {
      final Function<SEFFCallAction, AcquireAction> _function_2 = (SEFFCallAction it_1) -> {
        return SeffFactory.eINSTANCE.createAcquireAction();
      };
      it.setCreate(_function_2);
      final Predicate<SEFFCallAction> _function_3 = (SEFFCallAction it_1) -> {
        return ((Objects.equal(it_1.getSignature().getName(), RepositoryConfigurer.ACQUIRE_SIGNATURE_NAME) && (it_1.getRole() instanceof InternalInterfaceProvidedRole)) && 
          (it_1.getRole().getType().eContainer() instanceof ResourceTypeRepository));
      };
      it.setWhen(_function_3);
      final Function<SEFFCallAction, Role> _function_4 = (SEFFCallAction it_1) -> {
        return it_1.getRole();
      };
      final BiConsumer<AcquireAction, PassiveResource> _function_5 = (AcquireAction action, PassiveResource resource) -> {
        action.setPassiveresource_AcquireAction(resource);
      };
      it.<Role, PassiveResource>map(_function_4, PassiveResource.class).thenSet(_function_5);
    };
    registry.<SEFFCallAction, AcquireAction>configure(SEFFCallAction.class, AcquireAction.class, _function_1);
    final Consumer<GeneratorRuleBuilder<SEFFCallAction, ReleaseAction>> _function_2 = (GeneratorRuleBuilder<SEFFCallAction, ReleaseAction> it) -> {
      final Function<SEFFCallAction, ReleaseAction> _function_3 = (SEFFCallAction it_1) -> {
        return SeffFactory.eINSTANCE.createReleaseAction();
      };
      it.setCreate(_function_3);
      final Predicate<SEFFCallAction> _function_4 = (SEFFCallAction it_1) -> {
        return ((Objects.equal(it_1.getSignature().getName(), RepositoryConfigurer.RELEASE_SIGNATURE_NAME) && (it_1.getRole() instanceof InternalInterfaceProvidedRole)) && 
          (it_1.getRole().getType().eContainer() instanceof ResourceTypeRepository));
      };
      it.setWhen(_function_4);
      final Function<SEFFCallAction, Role> _function_5 = (SEFFCallAction it_1) -> {
        return it_1.getRole();
      };
      final BiConsumer<ReleaseAction, PassiveResource> _function_6 = (ReleaseAction action, PassiveResource resource) -> {
        action.setPassiveResource_ReleaseAction(resource);
      };
      it.<Role, PassiveResource>map(_function_5, PassiveResource.class).thenSet(_function_6);
    };
    registry.<SEFFCallAction, ReleaseAction>configure(SEFFCallAction.class, ReleaseAction.class, _function_2);
    final Consumer<GeneratorRuleBuilder<SEFFProbabilisticAction, BranchAction>> _function_3 = (GeneratorRuleBuilder<SEFFProbabilisticAction, BranchAction> it) -> {
      final Function<SEFFProbabilisticAction, BranchAction> _function_4 = (SEFFProbabilisticAction it_1) -> {
        BranchAction _createBranchAction = SeffFactory.eINSTANCE.createBranchAction();
        final Procedure1<BranchAction> _function_5 = (BranchAction b) -> {
          final ToDoubleFunction<SEFFProbabilisticBranch> _function_6 = (SEFFProbabilisticBranch it_2) -> {
            return it_2.getProbability();
          };
          final double totalProbability = it_1.getBranches().stream().mapToDouble(_function_6).sum();
          if ((totalProbability < 1.0)) {
            final double remainingProbablity = (1.0 - totalProbability);
            ProbabilisticBranchTransition _createProbabilisticBranchTransition = SeffFactory.eINSTANCE.createProbabilisticBranchTransition();
            final Procedure1<ProbabilisticBranchTransition> _function_7 = (ProbabilisticBranchTransition t) -> {
              t.setBranchProbability(remainingProbablity);
              t.setEntityName(("" + Double.valueOf(remainingProbablity)));
              ResourceDemandingBehaviour _createEmptyBehavior = RepositoryConfigurer.createEmptyBehavior();
              final Procedure1<ResourceDemandingBehaviour> _function_8 = (ResourceDemandingBehaviour be) -> {
                RepositoryConfigurer.updatePreviousAssignments(be.getSteps_Behaviour());
                RepositoryConfigurer.updateSuccessorAssignments(be.getSteps_Behaviour());
              };
              final ResourceDemandingBehaviour behavior = ObjectExtensions.<ResourceDemandingBehaviour>operator_doubleArrow(_createEmptyBehavior, _function_8);
              t.setBranchBehaviour_BranchTransition(behavior);
            };
            final ProbabilisticBranchTransition noopBranch = ObjectExtensions.<ProbabilisticBranchTransition>operator_doubleArrow(_createProbabilisticBranchTransition, _function_7);
            b.getBranches_Branch().add(noopBranch);
          }
        };
        return ObjectExtensions.<BranchAction>operator_doubleArrow(_createBranchAction, _function_5);
      };
      it.setCreate(_function_4);
      final Function<SEFFProbabilisticAction, EList<SEFFProbabilisticBranch>> _function_5 = (SEFFProbabilisticAction it_1) -> {
        return it_1.getBranches();
      };
      final BiConsumer<BranchAction, List<AbstractBranchTransition>> _function_6 = (BranchAction action, List<AbstractBranchTransition> branches) -> {
        action.getBranches_Branch().addAll(0, branches);
      };
      it.<SEFFProbabilisticBranch, AbstractBranchTransition>mapAll(_function_5).thenSet(_function_6);
    };
    registry.<SEFFProbabilisticAction, BranchAction>configure(SEFFProbabilisticAction.class, BranchAction.class, _function_3);
    final Consumer<GeneratorRuleBuilder<SEFFProbabilisticBranch, ProbabilisticBranchTransition>> _function_4 = (GeneratorRuleBuilder<SEFFProbabilisticBranch, ProbabilisticBranchTransition> it) -> {
      final Function<SEFFProbabilisticBranch, ProbabilisticBranchTransition> _function_5 = (SEFFProbabilisticBranch it_1) -> {
        ProbabilisticBranchTransition _createProbabilisticBranchTransition = SeffFactory.eINSTANCE.createProbabilisticBranchTransition();
        final Procedure1<ProbabilisticBranchTransition> _function_6 = (ProbabilisticBranchTransition t) -> {
          t.setBranchProbability(it_1.getProbability());
          final ResourceDemandingBehaviour behavior = SeffFactory.eINSTANCE.createResourceDemandingBehaviour();
          t.setBranchBehaviour_BranchTransition(behavior);
          double _probability = it_1.getProbability();
          String _plus = ("" + Double.valueOf(_probability));
          t.setEntityName(_plus);
        };
        return ObjectExtensions.<ProbabilisticBranchTransition>operator_doubleArrow(_createProbabilisticBranchTransition, _function_6);
      };
      it.setCreate(_function_5);
      final Function<SEFFProbabilisticBranch, EList<SEFFContent>> _function_6 = (SEFFProbabilisticBranch it_1) -> {
        return it_1.getContents();
      };
      final BiConsumer<ProbabilisticBranchTransition, List<AbstractAction>> _function_7 = (ProbabilisticBranchTransition branch, List<AbstractAction> actions) -> {
        RepositoryConfigurer.addStepsToBranch(branch, actions);
      };
      it.<SEFFContent, AbstractAction>mapAll(_function_6).thenSet(_function_7);
    };
    registry.<SEFFProbabilisticBranch, ProbabilisticBranchTransition>configure(SEFFProbabilisticBranch.class, ProbabilisticBranchTransition.class, _function_4);
    final Consumer<GeneratorRuleBuilder<SEFFLoopAction, LoopAction>> _function_5 = (GeneratorRuleBuilder<SEFFLoopAction, LoopAction> it) -> {
      final Function<SEFFLoopAction, LoopAction> _function_6 = (SEFFLoopAction it_1) -> {
        LoopAction _createLoopAction = SeffFactory.eINSTANCE.createLoopAction();
        final Procedure1<LoopAction> _function_7 = (LoopAction l) -> {
          l.setBodyBehaviour_Loop(RepositoryConfigurer.createEmptyBehavior());
        };
        return ObjectExtensions.<LoopAction>operator_doubleArrow(_createLoopAction, _function_7);
      };
      it.setCreate(_function_6);
      final Function<SEFFLoopAction, Expression> _function_7 = (SEFFLoopAction it_1) -> {
        return it_1.getCondition();
      };
      final BiConsumer<LoopAction, PCMRandomVariable> _function_8 = (LoopAction loop, PCMRandomVariable variable) -> {
        loop.setIterationCount_LoopAction(variable);
      };
      it.<Expression, PCMRandomVariable>map(_function_7, PCMRandomVariable.class).thenSet(_function_8);
      final Function<SEFFLoopAction, EList<SEFFContent>> _function_9 = (SEFFLoopAction it_1) -> {
        return it_1.getContents();
      };
      final BiConsumer<LoopAction, List<AbstractAction>> _function_10 = (LoopAction loop, List<AbstractAction> actions) -> {
        final ResourceDemandingBehaviour behavior = loop.getBodyBehaviour_Loop();
        behavior.getSteps_Behaviour().addAll(1, actions);
        RepositoryConfigurer.updatePreviousAssignments(behavior.getSteps_Behaviour());
        RepositoryConfigurer.updateSuccessorAssignments(behavior.getSteps_Behaviour());
      };
      it.<SEFFContent, AbstractAction>mapAll(_function_9).thenSet(_function_10);
    };
    registry.<SEFFLoopAction, LoopAction>configure(SEFFLoopAction.class, LoopAction.class, _function_5);
    final Consumer<GeneratorRuleBuilder<SEFFConditionalAction, BranchAction>> _function_6 = (GeneratorRuleBuilder<SEFFConditionalAction, BranchAction> it) -> {
      final Function<SEFFConditionalAction, BranchAction> _function_7 = (SEFFConditionalAction it_1) -> {
        BranchAction _createBranchAction = SeffFactory.eINSTANCE.createBranchAction();
        final Procedure1<BranchAction> _function_8 = (BranchAction it_2) -> {
          final GuardedBranchTransition branch = SeffFactory.eINSTANCE.createGuardedBranchTransition();
          it_2.getBranches_Branch().add(branch);
          final ResourceDemandingBehaviour behavior = SeffFactory.eINSTANCE.createResourceDemandingBehaviour();
          branch.setBranchBehaviour_BranchTransition(behavior);
        };
        return ObjectExtensions.<BranchAction>operator_doubleArrow(_createBranchAction, _function_8);
      };
      it.setCreate(_function_7);
      final Function<SEFFConditionalAction, Expression> _function_8 = (SEFFConditionalAction it_1) -> {
        return it_1.getCondition();
      };
      final BiConsumer<BranchAction, PCMRandomVariable> _function_9 = (BranchAction action, PCMRandomVariable condition) -> {
        AbstractBranchTransition _get = action.getBranches_Branch().get(0);
        final GuardedBranchTransition branch = ((GuardedBranchTransition) _get);
        branch.setBranchCondition_GuardedBranchTransition(condition);
        branch.setEntityName(condition.getSpecification());
      };
      it.<Expression, PCMRandomVariable>map(_function_8, PCMRandomVariable.class).thenSet(_function_9);
      final Function<SEFFConditionalAction, EList<SEFFContent>> _function_10 = (SEFFConditionalAction it_1) -> {
        return it_1.getContents();
      };
      final BiConsumer<BranchAction, List<AbstractAction>> _function_11 = (BranchAction action, List<AbstractAction> contents) -> {
        AbstractBranchTransition _get = action.getBranches_Branch().get(0);
        final GuardedBranchTransition branch = ((GuardedBranchTransition) _get);
        RepositoryConfigurer.addStepsToBranch(branch, contents);
      };
      it.<SEFFContent, AbstractAction>mapAll(_function_10).thenSet(_function_11);
      final Function<SEFFConditionalAction, List<SEFFConditionalAlternative>> _function_12 = (SEFFConditionalAction it_1) -> {
        return RepositoryConfigurer.collectAllBranches(it_1);
      };
      final BiConsumer<BranchAction, List<AbstractBranchTransition>> _function_13 = (BranchAction action, List<AbstractBranchTransition> alternatives) -> {
        action.getBranches_Branch().addAll(alternatives);
      };
      it.<SEFFConditionalAlternative, AbstractBranchTransition>mapAll(_function_12).thenSet(_function_13);
      final Consumer<BranchAction> _function_14 = (BranchAction it_1) -> {
        final Function1<GuardedBranchTransition, Boolean> _function_15 = (GuardedBranchTransition branch) -> {
          String _specification = branch.getBranchCondition_GuardedBranchTransition().getSpecification();
          return Boolean.valueOf(Objects.equal(_specification, "true"));
        };
        final boolean hasElseBranch = IterableExtensions.<GuardedBranchTransition>exists(Iterables.<GuardedBranchTransition>filter(it_1.getBranches_Branch(), GuardedBranchTransition.class), _function_15);
        if ((!hasElseBranch)) {
          GuardedBranchTransition _createGuardedBranchTransition = SeffFactory.eINSTANCE.createGuardedBranchTransition();
          final Procedure1<GuardedBranchTransition> _function_16 = (GuardedBranchTransition t) -> {
            PCMRandomVariable _createPCMRandomVariable = CoreFactory.eINSTANCE.createPCMRandomVariable();
            final Procedure1<PCMRandomVariable> _function_17 = (PCMRandomVariable it_2) -> {
              it_2.setSpecification("true");
            };
            final PCMRandomVariable spec = ObjectExtensions.<PCMRandomVariable>operator_doubleArrow(_createPCMRandomVariable, _function_17);
            t.setBranchCondition_GuardedBranchTransition(spec);
            final ResourceDemandingBehaviour behavior = SeffFactory.eINSTANCE.createResourceDemandingBehaviour();
            t.setBranchBehaviour_BranchTransition(behavior);
            t.setEntityName("else");
          };
          final GuardedBranchTransition elseBranch = ObjectExtensions.<GuardedBranchTransition>operator_doubleArrow(_createGuardedBranchTransition, _function_16);
          RepositoryConfigurer.addStepsToBranch(elseBranch, Collections.<AbstractAction>emptyList());
          it_1.getBranches_Branch().add(elseBranch);
        }
      };
      it.setAfter(_function_14);
    };
    registry.<SEFFConditionalAction, BranchAction>configure(SEFFConditionalAction.class, BranchAction.class, _function_6);
    final Consumer<GeneratorRuleBuilder<SEFFConditionalElseIf, GuardedBranchTransition>> _function_7 = (GeneratorRuleBuilder<SEFFConditionalElseIf, GuardedBranchTransition> it) -> {
      final Function<SEFFConditionalElseIf, GuardedBranchTransition> _function_8 = (SEFFConditionalElseIf it_1) -> {
        GuardedBranchTransition _createGuardedBranchTransition = SeffFactory.eINSTANCE.createGuardedBranchTransition();
        final Procedure1<GuardedBranchTransition> _function_9 = (GuardedBranchTransition g) -> {
          final ResourceDemandingBehaviour behavior = SeffFactory.eINSTANCE.createResourceDemandingBehaviour();
          g.setBranchBehaviour_BranchTransition(behavior);
          behavior.setAbstractBranchTransition_ResourceDemandingBehaviour(g);
        };
        return ObjectExtensions.<GuardedBranchTransition>operator_doubleArrow(_createGuardedBranchTransition, _function_9);
      };
      it.setCreate(_function_8);
      final Function<SEFFConditionalElseIf, Expression> _function_9 = (SEFFConditionalElseIf it_1) -> {
        return it_1.getCondition();
      };
      final BiConsumer<GuardedBranchTransition, PCMRandomVariable> _function_10 = (GuardedBranchTransition transition, PCMRandomVariable variable) -> {
        transition.setBranchCondition_GuardedBranchTransition(variable);
        variable.setGuardedBranchTransition_PCMRandomVariable(transition);
        transition.setEntityName(variable.getSpecification());
      };
      it.<Expression, PCMRandomVariable>map(_function_9, PCMRandomVariable.class).thenSet(_function_10);
      final Function<SEFFConditionalElseIf, EList<SEFFContent>> _function_11 = (SEFFConditionalElseIf it_1) -> {
        return it_1.getContents();
      };
      final BiConsumer<GuardedBranchTransition, List<AbstractAction>> _function_12 = (GuardedBranchTransition branch, List<AbstractAction> actions) -> {
        RepositoryConfigurer.addStepsToBranch(branch, actions);
      };
      it.<SEFFContent, AbstractAction>mapAll(_function_11).thenSet(_function_12);
    };
    registry.<SEFFConditionalElseIf, GuardedBranchTransition>configure(SEFFConditionalElseIf.class, GuardedBranchTransition.class, _function_7);
    final Consumer<GeneratorRuleBuilder<SEFFConditionalElse, GuardedBranchTransition>> _function_8 = (GeneratorRuleBuilder<SEFFConditionalElse, GuardedBranchTransition> it) -> {
      final Function<SEFFConditionalElse, GuardedBranchTransition> _function_9 = (SEFFConditionalElse it_1) -> {
        GuardedBranchTransition _createGuardedBranchTransition = SeffFactory.eINSTANCE.createGuardedBranchTransition();
        final Procedure1<GuardedBranchTransition> _function_10 = (GuardedBranchTransition t) -> {
          PCMRandomVariable _createPCMRandomVariable = CoreFactory.eINSTANCE.createPCMRandomVariable();
          final Procedure1<PCMRandomVariable> _function_11 = (PCMRandomVariable it_2) -> {
            it_2.setSpecification("true");
          };
          final PCMRandomVariable spec = ObjectExtensions.<PCMRandomVariable>operator_doubleArrow(_createPCMRandomVariable, _function_11);
          t.setBranchCondition_GuardedBranchTransition(spec);
          final ResourceDemandingBehaviour behavior = SeffFactory.eINSTANCE.createResourceDemandingBehaviour();
          t.setBranchBehaviour_BranchTransition(behavior);
          t.setEntityName("else");
        };
        return ObjectExtensions.<GuardedBranchTransition>operator_doubleArrow(_createGuardedBranchTransition, _function_10);
      };
      it.setCreate(_function_9);
      final Function<SEFFConditionalElse, EList<SEFFContent>> _function_10 = (SEFFConditionalElse it_1) -> {
        return it_1.getContents();
      };
      final BiConsumer<GuardedBranchTransition, List<AbstractAction>> _function_11 = (GuardedBranchTransition branch, List<AbstractAction> actions) -> {
        RepositoryConfigurer.addStepsToBranch(branch, actions);
      };
      it.<SEFFContent, AbstractAction>mapAll(_function_10).thenSet(_function_11);
    };
    registry.<SEFFConditionalElse, GuardedBranchTransition>configure(SEFFConditionalElse.class, GuardedBranchTransition.class, _function_8);
    final Consumer<GeneratorRuleBuilder<SEFFAssignment, SetVariableAction>> _function_9 = (GeneratorRuleBuilder<SEFFAssignment, SetVariableAction> it) -> {
      final Function<SEFFAssignment, SetVariableAction> _function_10 = (SEFFAssignment it_1) -> {
        return SeffFactory.eINSTANCE.createSetVariableAction();
      };
      it.setCreate(_function_10);
      final Function<SEFFAssignment, ResultAssignment> _function_11 = (SEFFAssignment it_1) -> {
        return it_1.getResult();
      };
      final BiConsumer<SetVariableAction, VariableUsage> _function_12 = (SetVariableAction action, VariableUsage result) -> {
        action.getLocalVariableUsages_SetVariableAction().add(result);
      };
      it.<ResultAssignment, VariableUsage>map(_function_11).thenSet(_function_12);
      final Function<SEFFAssignment, Expression> _function_13 = (SEFFAssignment it_1) -> {
        return it_1.getSpecification();
      };
      final BiConsumer<SetVariableAction, PCMRandomVariable> _function_14 = (SetVariableAction action, PCMRandomVariable spec) -> {
        final VariableUsage usage = action.getLocalVariableUsages_SetVariableAction().get(0);
        final VariableCharacterisation characterization = usage.getVariableCharacterisation_VariableUsage().get(0);
        characterization.setSpecification_VariableCharacterisation(spec);
      };
      it.<Expression, PCMRandomVariable>map(_function_13, PCMRandomVariable.class).thenSet(_function_14);
      final Consumer<SetVariableAction> _function_15 = (SetVariableAction it_1) -> {
        final Consumer<VariableUsage> _function_16 = (VariableUsage usage) -> {
          AbstractNamedReference _namedReference__VariableUsage = usage.getNamedReference__VariableUsage();
          boolean _tripleEquals = (_namedReference__VariableUsage == null);
          if (_tripleEquals) {
            VariableReference _createVariableReference = StoexFactory.eINSTANCE.createVariableReference();
            final Procedure1<VariableReference> _function_17 = (VariableReference r) -> {
              r.setReferenceName("RETURN");
            };
            final VariableReference returnReference = ObjectExtensions.<VariableReference>operator_doubleArrow(_createVariableReference, _function_17);
            usage.setNamedReference__VariableUsage(returnReference);
          }
        };
        it_1.getLocalVariableUsages_SetVariableAction().forEach(_function_16);
        boolean _hasEmptyName = ConfigurerHelper.hasEmptyName(it_1);
        if (_hasEmptyName) {
          final Function1<VariableUsage, CharSequence> _function_17 = (VariableUsage it_2) -> {
            return it_2.getNamedReference__VariableUsage().getReferenceName();
          };
          it_1.setEntityName(IterableExtensions.<VariableUsage>join(it_1.getLocalVariableUsages_SetVariableAction(), ", ", _function_17));
        }
      };
      it.setAfter(_function_15);
    };
    registry.<SEFFAssignment, SetVariableAction>configure(SEFFAssignment.class, SetVariableAction.class, _function_9);
    final Consumer<GeneratorRuleBuilder<SEFFCallAction, EmitEventAction>> _function_10 = (GeneratorRuleBuilder<SEFFCallAction, EmitEventAction> it) -> {
      final Function<SEFFCallAction, EmitEventAction> _function_11 = (SEFFCallAction it_1) -> {
        return SeffFactory.eINSTANCE.createEmitEventAction();
      };
      it.setCreate(_function_11);
      final Predicate<SEFFCallAction> _function_12 = (SEFFCallAction it_1) -> {
        Signature _signature = it_1.getSignature();
        return (_signature instanceof EventSignature);
      };
      it.setWhen(_function_12);
      final Function<SEFFCallAction, Role> _function_13 = (SEFFCallAction it_1) -> {
        return it_1.getRole();
      };
      final BiConsumer<EmitEventAction, SourceRole> _function_14 = (EmitEventAction action, SourceRole role) -> {
        action.setSourceRole__EmitEventAction(role);
      };
      it.<Role, SourceRole>map(_function_13).thenSet(_function_14);
      final Function<SEFFCallAction, Signature> _function_15 = (SEFFCallAction it_1) -> {
        return it_1.getSignature();
      };
      final BiConsumer<EmitEventAction, EventType> _function_16 = (EmitEventAction action, EventType signature) -> {
        action.setEventType__EmitEventAction(signature);
      };
      it.<Signature, EventType>map(_function_15, EventType.class).thenSet(_function_16);
    };
    registry.<SEFFCallAction, EmitEventAction>configure(SEFFCallAction.class, EmitEventAction.class, _function_10);
    final Consumer<GeneratorRuleBuilder<SEFFCallAction, ExternalCallAction>> _function_11 = (GeneratorRuleBuilder<SEFFCallAction, ExternalCallAction> it) -> {
      final Function<SEFFCallAction, ExternalCallAction> _function_12 = (SEFFCallAction it_1) -> {
        ExternalCallAction _createExternalCallAction = SeffFactory.eINSTANCE.createExternalCallAction();
        final Procedure1<ExternalCallAction> _function_13 = (ExternalCallAction c) -> {
          c.setEntityName(it_1.getSignature().getName());
        };
        return ObjectExtensions.<ExternalCallAction>operator_doubleArrow(_createExternalCallAction, _function_13);
      };
      it.setCreate(_function_12);
      final Predicate<SEFFCallAction> _function_13 = (SEFFCallAction it_1) -> {
        return (((it_1.getRole() instanceof InterfaceRequiredRole) && (it_1.getSignature() instanceof org.palladiosimulator.textual.tpcm.language.OperationSignature)) && 
          (it_1.getRole().getType() instanceof DomainInterface));
      };
      it.setWhen(_function_13);
      final Function<SEFFCallAction, Role> _function_14 = (SEFFCallAction it_1) -> {
        return it_1.getRole();
      };
      final BiConsumer<ExternalCallAction, OperationRequiredRole> _function_15 = (ExternalCallAction action, OperationRequiredRole role) -> {
        action.setRole_ExternalService(role);
      };
      it.<Role, OperationRequiredRole>map(_function_14).thenSet(_function_15);
      final Function<SEFFCallAction, Signature> _function_16 = (SEFFCallAction it_1) -> {
        return it_1.getSignature();
      };
      final BiConsumer<ExternalCallAction, OperationSignature> _function_17 = (ExternalCallAction action, OperationSignature signature) -> {
        action.setCalledService_ExternalService(signature);
      };
      it.<Signature, OperationSignature>map(_function_16, OperationSignature.class).thenSet(_function_17);
      final Function<SEFFCallAction, List<ResultSpecification>> _function_18 = (SEFFCallAction it_1) -> {
        List<ResultSpecification> _xifexpression = null;
        ResultAssignment _result = it_1.getResult();
        if ((_result instanceof ComplexResultAssignment)) {
          ResultAssignment _result_1 = it_1.getResult();
          _xifexpression = ((ComplexResultAssignment) _result_1).getSpecification();
        } else {
          _xifexpression = CollectionLiterals.<ResultSpecification>emptyList();
        }
        return _xifexpression;
      };
      final BiConsumer<ExternalCallAction, List<VariableUsage>> _function_19 = (ExternalCallAction action, List<VariableUsage> specs) -> {
        action.getReturnVariableUsage__CallReturnAction().addAll(specs);
      };
      it.<ResultSpecification, VariableUsage>mapAll(_function_18).thenSet(_function_19);
      final Function<SEFFCallAction, ResultAssignment> _function_20 = (SEFFCallAction it_1) -> {
        ResultAssignment _xifexpression = null;
        ResultAssignment _result = it_1.getResult();
        if ((_result instanceof ComplexResultAssignment)) {
          _xifexpression = null;
        } else {
          _xifexpression = it_1.getResult();
        }
        return _xifexpression;
      };
      final BiConsumer<ExternalCallAction, VariableUsage> _function_21 = (ExternalCallAction action, VariableUsage result) -> {
        action.getReturnVariableUsage__CallReturnAction().add(result);
      };
      it.<ResultAssignment, VariableUsage>map(_function_20).thenSet(_function_21);
      final Function<SEFFCallAction, EList<ParameterSpecification>> _function_22 = (SEFFCallAction it_1) -> {
        return it_1.getParameters();
      };
      final BiConsumer<ExternalCallAction, List<VariableUsage>> _function_23 = (ExternalCallAction call, List<VariableUsage> params) -> {
        call.getInputVariableUsages__CallAction().addAll(params);
        final Procedure2<VariableUsage, Integer> _function_24 = (VariableUsage usage, Integer index) -> {
          AbstractNamedReference _namedReference__VariableUsage = usage.getNamedReference__VariableUsage();
          boolean _tripleEquals = (_namedReference__VariableUsage == null);
          if (_tripleEquals) {
            final Parameter param = call.getCalledService_ExternalService().getParameters__OperationSignature().get((index).intValue());
            VariableReference _createVariableReference = StoexFactory.eINSTANCE.createVariableReference();
            final Procedure1<VariableReference> _function_25 = (VariableReference r) -> {
              r.setReferenceName(param.getParameterName());
            };
            final VariableReference reference = ObjectExtensions.<VariableReference>operator_doubleArrow(_createVariableReference, _function_25);
            usage.setNamedReference__VariableUsage(reference);
          }
        };
        IterableExtensions.<VariableUsage>forEach(call.getInputVariableUsages__CallAction(), _function_24);
      };
      it.<ParameterSpecification, VariableUsage>mapAll(_function_22).thenSet(_function_23);
      final Consumer<ExternalCallAction> _function_24 = (ExternalCallAction it_1) -> {
        final Consumer<VariableUsage> _function_25 = (VariableUsage usage) -> {
          AbstractNamedReference _namedReference__VariableUsage = usage.getNamedReference__VariableUsage();
          boolean _tripleEquals = (_namedReference__VariableUsage == null);
          if (_tripleEquals) {
            VariableReference _createVariableReference = StoexFactory.eINSTANCE.createVariableReference();
            final Procedure1<VariableReference> _function_26 = (VariableReference r) -> {
              r.setReferenceName("RETURN");
            };
            final VariableReference returnReference = ObjectExtensions.<VariableReference>operator_doubleArrow(_createVariableReference, _function_26);
            usage.setNamedReference__VariableUsage(returnReference);
          }
          final Consumer<VariableCharacterisation> _function_27 = (VariableCharacterisation characterisation) -> {
            PCMRandomVariable _specification_VariableCharacterisation = characterisation.getSpecification_VariableCharacterisation();
            boolean _tripleEquals_1 = (_specification_VariableCharacterisation == null);
            if (_tripleEquals_1) {
              String _literal = characterisation.getType().getLiteral();
              final String spec = ("RETURN." + _literal);
              PCMRandomVariable _createPCMRandomVariable = CoreFactory.eINSTANCE.createPCMRandomVariable();
              final Procedure1<PCMRandomVariable> _function_28 = (PCMRandomVariable it_2) -> {
                it_2.setSpecification(spec);
              };
              PCMRandomVariable _doubleArrow = ObjectExtensions.<PCMRandomVariable>operator_doubleArrow(_createPCMRandomVariable, _function_28);
              characterisation.setSpecification_VariableCharacterisation(_doubleArrow);
            }
          };
          usage.getVariableCharacterisation_VariableUsage().forEach(_function_27);
        };
        it_1.getReturnVariableUsage__CallReturnAction().forEach(_function_25);
      };
      it.setAfter(_function_24);
    };
    registry.<SEFFCallAction, ExternalCallAction>configure(SEFFCallAction.class, ExternalCallAction.class, _function_11);
    final Consumer<GeneratorRuleBuilder<PrimitiveResultAssignment, VariableUsage>> _function_12 = (GeneratorRuleBuilder<PrimitiveResultAssignment, VariableUsage> it) -> {
      final Function<PrimitiveResultAssignment, VariableUsage> _function_13 = (PrimitiveResultAssignment it_1) -> {
        VariableUsage _switchResult = null;
        CharacteristicReference _reference = it_1.getReference();
        boolean _matched = false;
        if (_reference instanceof AbsoluteReference) {
          _matched=true;
          CharacteristicReference _reference_1 = it_1.getReference();
          _switchResult = RepositoryConfigurer.createForReference(((AbsoluteReference) _reference_1));
        }
        if (!_matched) {
          if (_reference instanceof RelativeReference) {
            _matched=true;
            CharacteristicReference _reference_1 = it_1.getReference();
            _switchResult = RepositoryConfigurer.createForReference(((RelativeReference) _reference_1));
          }
        }
        return _switchResult;
      };
      it.setCreate(_function_13);
    };
    registry.<PrimitiveResultAssignment, VariableUsage>configure(PrimitiveResultAssignment.class, VariableUsage.class, _function_12);
    final Consumer<GeneratorRuleBuilder<ResultSpecification, VariableUsage>> _function_13 = (GeneratorRuleBuilder<ResultSpecification, VariableUsage> it) -> {
      final Function<ResultSpecification, VariableUsage> _function_14 = (ResultSpecification it_1) -> {
        CharacteristicReference _characteristic = it_1.getCharacteristic();
        return RepositoryConfigurer.createForReference(((AbsoluteReference) _characteristic));
      };
      it.setCreate(_function_14);
      final Predicate<ResultSpecification> _function_15 = (ResultSpecification it_1) -> {
        CharacteristicReference _characteristic = it_1.getCharacteristic();
        return (_characteristic instanceof AbsoluteReference);
      };
      it.setWhen(_function_15);
    };
    registry.<ResultSpecification, VariableUsage>configure(ResultSpecification.class, VariableUsage.class, _function_13);
    final Consumer<GeneratorRuleBuilder<ResultSpecification, VariableUsage>> _function_14 = (GeneratorRuleBuilder<ResultSpecification, VariableUsage> it) -> {
      final Function<ResultSpecification, VariableUsage> _function_15 = (ResultSpecification it_1) -> {
        CharacteristicReference _characteristic = it_1.getCharacteristic();
        return RepositoryConfigurer.createForReference(((RelativeReference) _characteristic));
      };
      it.setCreate(_function_15);
      final Predicate<ResultSpecification> _function_16 = (ResultSpecification it_1) -> {
        CharacteristicReference _characteristic = it_1.getCharacteristic();
        return (_characteristic instanceof RelativeReference);
      };
      it.setWhen(_function_16);
      final Function<ResultSpecification, Expression> _function_17 = (ResultSpecification it_1) -> {
        return it_1.getSpecification();
      };
      final BiConsumer<VariableUsage, PCMRandomVariable> _function_18 = (VariableUsage usage, PCMRandomVariable spec) -> {
        final VariableCharacterisation character = usage.getVariableCharacterisation_VariableUsage().get(0);
        character.setSpecification_VariableCharacterisation(spec);
      };
      it.<Expression, PCMRandomVariable>map(_function_17, PCMRandomVariable.class).thenSet(_function_18);
    };
    registry.<ResultSpecification, VariableUsage>configure(ResultSpecification.class, VariableUsage.class, _function_14);
    final Consumer<GeneratorRuleBuilder<SEFFCallAction, InternalAction>> _function_15 = (GeneratorRuleBuilder<SEFFCallAction, InternalAction> it) -> {
      final Function<SEFFCallAction, InternalAction> _function_16 = (SEFFCallAction it_1) -> {
        return SeffFactory.eINSTANCE.createInternalAction();
      };
      it.setCreate(_function_16);
      final Predicate<SEFFCallAction> _function_17 = (SEFFCallAction it_1) -> {
        return ((it_1.getRole().getType().eContainer() instanceof ResourceTypeRepository) && 
          (!(Objects.equal(it_1.getSignature().getName(), RepositoryConfigurer.ACQUIRE_SIGNATURE_NAME) || Objects.equal(it_1.getSignature().getName(), RepositoryConfigurer.RELEASE_SIGNATURE_NAME))));
      };
      it.setWhen(_function_17);
      final Function<SEFFCallAction, Role> _function_18 = (SEFFCallAction it_1) -> {
        return it_1.getRole();
      };
      final BiConsumer<InternalAction, ResourceRequiredRole> _function_19 = (InternalAction action, ResourceRequiredRole resource) -> {
        final ResourceCall call = SeffPerformanceFactory.eINSTANCE.createResourceCall();
        call.setResourceRequiredRole__ResourceCall(resource);
        action.getResourceCall__Action().add(call);
        call.setAction__ResourceCall(action);
      };
      it.<Role, ResourceRequiredRole>map(_function_18).thenSet(_function_19);
      final Function<SEFFCallAction, Signature> _function_20 = (SEFFCallAction it_1) -> {
        return it_1.getSignature();
      };
      final BiConsumer<InternalAction, ResourceSignature> _function_21 = (InternalAction action, ResourceSignature signature) -> {
        final ResourceCall call = action.getResourceCall__Action().get(0);
        call.setSignature__ResourceCall(signature);
      };
      it.<Signature, ResourceSignature>map(_function_20, ResourceSignature.class).thenSet(_function_21);
      final Function<SEFFCallAction, Expression> _function_22 = (SEFFCallAction it_1) -> {
        return it_1.getParameters().get(0).getSpecification();
      };
      final BiConsumer<InternalAction, PCMRandomVariable> _function_23 = (InternalAction action, PCMRandomVariable variable) -> {
        final ResourceCall call = action.getResourceCall__Action().get(0);
        call.setNumberOfCalls__ResourceCall(variable);
      };
      it.<Expression, PCMRandomVariable>map(_function_22, PCMRandomVariable.class).thenSet(_function_23);
    };
    registry.<SEFFCallAction, InternalAction>configure(SEFFCallAction.class, InternalAction.class, _function_15);
    final Consumer<GeneratorRuleBuilder<ParameterSpecification, VariableUsage>> _function_16 = (GeneratorRuleBuilder<ParameterSpecification, VariableUsage> it) -> {
      final Function<ParameterSpecification, VariableUsage> _function_17 = (ParameterSpecification it_1) -> {
        CharacteristicReference _reference = it_1.getReference();
        return RepositoryConfigurer.createForReference(((AbsoluteReference) _reference));
      };
      it.setCreate(_function_17);
      final Predicate<ParameterSpecification> _function_18 = (ParameterSpecification it_1) -> {
        CharacteristicReference _reference = it_1.getReference();
        return (_reference instanceof AbsoluteReference);
      };
      it.setWhen(_function_18);
      final Function<ParameterSpecification, Expression> _function_19 = (ParameterSpecification it_1) -> {
        return it_1.getSpecification();
      };
      final BiConsumer<VariableUsage, PCMRandomVariable> _function_20 = (VariableUsage usage, PCMRandomVariable spec) -> {
        final VariableCharacterisation characterization = usage.getVariableCharacterisation_VariableUsage().get(0);
        characterization.setSpecification_VariableCharacterisation(spec);
      };
      it.<Expression, PCMRandomVariable>map(_function_19).thenSet(_function_20);
    };
    registry.<ParameterSpecification, VariableUsage>configure(ParameterSpecification.class, VariableUsage.class, _function_16);
    final Consumer<GeneratorRuleBuilder<ParameterSpecification, VariableUsage>> _function_17 = (GeneratorRuleBuilder<ParameterSpecification, VariableUsage> it) -> {
      final Function<ParameterSpecification, VariableUsage> _function_18 = (ParameterSpecification it_1) -> {
        CharacteristicReference _reference = it_1.getReference();
        return RepositoryConfigurer.createForReference(((RelativeReference) _reference));
      };
      it.setCreate(_function_18);
      final Predicate<ParameterSpecification> _function_19 = (ParameterSpecification it_1) -> {
        CharacteristicReference _reference = it_1.getReference();
        return (_reference instanceof RelativeReference);
      };
      it.setWhen(_function_19);
      final Function<ParameterSpecification, Expression> _function_20 = (ParameterSpecification it_1) -> {
        return it_1.getSpecification();
      };
      final BiConsumer<VariableUsage, PCMRandomVariable> _function_21 = (VariableUsage usage, PCMRandomVariable spec) -> {
        final VariableCharacterisation characteristic = usage.getVariableCharacterisation_VariableUsage().get(0);
        characteristic.setSpecification_VariableCharacterisation(spec);
      };
      it.<Expression, PCMRandomVariable>map(_function_20).thenSet(_function_21);
    };
    registry.<ParameterSpecification, VariableUsage>configure(ParameterSpecification.class, VariableUsage.class, _function_17);
    final Consumer<GeneratorRuleBuilder<ParameterSpecification, VariableUsage>> _function_18 = (GeneratorRuleBuilder<ParameterSpecification, VariableUsage> it) -> {
      final Predicate<ParameterSpecification> _function_19 = (ParameterSpecification it_1) -> {
        CharacteristicReference _reference = it_1.getReference();
        return (_reference == null);
      };
      it.setWhen(_function_19);
      final Function<ParameterSpecification, VariableUsage> _function_20 = (ParameterSpecification it_1) -> {
        return ParameterFactory.eINSTANCE.createVariableUsage();
      };
      it.setCreate(_function_20);
      final Function<ParameterSpecification, Expression> _function_21 = (ParameterSpecification it_1) -> {
        return it_1.getSpecification();
      };
      final BiConsumer<VariableUsage, PCMRandomVariable> _function_22 = (VariableUsage usage, PCMRandomVariable spec) -> {
        final VariableCharacterisation characteristic = ParameterFactory.eINSTANCE.createVariableCharacterisation();
        characteristic.setSpecification_VariableCharacterisation(spec);
        usage.getVariableCharacterisation_VariableUsage().add(characteristic);
      };
      it.<Expression, PCMRandomVariable>map(_function_21).thenSet(_function_22);
    };
    registry.<ParameterSpecification, VariableUsage>configure(ParameterSpecification.class, VariableUsage.class, _function_18);
    final Consumer<GeneratorRuleBuilder<Expression, PCMRandomVariable>> _function_19 = (GeneratorRuleBuilder<Expression, PCMRandomVariable> it) -> {
      final Function<Expression, PCMRandomVariable> _function_20 = (Expression it_1) -> {
        PCMRandomVariable _createPCMRandomVariable = CoreFactory.eINSTANCE.createPCMRandomVariable();
        final Procedure1<PCMRandomVariable> _function_21 = (PCMRandomVariable v) -> {
          v.setSpecification(ExpressionConverter.getOriginalExpressionString(it_1));
        };
        return ObjectExtensions.<PCMRandomVariable>operator_doubleArrow(_createPCMRandomVariable, _function_21);
      };
      it.setCreate(_function_20);
    };
    registry.<Expression, PCMRandomVariable>configure(Expression.class, PCMRandomVariable.class, _function_19);
    final Consumer<GeneratorRuleBuilder<SEFFIterateAction, CollectionIteratorAction>> _function_20 = (GeneratorRuleBuilder<SEFFIterateAction, CollectionIteratorAction> it) -> {
      final Function<SEFFIterateAction, CollectionIteratorAction> _function_21 = (SEFFIterateAction it_1) -> {
        return SeffFactory.eINSTANCE.createCollectionIteratorAction();
      };
      it.setCreate(_function_21);
      final Function<SEFFIterateAction, org.palladiosimulator.textual.tpcm.language.Parameter> _function_22 = (SEFFIterateAction it_1) -> {
        return it_1.getIterable();
      };
      final BiConsumer<CollectionIteratorAction, Parameter> _function_23 = (CollectionIteratorAction action, Parameter iterable) -> {
        action.setParameter_CollectionIteratorAction(iterable);
      };
      it.<org.palladiosimulator.textual.tpcm.language.Parameter, Parameter>map(_function_22).thenSet(_function_23);
      final Function<SEFFIterateAction, EList<SEFFContent>> _function_24 = (SEFFIterateAction it_1) -> {
        return it_1.getContents();
      };
      final BiConsumer<CollectionIteratorAction, List<AbstractAction>> _function_25 = (CollectionIteratorAction action, List<AbstractAction> contents) -> {
        action.setBodyBehaviour_Loop(RepositoryConfigurer.addActions(contents));
      };
      it.<SEFFContent, AbstractAction>mapAll(_function_24).thenSet(_function_25);
    };
    registry.<SEFFIterateAction, CollectionIteratorAction>configure(SEFFIterateAction.class, CollectionIteratorAction.class, _function_20);
  }

  protected static void configureRepositoryDatatypes(final GeneratorRuleRegistrationFacade registry) {
    final Consumer<GeneratorRuleBuilder<PrimitiveDatatype, PrimitiveDataType>> _function = (GeneratorRuleBuilder<PrimitiveDatatype, PrimitiveDataType> it) -> {
      final Function<PrimitiveDatatype, PrimitiveDataType> _function_1 = (PrimitiveDatatype dt) -> {
        PrimitiveDataType _createPrimitiveDataType = RepositoryFactory.eINSTANCE.createPrimitiveDataType();
        final Procedure1<PrimitiveDataType> _function_2 = (PrimitiveDataType it_1) -> {
          it_1.setType(PrimitiveTypeEnum.valueOf(dt.getType().getName()));
        };
        return ObjectExtensions.<PrimitiveDataType>operator_doubleArrow(_createPrimitiveDataType, _function_2);
      };
      it.setCreate(_function_1);
    };
    registry.<PrimitiveDatatype, PrimitiveDataType>configure(PrimitiveDatatype.class, PrimitiveDataType.class, _function);
    final Consumer<GeneratorRuleBuilder<CollectionDatatype, CollectionDataType>> _function_1 = (GeneratorRuleBuilder<CollectionDatatype, CollectionDataType> it) -> {
      final Function<CollectionDatatype, CollectionDataType> _function_2 = (CollectionDatatype it_1) -> {
        CollectionDataType _createCollectionDataType = RepositoryFactory.eINSTANCE.createCollectionDataType();
        final Procedure1<CollectionDataType> _function_3 = (CollectionDataType d) -> {
          d.setEntityName(it_1.getName());
        };
        return ObjectExtensions.<CollectionDataType>operator_doubleArrow(_createCollectionDataType, _function_3);
      };
      it.setCreate(_function_2);
      final Function<CollectionDatatype, Datatype> _function_3 = (CollectionDatatype it_1) -> {
        return it_1.getCollectionType();
      };
      final BiConsumer<CollectionDataType, DataType> _function_4 = (CollectionDataType collectionType, DataType dataType) -> {
        collectionType.setInnerType_CollectionDataType(dataType);
      };
      it.<Datatype, DataType>map(_function_3).thenSet(_function_4);
    };
    registry.<CollectionDatatype, CollectionDataType>configure(CollectionDatatype.class, CollectionDataType.class, _function_1);
    final Consumer<GeneratorRuleBuilder<ComposedDatatype, CompositeDataType>> _function_2 = (GeneratorRuleBuilder<ComposedDatatype, CompositeDataType> it) -> {
      final Function<ComposedDatatype, CompositeDataType> _function_3 = (ComposedDatatype it_1) -> {
        CompositeDataType _createCompositeDataType = RepositoryFactory.eINSTANCE.createCompositeDataType();
        final Procedure1<CompositeDataType> _function_4 = (CompositeDataType d) -> {
          d.setEntityName(it_1.getName());
        };
        return ObjectExtensions.<CompositeDataType>operator_doubleArrow(_createCompositeDataType, _function_4);
      };
      it.setCreate(_function_3);
      final Function<ComposedDatatype, EList<ComposedDatatypeElement>> _function_4 = (ComposedDatatype it_1) -> {
        return it_1.getElements();
      };
      final BiConsumer<CompositeDataType, List<InnerDeclaration>> _function_5 = (CompositeDataType compositeType, List<InnerDeclaration> elements) -> {
        compositeType.getInnerDeclaration_CompositeDataType().addAll(elements);
      };
      it.<ComposedDatatypeElement, InnerDeclaration>mapAll(_function_4).thenSet(_function_5);
    };
    registry.<ComposedDatatype, CompositeDataType>configure(ComposedDatatype.class, CompositeDataType.class, _function_2);
    final Consumer<GeneratorRuleBuilder<ComposedDatatypeElement, InnerDeclaration>> _function_3 = (GeneratorRuleBuilder<ComposedDatatypeElement, InnerDeclaration> it) -> {
      final Function<ComposedDatatypeElement, InnerDeclaration> _function_4 = (ComposedDatatypeElement it_1) -> {
        InnerDeclaration _createInnerDeclaration = RepositoryFactory.eINSTANCE.createInnerDeclaration();
        final Procedure1<InnerDeclaration> _function_5 = (InnerDeclaration d) -> {
          d.setEntityName(it_1.getName());
        };
        return ObjectExtensions.<InnerDeclaration>operator_doubleArrow(_createInnerDeclaration, _function_5);
      };
      it.setCreate(_function_4);
      final Function<ComposedDatatypeElement, Datatype> _function_5 = (ComposedDatatypeElement it_1) -> {
        return it_1.getType();
      };
      final BiConsumer<InnerDeclaration, DataType> _function_6 = (InnerDeclaration parent, DataType dataType) -> {
        parent.setDatatype_InnerDeclaration(dataType);
        if ((dataType instanceof CompositeDataType)) {
          parent.setCompositeDataType_InnerDeclaration(((CompositeDataType) dataType));
        }
      };
      it.<Datatype, DataType>map(_function_5).thenSet(_function_6);
      final Function<ComposedDatatypeElement, Datatype> _function_7 = (ComposedDatatypeElement it_1) -> {
        return it_1.getReference();
      };
      final BiConsumer<InnerDeclaration, DataType> _function_8 = (InnerDeclaration parent, DataType dataType) -> {
        parent.setDatatype_InnerDeclaration(dataType);
      };
      it.<Datatype, DataType>map(_function_7).thenSet(_function_8);
    };
    registry.<ComposedDatatypeElement, InnerDeclaration>configure(ComposedDatatypeElement.class, InnerDeclaration.class, _function_3);
  }

  public static PCMRandomVariable createVariableWithSpecification(final Expression exp) {
    final String spec = ExpressionConverter.getOriginalExpressionString(exp);
    PCMRandomVariable _createPCMRandomVariable = CoreFactory.eINSTANCE.createPCMRandomVariable();
    final Procedure1<PCMRandomVariable> _function = (PCMRandomVariable it) -> {
      it.setSpecification(spec);
    };
    return ObjectExtensions.<PCMRandomVariable>operator_doubleArrow(_createPCMRandomVariable, _function);
  }

  public static AbstractNamedReference copyReferences(final NamespaceReference reference) {
    AbstractNamedReference _innerReference_NamespaceReference = reference.getInnerReference_NamespaceReference();
    if ((_innerReference_NamespaceReference instanceof NamespaceReference)) {
      NamespaceReference _createNamespaceReference = StoexFactory.eINSTANCE.createNamespaceReference();
      final Procedure1<NamespaceReference> _function = (NamespaceReference r) -> {
        r.setReferenceName(reference.getReferenceName());
        AbstractNamedReference _innerReference_NamespaceReference_1 = reference.getInnerReference_NamespaceReference();
        if ((_innerReference_NamespaceReference_1 instanceof NamespaceReference)) {
          AbstractNamedReference _innerReference_NamespaceReference_2 = reference.getInnerReference_NamespaceReference();
          r.setInnerReference_NamespaceReference(RepositoryConfigurer.copyReferences(
            ((NamespaceReference) _innerReference_NamespaceReference_2)));
        }
      };
      return ObjectExtensions.<NamespaceReference>operator_doubleArrow(_createNamespaceReference, _function);
    } else {
      VariableReference _createVariableReference = StoexFactory.eINSTANCE.createVariableReference();
      final Procedure1<VariableReference> _function_1 = (VariableReference v) -> {
        v.setReferenceName(reference.getReferenceName());
      };
      return ObjectExtensions.<VariableReference>operator_doubleArrow(_createVariableReference, _function_1);
    }
  }

  public static VariableReference findVariableReference(final AbstractNamedReference reference) {
    VariableReference _switchResult = null;
    boolean _matched = false;
    if (reference instanceof NamespaceReference) {
      _matched=true;
      _switchResult = RepositoryConfigurer.findVariableReference(((NamespaceReference)reference).getInnerReference_NamespaceReference());
    }
    if (!_matched) {
      if (reference instanceof VariableReference) {
        _matched=true;
        _switchResult = ((VariableReference)reference);
      }
    }
    if (!_matched) {
      _switchResult = null;
    }
    return _switchResult;
  }

  public static VariableUsage createForReference(final RelativeReference reference) {
    VariableUsage _createVariableUsage = ParameterFactory.eINSTANCE.createVariableUsage();
    final Procedure1<VariableUsage> _function = (VariableUsage v) -> {
      VariableCharacterisation _createVariableCharacterisation = ParameterFactory.eINSTANCE.createVariableCharacterisation();
      final Procedure1<VariableCharacterisation> _function_1 = (VariableCharacterisation vc) -> {
        vc.setType(VariableCharacterisationType.getByName(reference.getCharacteristic().getReferenceName()));
      };
      final VariableCharacterisation variable = ObjectExtensions.<VariableCharacterisation>operator_doubleArrow(_createVariableCharacterisation, _function_1);
      v.getVariableCharacterisation_VariableUsage().add(variable);
      variable.setVariableUsage_VariableCharacterisation(v);
    };
    return ObjectExtensions.<VariableUsage>operator_doubleArrow(_createVariableUsage, _function);
  }

  public static VariableUsage createForReference(final AbsoluteReference reference) {
    VariableUsage _createVariableUsage = ParameterFactory.eINSTANCE.createVariableUsage();
    final Procedure1<VariableUsage> _function = (VariableUsage v) -> {
      v.setNamedReference__VariableUsage(RepositoryConfigurer.copyReferences(reference.getReference()));
      final VariableReference characteristic = RepositoryConfigurer.findVariableReference(reference.getReference());
      if ((characteristic != null)) {
        VariableCharacterisation _createVariableCharacterisation = ParameterFactory.eINSTANCE.createVariableCharacterisation();
        final Procedure1<VariableCharacterisation> _function_1 = (VariableCharacterisation vc) -> {
          vc.setType(VariableCharacterisationType.getByName(characteristic.getReferenceName()));
        };
        final VariableCharacterisation variable = ObjectExtensions.<VariableCharacterisation>operator_doubleArrow(_createVariableCharacterisation, _function_1);
        v.getVariableCharacterisation_VariableUsage().add(variable);
        variable.setVariableUsage_VariableCharacterisation(v);
      }
    };
    return ObjectExtensions.<VariableUsage>operator_doubleArrow(_createVariableUsage, _function);
  }

  public static void assignRepository(final DataType type, final org.palladiosimulator.pcm.repository.Repository repo) {
    type.setRepository__DataType(repo);
    if ((type instanceof CompositeDataType)) {
      final Consumer<InnerDeclaration> _function = (InnerDeclaration inner) -> {
        if (((inner.getDatatype_InnerDeclaration() != null) && 
          (inner.getDatatype_InnerDeclaration().getRepository__DataType() == null))) {
          RepositoryConfigurer.assignRepository(inner.getDatatype_InnerDeclaration(), repo);
        } else {
          if (((inner.getCompositeDataType_InnerDeclaration() != null) && 
            (inner.getCompositeDataType_InnerDeclaration().getRepository__DataType() == null))) {
            RepositoryConfigurer.assignRepository(inner.getCompositeDataType_InnerDeclaration(), repo);
          } else {
            return;
          }
        }
      };
      ((CompositeDataType) type).getInnerDeclaration_CompositeDataType().forEach(_function);
    } else {
      if ((type instanceof CollectionDataType)) {
        RepositoryConfigurer.assignRepository(((CollectionDataType) type).getInnerType_CollectionDataType(), repo);
      }
    }
  }

  public static void updatePreviousAssignments(final EList<? extends AbstractAction> actions) {
    for (int i = 1; (i < ((Object[])Conversions.unwrapArray(actions, Object.class)).length); i++) {
      AbstractAction _get = actions.get(i);
      _get.setPredecessor_AbstractAction(actions.get((i - 1)));
    }
  }

  public static void updateSuccessorAssignments(final EList<? extends AbstractAction> actions) {
    for (int i = 0; (i < (((Object[])Conversions.unwrapArray(actions, Object.class)).length - 1)); i++) {
      AbstractAction _get = actions.get(i);
      _get.setSuccessor_AbstractAction(actions.get((i + 1)));
    }
  }

  public static List<SEFFConditionalAlternative> collectAllBranches(final SEFFConditionalAction action) {
    final ArrayList<SEFFConditionalAlternative> all = new ArrayList<SEFFConditionalAlternative>();
    RepositoryConfigurer.collectAllBranches(action.getAlternative(), all);
    return all;
  }

  public static void collectAllBranches(final SEFFConditionalAlternative alternative, final List<SEFFConditionalAlternative> current) {
    if ((alternative != null)) {
      current.add(alternative);
      if ((alternative instanceof SEFFConditionalElseIf)) {
        final SEFFConditionalElseIf elseif = ((SEFFConditionalElseIf) alternative);
        RepositoryConfigurer.collectAllBranches(elseif.getAlternative(), current);
      }
    }
  }

  public static ResourceDemandingBehaviour createEmptyBehavior() {
    final ResourceDemandingBehaviour behavior = SeffFactory.eINSTANCE.createResourceDemandingBehaviour();
    behavior.getSteps_Behaviour().add(SeffFactory.eINSTANCE.createStartAction());
    behavior.getSteps_Behaviour().add(SeffFactory.eINSTANCE.createStopAction());
    return behavior;
  }

  public static void addStepsToBranch(final AbstractBranchTransition branch, final List<AbstractAction> steps) {
    final ResourceDemandingBehaviour behavior = branch.getBranchBehaviour_BranchTransition();
    behavior.getSteps_Behaviour().add(SeffFactory.eINSTANCE.createStartAction());
    behavior.getSteps_Behaviour().addAll(steps);
    behavior.getSteps_Behaviour().add(SeffFactory.eINSTANCE.createStopAction());
    RepositoryConfigurer.updatePreviousAssignments(behavior.getSteps_Behaviour());
    RepositoryConfigurer.updateSuccessorAssignments(behavior.getSteps_Behaviour());
  }

  public static ResourceDemandingBehaviour addActions(final List<AbstractAction> steps) {
    final ResourceDemandingBehaviour behavior = RepositoryConfigurer.createEmptyBehavior();
    behavior.getSteps_Behaviour().addAll(1, steps);
    RepositoryConfigurer.updatePreviousAssignments(behavior.getSteps_Behaviour());
    RepositoryConfigurer.updateSuccessorAssignments(behavior.getSteps_Behaviour());
    return behavior;
  }
}
