package org.palladiosimulator.textual.tpcm.generator.pcm;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.palladiosimulator.pcm.core.entity.EntityFactory;
import org.palladiosimulator.pcm.core.entity.ResourceProvidedRole;
import org.palladiosimulator.pcm.reliability.ReliabilityFactory;
import org.palladiosimulator.pcm.reliability.SoftwareInducedFailureType;
import org.palladiosimulator.pcm.repository.DataType;
import org.palladiosimulator.pcm.repository.EventGroup;
import org.palladiosimulator.pcm.repository.EventType;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.RepositoryFactory;
import org.palladiosimulator.pcm.resourcetype.CommunicationLinkResourceType;
import org.palladiosimulator.pcm.resourcetype.ResourceInterface;
import org.palladiosimulator.pcm.resourcetype.ResourceRepository;
import org.palladiosimulator.pcm.resourcetype.ResourceSignature;
import org.palladiosimulator.pcm.resourcetype.ResourcetypeFactory;
import org.palladiosimulator.textual.commons.generator.registry.GeneratorRuleRegistrationFacade;
import org.palladiosimulator.textual.commons.generator.registry.GeneratorRulesRegistrationDelegate;
import org.palladiosimulator.textual.commons.generator.rules.GeneratorRuleBuilder;
import org.palladiosimulator.textual.tpcm.language.CommunicationLinkType;
import org.palladiosimulator.textual.tpcm.language.Datatype;
import org.palladiosimulator.textual.tpcm.language.DomainInterface;
import org.palladiosimulator.textual.tpcm.language.EventSignature;
import org.palladiosimulator.textual.tpcm.language.FailureType;
import org.palladiosimulator.textual.tpcm.language.Interface;
import org.palladiosimulator.textual.tpcm.language.InterfaceContent;
import org.palladiosimulator.textual.tpcm.language.InternalConfigurableInterface;
import org.palladiosimulator.textual.tpcm.language.OperationSignature;
import org.palladiosimulator.textual.tpcm.language.Parameter;
import org.palladiosimulator.textual.tpcm.language.ProcessingResourceType;
import org.palladiosimulator.textual.tpcm.language.ResourceInterfaceProvidedRole;
import org.palladiosimulator.textual.tpcm.language.ResourceTypeRepository;

@SuppressWarnings("all")
public class ResourceTypesConfigurer implements GeneratorRulesRegistrationDelegate {
  @Override
  public void doRegistration(final GeneratorRuleRegistrationFacade registry) {
    final Consumer<GeneratorRuleBuilder<DomainInterface, OperationInterface>> _function = (GeneratorRuleBuilder<DomainInterface, OperationInterface> it) -> {
      final Predicate<DomainInterface> _function_1 = (DomainInterface it_1) -> {
        final Function1<InterfaceContent, Boolean> _function_2 = (InterfaceContent it_2) -> {
          return Boolean.valueOf((it_2 instanceof OperationSignature));
        };
        return IterableExtensions.<InterfaceContent>forall(it_1.getContents(), _function_2);
      };
      it.setWhen(_function_1);
      final Function<DomainInterface, OperationInterface> _function_2 = (DomainInterface it_1) -> {
        OperationInterface _createOperationInterface = RepositoryFactory.eINSTANCE.createOperationInterface();
        final Procedure1<OperationInterface> _function_3 = (OperationInterface i) -> {
          i.setEntityName(it_1.getName());
        };
        return ObjectExtensions.<OperationInterface>operator_doubleArrow(_createOperationInterface, _function_3);
      };
      it.setCreate(_function_2);
      final Function<DomainInterface, List<OperationSignature>> _function_3 = (DomainInterface it_1) -> {
        return IterableExtensions.<OperationSignature>toList(Iterables.<OperationSignature>filter(it_1.getContents(), OperationSignature.class));
      };
      final BiConsumer<OperationInterface, List<org.palladiosimulator.pcm.repository.OperationSignature>> _function_4 = (OperationInterface iface, List<org.palladiosimulator.pcm.repository.OperationSignature> signatures) -> {
        EObjectExtensions.<org.palladiosimulator.pcm.repository.OperationSignature>addAllUnOwned(iface.getSignatures__OperationInterface(), signatures);
      };
      it.<OperationSignature, org.palladiosimulator.pcm.repository.OperationSignature>mapAll(_function_3, 
        org.palladiosimulator.pcm.repository.OperationSignature.class).thenSet(_function_4);
    };
    registry.<DomainInterface, OperationInterface>configure(DomainInterface.class, OperationInterface.class, _function);
    final Consumer<GeneratorRuleBuilder<DomainInterface, EventGroup>> _function_1 = (GeneratorRuleBuilder<DomainInterface, EventGroup> it) -> {
      final Predicate<DomainInterface> _function_2 = (DomainInterface it_1) -> {
        final Function1<InterfaceContent, Boolean> _function_3 = (InterfaceContent it_2) -> {
          return Boolean.valueOf((it_2 instanceof EventSignature));
        };
        return IterableExtensions.<InterfaceContent>forall(it_1.getContents(), _function_3);
      };
      it.setWhen(_function_2);
      final Function<DomainInterface, EventGroup> _function_3 = (DomainInterface it_1) -> {
        EventGroup _createEventGroup = RepositoryFactory.eINSTANCE.createEventGroup();
        final Procedure1<EventGroup> _function_4 = (EventGroup i) -> {
          i.setEntityName(it_1.getName());
        };
        return ObjectExtensions.<EventGroup>operator_doubleArrow(_createEventGroup, _function_4);
      };
      it.setCreate(_function_3);
      final Function<DomainInterface, List<EventSignature>> _function_4 = (DomainInterface it_1) -> {
        return IterableExtensions.<EventSignature>toList(Iterables.<EventSignature>filter(it_1.getContents(), EventSignature.class));
      };
      final BiConsumer<EventGroup, List<EventType>> _function_5 = (EventGroup iface, List<EventType> signatures) -> {
        EObjectExtensions.<EventType>addAllUnOwned(iface.getEventTypes__EventGroup(), signatures);
      };
      it.<EventSignature, EventType>mapAll(_function_4, EventType.class).thenSet(_function_5);
    };
    registry.<DomainInterface, EventGroup>configure(DomainInterface.class, EventGroup.class, _function_1);
    final Consumer<GeneratorRuleBuilder<OperationSignature, org.palladiosimulator.pcm.repository.OperationSignature>> _function_2 = (GeneratorRuleBuilder<OperationSignature, org.palladiosimulator.pcm.repository.OperationSignature> it) -> {
      final Function<OperationSignature, org.palladiosimulator.pcm.repository.OperationSignature> _function_3 = (OperationSignature it_1) -> {
        org.palladiosimulator.pcm.repository.OperationSignature _createOperationSignature = RepositoryFactory.eINSTANCE.createOperationSignature();
        final Procedure1<org.palladiosimulator.pcm.repository.OperationSignature> _function_4 = (org.palladiosimulator.pcm.repository.OperationSignature s) -> {
          s.setEntityName(it_1.getName());
        };
        return ObjectExtensions.<org.palladiosimulator.pcm.repository.OperationSignature>operator_doubleArrow(_createOperationSignature, _function_4);
      };
      it.setCreate(_function_3);
      final Function<OperationSignature, EList<Parameter>> _function_4 = (OperationSignature it_1) -> {
        return it_1.getParameters();
      };
      final BiConsumer<org.palladiosimulator.pcm.repository.OperationSignature, List<org.palladiosimulator.pcm.repository.Parameter>> _function_5 = (org.palladiosimulator.pcm.repository.OperationSignature sig, List<org.palladiosimulator.pcm.repository.Parameter> params) -> {
        EObjectExtensions.<org.palladiosimulator.pcm.repository.Parameter>addAllUnOwned(sig.getParameters__OperationSignature(), params);
      };
      it.<Parameter, org.palladiosimulator.pcm.repository.Parameter>mapAll(_function_4).thenSet(_function_5);
      final Function<OperationSignature, Datatype> _function_6 = (OperationSignature it_1) -> {
        return it_1.getReturn();
      };
      final BiConsumer<org.palladiosimulator.pcm.repository.OperationSignature, DataType> _function_7 = (org.palladiosimulator.pcm.repository.OperationSignature sig, DataType ret) -> {
        sig.setReturnType__OperationSignature(ret);
      };
      it.<Datatype, DataType>map(_function_6).thenSet(_function_7);
    };
    registry.<OperationSignature, org.palladiosimulator.pcm.repository.OperationSignature>configure(OperationSignature.class, org.palladiosimulator.pcm.repository.OperationSignature.class, _function_2);
    final Consumer<GeneratorRuleBuilder<EventSignature, EventType>> _function_3 = (GeneratorRuleBuilder<EventSignature, EventType> it) -> {
      final Function<EventSignature, EventType> _function_4 = (EventSignature it_1) -> {
        EventType _createEventType = RepositoryFactory.eINSTANCE.createEventType();
        final Procedure1<EventType> _function_5 = (EventType e) -> {
          e.setEntityName(it_1.getName());
        };
        return ObjectExtensions.<EventType>operator_doubleArrow(_createEventType, _function_5);
      };
      it.setCreate(_function_4);
      final Function<EventSignature, Parameter> _function_5 = (EventSignature it_1) -> {
        return IterableExtensions.<Parameter>head(it_1.getParameters());
      };
      final BiConsumer<EventType, org.palladiosimulator.pcm.repository.Parameter> _function_6 = (EventType sig, org.palladiosimulator.pcm.repository.Parameter param) -> {
        sig.setParameter__EventType(param);
      };
      it.<Parameter, org.palladiosimulator.pcm.repository.Parameter>map(_function_5).thenSet(_function_6);
    };
    registry.<EventSignature, EventType>configure(EventSignature.class, EventType.class, _function_3);
    final Consumer<GeneratorRuleBuilder<FailureType, org.palladiosimulator.pcm.reliability.FailureType>> _function_4 = (GeneratorRuleBuilder<FailureType, org.palladiosimulator.pcm.reliability.FailureType> it) -> {
      final Function<FailureType, org.palladiosimulator.pcm.reliability.FailureType> _function_5 = (FailureType it_1) -> {
        SoftwareInducedFailureType _createSoftwareInducedFailureType = ReliabilityFactory.eINSTANCE.createSoftwareInducedFailureType();
        final Procedure1<SoftwareInducedFailureType> _function_6 = (SoftwareInducedFailureType f) -> {
          f.setEntityName(it_1.getName());
        };
        return ObjectExtensions.<SoftwareInducedFailureType>operator_doubleArrow(_createSoftwareInducedFailureType, _function_6);
      };
      it.setCreate(_function_5);
    };
    registry.<FailureType, org.palladiosimulator.pcm.reliability.FailureType>configure(FailureType.class, org.palladiosimulator.pcm.reliability.FailureType.class, _function_4);
    final Consumer<GeneratorRuleBuilder<ResourceTypeRepository, ResourceRepository>> _function_5 = (GeneratorRuleBuilder<ResourceTypeRepository, ResourceRepository> it) -> {
      final Function<ResourceTypeRepository, ResourceRepository> _function_6 = (ResourceTypeRepository it_1) -> {
        return ResourcetypeFactory.eINSTANCE.createResourceRepository();
      };
      it.setCreate(_function_6);
      final Function<ResourceTypeRepository, List<Interface>> _function_7 = (ResourceTypeRepository it_1) -> {
        return IterableExtensions.<Interface>toList(Iterables.<Interface>filter(it_1.getContents(), Interface.class));
      };
      final BiConsumer<ResourceRepository, List<ResourceInterface>> _function_8 = (ResourceRepository resourceTypes, List<ResourceInterface> interfaces) -> {
        EObjectExtensions.<ResourceInterface>addAllUnOwned(resourceTypes.getResourceInterfaces__ResourceRepository(), interfaces);
      };
      it.<Interface, ResourceInterface>mapAll(_function_7, ResourceInterface.class).thenSet(_function_8);
    };
    registry.<ResourceTypeRepository, ResourceRepository>configure(ResourceTypeRepository.class, ResourceRepository.class, _function_5);
    final Consumer<GeneratorRuleBuilder<org.palladiosimulator.textual.tpcm.language.ResourceInterface, ResourceInterface>> _function_6 = (GeneratorRuleBuilder<org.palladiosimulator.textual.tpcm.language.ResourceInterface, ResourceInterface> it) -> {
      final Function<org.palladiosimulator.textual.tpcm.language.ResourceInterface, ResourceInterface> _function_7 = (org.palladiosimulator.textual.tpcm.language.ResourceInterface it_1) -> {
        ResourceInterface _createResourceInterface = ResourcetypeFactory.eINSTANCE.createResourceInterface();
        final Procedure1<ResourceInterface> _function_8 = (ResourceInterface i) -> {
          i.setEntityName(it_1.getName());
        };
        return ObjectExtensions.<ResourceInterface>operator_doubleArrow(_createResourceInterface, _function_8);
      };
      it.setCreate(_function_7);
      final Function<org.palladiosimulator.textual.tpcm.language.ResourceInterface, EList<InterfaceContent>> _function_8 = (org.palladiosimulator.textual.tpcm.language.ResourceInterface it_1) -> {
        return it_1.getContents();
      };
      final BiConsumer<ResourceInterface, List<ResourceSignature>> _function_9 = (ResourceInterface iface, List<ResourceSignature> signatures) -> {
        EObjectExtensions.<ResourceSignature>addAllUnOwned(iface.getResourceSignatures__ResourceInterface(), signatures);
      };
      it.<InterfaceContent, ResourceSignature>mapAll(_function_8, ResourceSignature.class).thenSet(_function_9);
    };
    registry.<org.palladiosimulator.textual.tpcm.language.ResourceInterface, ResourceInterface>configure(org.palladiosimulator.textual.tpcm.language.ResourceInterface.class, ResourceInterface.class, _function_6);
    final Consumer<GeneratorRuleBuilder<InternalConfigurableInterface, ResourceInterface>> _function_7 = (GeneratorRuleBuilder<InternalConfigurableInterface, ResourceInterface> it) -> {
      final Function<InternalConfigurableInterface, ResourceInterface> _function_8 = (InternalConfigurableInterface it_1) -> {
        ResourceInterface _createResourceInterface = ResourcetypeFactory.eINSTANCE.createResourceInterface();
        final Procedure1<ResourceInterface> _function_9 = (ResourceInterface i) -> {
          i.setEntityName(it_1.getName());
        };
        return ObjectExtensions.<ResourceInterface>operator_doubleArrow(_createResourceInterface, _function_9);
      };
      it.setCreate(_function_8);
      final Function<InternalConfigurableInterface, EList<InterfaceContent>> _function_9 = (InternalConfigurableInterface it_1) -> {
        return it_1.getContents();
      };
      final BiConsumer<ResourceInterface, List<ResourceSignature>> _function_10 = (ResourceInterface iface, List<ResourceSignature> signatures) -> {
        EObjectExtensions.<ResourceSignature>addAllUnOwned(iface.getResourceSignatures__ResourceInterface(), signatures);
      };
      it.<InterfaceContent, ResourceSignature>mapAll(_function_9, ResourceSignature.class).thenSet(_function_10);
    };
    registry.<InternalConfigurableInterface, ResourceInterface>configure(InternalConfigurableInterface.class, ResourceInterface.class, _function_7);
    final Consumer<GeneratorRuleBuilder<OperationSignature, ResourceSignature>> _function_8 = (GeneratorRuleBuilder<OperationSignature, ResourceSignature> it) -> {
      final Function<OperationSignature, ResourceSignature> _function_9 = (OperationSignature it_1) -> {
        ResourceSignature _createResourceSignature = ResourcetypeFactory.eINSTANCE.createResourceSignature();
        final Procedure1<ResourceSignature> _function_10 = (ResourceSignature s) -> {
          s.setEntityName(it_1.getName());
        };
        return ObjectExtensions.<ResourceSignature>operator_doubleArrow(_createResourceSignature, _function_10);
      };
      it.setCreate(_function_9);
      final Function<OperationSignature, EList<Parameter>> _function_10 = (OperationSignature it_1) -> {
        return it_1.getParameters();
      };
      final BiConsumer<ResourceSignature, List<org.palladiosimulator.pcm.repository.Parameter>> _function_11 = (ResourceSignature signature, List<org.palladiosimulator.pcm.repository.Parameter> params) -> {
        EObjectExtensions.<org.palladiosimulator.pcm.repository.Parameter>addAllUnOwned(signature.getParameter__ResourceSignature(), params);
      };
      it.<Parameter, org.palladiosimulator.pcm.repository.Parameter>mapAll(_function_10).thenSet(_function_11);
    };
    registry.<OperationSignature, ResourceSignature>configure(OperationSignature.class, ResourceSignature.class, _function_8);
    final Consumer<GeneratorRuleBuilder<Parameter, org.palladiosimulator.pcm.repository.Parameter>> _function_9 = (GeneratorRuleBuilder<Parameter, org.palladiosimulator.pcm.repository.Parameter> it) -> {
      final Function<Parameter, org.palladiosimulator.pcm.repository.Parameter> _function_10 = (Parameter it_1) -> {
        org.palladiosimulator.pcm.repository.Parameter _createParameter = RepositoryFactory.eINSTANCE.createParameter();
        final Procedure1<org.palladiosimulator.pcm.repository.Parameter> _function_11 = (org.palladiosimulator.pcm.repository.Parameter p) -> {
          p.setParameterName(it_1.getName());
        };
        return ObjectExtensions.<org.palladiosimulator.pcm.repository.Parameter>operator_doubleArrow(_createParameter, _function_11);
      };
      it.setCreate(_function_10);
      final Function<Parameter, Datatype> _function_11 = (Parameter it_1) -> {
        return it_1.getType();
      };
      final BiConsumer<org.palladiosimulator.pcm.repository.Parameter, DataType> _function_12 = (org.palladiosimulator.pcm.repository.Parameter param, DataType type) -> {
        param.setDataType__Parameter(type);
      };
      it.<Datatype, DataType>map(_function_11).thenSet(_function_12);
    };
    registry.<Parameter, org.palladiosimulator.pcm.repository.Parameter>configure(Parameter.class, org.palladiosimulator.pcm.repository.Parameter.class, _function_9);
    final Consumer<GeneratorRuleBuilder<ProcessingResourceType, org.palladiosimulator.pcm.resourcetype.ProcessingResourceType>> _function_10 = (GeneratorRuleBuilder<ProcessingResourceType, org.palladiosimulator.pcm.resourcetype.ProcessingResourceType> it) -> {
      final Function<ProcessingResourceType, org.palladiosimulator.pcm.resourcetype.ProcessingResourceType> _function_11 = (ProcessingResourceType it_1) -> {
        org.palladiosimulator.pcm.resourcetype.ProcessingResourceType _createProcessingResourceType = ResourcetypeFactory.eINSTANCE.createProcessingResourceType();
        final Procedure1<org.palladiosimulator.pcm.resourcetype.ProcessingResourceType> _function_12 = (org.palladiosimulator.pcm.resourcetype.ProcessingResourceType t) -> {
          t.setEntityName(it_1.getName());
        };
        return ObjectExtensions.<org.palladiosimulator.pcm.resourcetype.ProcessingResourceType>operator_doubleArrow(_createProcessingResourceType, _function_12);
      };
      it.setCreate(_function_11);
      final Function<ProcessingResourceType, List<ResourceInterfaceProvidedRole>> _function_12 = (ProcessingResourceType it_1) -> {
        return IterableExtensions.<ResourceInterfaceProvidedRole>toList(Iterables.<ResourceInterfaceProvidedRole>filter(it_1.getContents(), ResourceInterfaceProvidedRole.class));
      };
      final BiConsumer<org.palladiosimulator.pcm.resourcetype.ProcessingResourceType, List<ResourceProvidedRole>> _function_13 = (org.palladiosimulator.pcm.resourcetype.ProcessingResourceType type, List<ResourceProvidedRole> roles) -> {
        EObjectExtensions.<ResourceProvidedRole>addAllUnOwned(type.getResourceProvidedRoles__ResourceInterfaceProvidingEntity(), roles);
      };
      it.<ResourceInterfaceProvidedRole, ResourceProvidedRole>mapAll(_function_12).thenSet(_function_13);
    };
    registry.<ProcessingResourceType, org.palladiosimulator.pcm.resourcetype.ProcessingResourceType>configure(ProcessingResourceType.class, org.palladiosimulator.pcm.resourcetype.ProcessingResourceType.class, _function_10);
    final Consumer<GeneratorRuleBuilder<ResourceInterfaceProvidedRole, ResourceProvidedRole>> _function_11 = (GeneratorRuleBuilder<ResourceInterfaceProvidedRole, ResourceProvidedRole> it) -> {
      final Function<ResourceInterfaceProvidedRole, ResourceProvidedRole> _function_12 = (ResourceInterfaceProvidedRole it_1) -> {
        return EntityFactory.eINSTANCE.createResourceProvidedRole();
      };
      it.setCreate(_function_12);
      final Function<ResourceInterfaceProvidedRole, org.palladiosimulator.textual.tpcm.language.ResourceInterface> _function_13 = (ResourceInterfaceProvidedRole it_1) -> {
        return it_1.getType();
      };
      final BiConsumer<ResourceProvidedRole, ResourceInterface> _function_14 = (ResourceProvidedRole role, ResourceInterface type) -> {
        role.setProvidedResourceInterface__ResourceProvidedRole(type);
      };
      it.<org.palladiosimulator.textual.tpcm.language.ResourceInterface, ResourceInterface>map(_function_13, ResourceInterface.class).thenSet(_function_14);
    };
    registry.<ResourceInterfaceProvidedRole, ResourceProvidedRole>configure(ResourceInterfaceProvidedRole.class, ResourceProvidedRole.class, _function_11);
    final Consumer<GeneratorRuleBuilder<CommunicationLinkType, CommunicationLinkResourceType>> _function_12 = (GeneratorRuleBuilder<CommunicationLinkType, CommunicationLinkResourceType> it) -> {
      final Function<CommunicationLinkType, CommunicationLinkResourceType> _function_13 = (CommunicationLinkType it_1) -> {
        CommunicationLinkResourceType _createCommunicationLinkResourceType = ResourcetypeFactory.eINSTANCE.createCommunicationLinkResourceType();
        final Procedure1<CommunicationLinkResourceType> _function_14 = (CommunicationLinkResourceType t) -> {
          t.setEntityName(it_1.getName());
        };
        return ObjectExtensions.<CommunicationLinkResourceType>operator_doubleArrow(_createCommunicationLinkResourceType, _function_14);
      };
      it.setCreate(_function_13);
    };
    registry.<CommunicationLinkType, CommunicationLinkResourceType>configure(CommunicationLinkType.class, CommunicationLinkResourceType.class, _function_12);
  }
}
