package org.palladiosimulator.textual.tpcm.generator.pcm;

import java.util.List;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.palladiosimulator.textual.tpcm.language.AllocationContext;
import org.palladiosimulator.textual.tpcm.language.AssemblyContext;
import org.palladiosimulator.textual.tpcm.language.ResourceContainer;

@SuppressWarnings("all")
public class SingleAssemblyAllocation {
  public final String name;

  public final AssemblyContext context;

  public final ResourceContainer container;

  private SingleAssemblyAllocation(final String name, final AssemblyContext context, final ResourceContainer container) {
    this.name = name;
    this.context = context;
    this.container = container;
  }

  public static List<SingleAssemblyAllocation> getAllFrom(final AllocationContext sourceContext) {
    final String name = sourceContext.getName();
    final ResourceContainer container = sourceContext.getSpec().getContainer();
    final Function1<AssemblyContext, SingleAssemblyAllocation> _function = (AssemblyContext it) -> {
      return new SingleAssemblyAllocation(name, it, container);
    };
    return IterableExtensions.<SingleAssemblyAllocation>toList(ListExtensions.<AssemblyContext, SingleAssemblyAllocation>map(sourceContext.getSpec().getAssemblies(), _function));
  }
}
