package org.palladiosimulator.textual.tpcm.util;

import com.google.common.base.Objects;
import de.uka.ipd.sdq.stoex.AbstractNamedReference;
import de.uka.ipd.sdq.stoex.NamespaceReference;
import de.uka.ipd.sdq.stoex.StoexPackage;
import de.uka.ipd.sdq.stoex.VariableReference;
import java.util.Arrays;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.palladiosimulator.textual.tpcm.language.CollectionDatatype;
import org.palladiosimulator.textual.tpcm.language.ComposedDatatype;
import org.palladiosimulator.textual.tpcm.language.ComposedDatatypeElement;
import org.palladiosimulator.textual.tpcm.language.Datatype;
import org.palladiosimulator.textual.tpcm.language.LanguagePackage;
import org.palladiosimulator.textual.tpcm.language.PrimitiveDatatype;
import org.palladiosimulator.textual.tpcm.language.PrimitiveTypeEnum;

@SuppressWarnings("all")
public class NamedReferenceDataTypeResolver implements INamedReferenceDataTypeResolver {
  @Override
  public Either<FeatureBasedTraversalError, PrimitiveTypeEnum> resolveRequiredPrimitive(final AbstractNamedReference ref, final Datatype datatype) {
    return this.resolve(ref, datatype);
  }

  protected Either<FeatureBasedTraversalError, PrimitiveTypeEnum> _resolve(final NamespaceReference ref, final ComposedDatatype datatype) {
    final Function1<ComposedDatatypeElement, Boolean> _function = (ComposedDatatypeElement it) -> {
      String _name = it.getName();
      String _referenceName = ref.getReferenceName();
      return Boolean.valueOf(Objects.equal(_name, _referenceName));
    };
    ComposedDatatypeElement nested = IterableExtensions.<ComposedDatatypeElement>findFirst(datatype.getElements(), _function);
    if ((nested == null)) {
      StringConcatenation _builder = new StringConcatenation();
      String _referenceName = ref.getReferenceName();
      _builder.append(_referenceName);
      _builder.append(" does not exist in the enclosing namespace");
      return Either.<FeatureBasedTraversalError, PrimitiveTypeEnum>forLeft(
        FeatureBasedTraversalError.create(StoexPackage.Literals.ABSTRACT_NAMED_REFERENCE__REFERENCE_NAME, ref, _builder.toString()));
    } else {
      Datatype _type = nested.getType();
      boolean _tripleNotEquals = (_type != null);
      if (_tripleNotEquals) {
        return this.resolve(ref.getInnerReference_NamespaceReference(), nested.getType());
      } else {
        Datatype _reference = nested.getReference();
        boolean _tripleNotEquals_1 = (_reference != null);
        if (_tripleNotEquals_1) {
          return this.resolve(ref.getInnerReference_NamespaceReference(), nested.getReference());
        } else {
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append("The type of ");
          String _name = nested.getName();
          _builder_1.append(_name);
          _builder_1.append(" cannot be determined.");
          return Either.<FeatureBasedTraversalError, PrimitiveTypeEnum>forLeft(
            FeatureBasedTraversalError.create(LanguagePackage.Literals.COMPOSED_DATATYPE_ELEMENT__TYPE, nested, _builder_1.toString()));
        }
      }
    }
  }

  protected Either<FeatureBasedTraversalError, PrimitiveTypeEnum> _resolve(final NamespaceReference ref, final CollectionDatatype datatype) {
    String _referenceName = ref.getReferenceName();
    if (_referenceName != null) {
      switch (_referenceName) {
        case "INNER":
          return this.resolve(ref.getInnerReference_NamespaceReference(), datatype.getCollectionType());
        default:
          StringConcatenation _builder = new StringConcatenation();
          String _referenceName_1 = ref.getReferenceName();
          _builder.append(_referenceName_1);
          _builder.append(" is not a valid member of a collection type. Use INNER if you want to refer to the type of the collection elements.");
          return Either.<FeatureBasedTraversalError, PrimitiveTypeEnum>forLeft(
            FeatureBasedTraversalError.create(StoexPackage.Literals.ABSTRACT_NAMED_REFERENCE__REFERENCE_NAME, ref, _builder.toString()));
      }
    } else {
      StringConcatenation _builder = new StringConcatenation();
      String _referenceName_1 = ref.getReferenceName();
      _builder.append(_referenceName_1);
      _builder.append(" is not a valid member of a collection type. Use INNER if you want to refer to the type of the collection elements.");
      return Either.<FeatureBasedTraversalError, PrimitiveTypeEnum>forLeft(
        FeatureBasedTraversalError.create(StoexPackage.Literals.ABSTRACT_NAMED_REFERENCE__REFERENCE_NAME, ref, _builder.toString()));
    }
  }

  protected Either<FeatureBasedTraversalError, PrimitiveTypeEnum> _resolve(final VariableReference ref, final PrimitiveDatatype datatype) {
    String _referenceName = ref.getReferenceName();
    if (_referenceName != null) {
      switch (_referenceName) {
        case "BYTESIZE":
          return Either.<FeatureBasedTraversalError, PrimitiveTypeEnum>forRight(PrimitiveTypeEnum.INT);
        case "VALUE":
          return Either.<FeatureBasedTraversalError, PrimitiveTypeEnum>forRight(datatype.getType());
        case "TYPE":
          return Either.<FeatureBasedTraversalError, PrimitiveTypeEnum>forRight(PrimitiveTypeEnum.STRING);
        case "STRUCTURE":
          return Either.<FeatureBasedTraversalError, PrimitiveTypeEnum>forRight(PrimitiveTypeEnum.STRING);
        default:
          StringConcatenation _builder = new StringConcatenation();
          String _referenceName_1 = ref.getReferenceName();
          _builder.append(_referenceName_1);
          _builder.append(" is not a valid characteristic for the type ");
          String _name = datatype.getName();
          _builder.append(_name);
          _builder.append(".");
          return Either.<FeatureBasedTraversalError, PrimitiveTypeEnum>forLeft(
            FeatureBasedTraversalError.create(StoexPackage.Literals.ABSTRACT_NAMED_REFERENCE__REFERENCE_NAME, ref, _builder.toString()));
      }
    } else {
      StringConcatenation _builder = new StringConcatenation();
      String _referenceName_1 = ref.getReferenceName();
      _builder.append(_referenceName_1);
      _builder.append(" is not a valid characteristic for the type ");
      String _name = datatype.getName();
      _builder.append(_name);
      _builder.append(".");
      return Either.<FeatureBasedTraversalError, PrimitiveTypeEnum>forLeft(
        FeatureBasedTraversalError.create(StoexPackage.Literals.ABSTRACT_NAMED_REFERENCE__REFERENCE_NAME, ref, _builder.toString()));
    }
  }

  protected Either<FeatureBasedTraversalError, PrimitiveTypeEnum> _resolve(final VariableReference ref, final CollectionDatatype datatype) {
    String _referenceName = ref.getReferenceName();
    if (_referenceName != null) {
      switch (_referenceName) {
        case "BYTESIZE":
          return Either.<FeatureBasedTraversalError, PrimitiveTypeEnum>forRight(PrimitiveTypeEnum.INT);
        case "NUMBER_OF_ELEMENTS":
          return Either.<FeatureBasedTraversalError, PrimitiveTypeEnum>forRight(PrimitiveTypeEnum.INT);
        case "TYPE":
          return Either.<FeatureBasedTraversalError, PrimitiveTypeEnum>forRight(PrimitiveTypeEnum.STRING);
        case "STRUCTURE":
          return Either.<FeatureBasedTraversalError, PrimitiveTypeEnum>forRight(PrimitiveTypeEnum.STRING);
        default:
          StringConcatenation _builder = new StringConcatenation();
          String _referenceName_1 = ref.getReferenceName();
          _builder.append(_referenceName_1);
          _builder.append(" is not a valid characteristic on a collection type.");
          return Either.<FeatureBasedTraversalError, PrimitiveTypeEnum>forLeft(
            FeatureBasedTraversalError.create(StoexPackage.Literals.ABSTRACT_NAMED_REFERENCE__REFERENCE_NAME, ref, _builder.toString()));
      }
    } else {
      StringConcatenation _builder = new StringConcatenation();
      String _referenceName_1 = ref.getReferenceName();
      _builder.append(_referenceName_1);
      _builder.append(" is not a valid characteristic on a collection type.");
      return Either.<FeatureBasedTraversalError, PrimitiveTypeEnum>forLeft(
        FeatureBasedTraversalError.create(StoexPackage.Literals.ABSTRACT_NAMED_REFERENCE__REFERENCE_NAME, ref, _builder.toString()));
    }
  }

  protected Either<FeatureBasedTraversalError, PrimitiveTypeEnum> _resolve(final VariableReference ref, final ComposedDatatype datatype) {
    String _referenceName = ref.getReferenceName();
    if (_referenceName != null) {
      switch (_referenceName) {
        case "BYTESIZE":
          return Either.<FeatureBasedTraversalError, PrimitiveTypeEnum>forRight(PrimitiveTypeEnum.INT);
        case "TYPE":
          return Either.<FeatureBasedTraversalError, PrimitiveTypeEnum>forRight(PrimitiveTypeEnum.STRING);
        case "STRUCTURE":
          return Either.<FeatureBasedTraversalError, PrimitiveTypeEnum>forRight(PrimitiveTypeEnum.STRING);
        default:
          StringConcatenation _builder = new StringConcatenation();
          String _referenceName_1 = ref.getReferenceName();
          _builder.append(_referenceName_1);
          _builder.append(" is not a valid characteristic on a composition type.");
          return Either.<FeatureBasedTraversalError, PrimitiveTypeEnum>forLeft(
            FeatureBasedTraversalError.create(StoexPackage.Literals.ABSTRACT_NAMED_REFERENCE__REFERENCE_NAME, ref, _builder.toString()));
      }
    } else {
      StringConcatenation _builder = new StringConcatenation();
      String _referenceName_1 = ref.getReferenceName();
      _builder.append(_referenceName_1);
      _builder.append(" is not a valid characteristic on a composition type.");
      return Either.<FeatureBasedTraversalError, PrimitiveTypeEnum>forLeft(
        FeatureBasedTraversalError.create(StoexPackage.Literals.ABSTRACT_NAMED_REFERENCE__REFERENCE_NAME, ref, _builder.toString()));
    }
  }

  public Either<FeatureBasedTraversalError, PrimitiveTypeEnum> resolve(final AbstractNamedReference ref, final Datatype datatype) {
    if (ref instanceof NamespaceReference
         && datatype instanceof CollectionDatatype) {
      return _resolve((NamespaceReference)ref, (CollectionDatatype)datatype);
    } else if (ref instanceof NamespaceReference
         && datatype instanceof ComposedDatatype) {
      return _resolve((NamespaceReference)ref, (ComposedDatatype)datatype);
    } else if (ref instanceof VariableReference
         && datatype instanceof CollectionDatatype) {
      return _resolve((VariableReference)ref, (CollectionDatatype)datatype);
    } else if (ref instanceof VariableReference
         && datatype instanceof ComposedDatatype) {
      return _resolve((VariableReference)ref, (ComposedDatatype)datatype);
    } else if (ref instanceof VariableReference
         && datatype instanceof PrimitiveDatatype) {
      return _resolve((VariableReference)ref, (PrimitiveDatatype)datatype);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(ref, datatype).toString());
    }
  }
}
