/*
 * generated by Xtext 2.21.0
 */
package org.palladiosimulator.textual.tpcm.validation;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

import com.google.inject.Inject;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.URIMappingRegistryImpl;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.validation.Check;
import org.palladiosimulator.textual.tpcm.language.AbsoluteReference;
import org.palladiosimulator.textual.tpcm.language.AssemblyContext;
import org.palladiosimulator.textual.tpcm.language.Connector;
import org.palladiosimulator.textual.tpcm.language.DomainInterfaceProvidedRole;
import org.palladiosimulator.textual.tpcm.language.Import;
import org.palladiosimulator.textual.tpcm.language.Interface;
import org.palladiosimulator.textual.tpcm.language.InterfaceRequiredRole;
import org.palladiosimulator.textual.tpcm.language.LanguagePackage;
import org.palladiosimulator.textual.tpcm.language.Parameter;
import org.palladiosimulator.textual.tpcm.language.ParameterSpecification;
import org.palladiosimulator.textual.tpcm.language.PrimitiveTypeEnum;
import org.palladiosimulator.textual.tpcm.language.RelativeReference;
import org.palladiosimulator.textual.tpcm.language.SEFFCallAction;
import org.palladiosimulator.textual.tpcm.language.Signature;
import org.palladiosimulator.textual.tpcm.language.util.LanguageSwitch;
import org.palladiosimulator.textual.tpcm.scoping.TPCMImportUriGlobalScopeProvider;
import org.palladiosimulator.textual.tpcm.util.IExpressionPrimitiveTypeInference;
import org.palladiosimulator.textual.tpcm.util.INamedReferenceDataTypeResolver;
import org.palladiosimulator.textual.tpcm.util.IPrimitiveTypeComparison;

import de.uka.ipd.sdq.stoex.AbstractNamedReference;
import de.uka.ipd.sdq.stoex.StoexFactory;

/**
 * This class contains custom validation rules.
 *
 * See
 * https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#validation
 */
public class TPCMValidator extends AbstractTPCMValidator {
    protected static final AbstractNamedReference VALUE_REFERENCE = StoexFactory.eINSTANCE.createVariableReference();
    {
        VALUE_REFERENCE.setReferenceName("VALUE");
    }

    protected static final LanguageSwitch<AbstractNamedReference> NAMED_REFERENCE_EXTRACTOR = new LanguageSwitch<AbstractNamedReference>() {
        @Override
        public AbstractNamedReference caseAbsoluteReference(AbsoluteReference object) {
            return object.getReference()
                .getInnerReference_NamespaceReference();
        }

        @Override
        public AbstractNamedReference caseRelativeReference(RelativeReference object) {
            return object.getCharacteristic();
        }

    };

    @Inject
    IQualifiedNameProvider nameProvider;

    @Inject
    IQualifiedNameConverter nameConverter;

    @Inject
    INamedReferenceDataTypeResolver dtResolver;

    @Inject
    IExpressionPrimitiveTypeInference expressionTypeInference;

    @Inject
    IPrimitiveTypeComparison typeComparison;

    @Check
    public void checkSignaturesWithoutParametersAreNotCalledWithParameters(SEFFCallAction callAction) {
        if (callAction.getSignature()
            .getParameters()
            .isEmpty()
                && callAction.getParameters()
                    .size() > 0) {
            var name = nameConverter.toString(nameProvider.getFullyQualifiedName(callAction.getSignature()));
            error(String.format("%s does not expect any parameters", name), callAction,
                    LanguagePackage.Literals.SEFF_CALL_ACTION__PARAMETERS);
        }
    }

    @Check
    public void checkPositionalArgumentsDoNotFollowNamedArguments(SEFFCallAction callAction) {
        var positionalAllowed = true;
        for (var param : callAction.getParameters()) {
            if (!positionalAllowed && param.getReference() == null) {
                error("Positional short-hand value characterizations must not occur after named ones.", param,
                        LanguagePackage.Literals.SEFF_CALL_ACTION__PARAMETERS);
            }
            positionalAllowed &= (param.getReference() == null);
        }
    }

    @Check
    public void checkImportNamespaceIsValid(Import imp) {
        boolean validNamespace = true;
        var uri = URI.createURI(TPCMImportUriGlobalScopeProvider.getURIFromImport(imp));
        var resSet = imp.eResource().getResourceSet();
        
        if (resSet instanceof XtextResourceSet) {
            var xtextUriResolver = ((XtextResourceSet) imp.eResource().getResourceSet()).getClasspathUriResolver();
            var xtextUriContext = ((XtextResourceSet) imp.eResource().getResourceSet()).getClasspathURIContext();
            uri = xtextUriResolver.resolve(xtextUriContext, uri);
        }
        
        if (!EcoreUtil2.isValidUri(imp, uri)) {
            if (imp.getNamespace() != null) {
                var namespaceUri = String.format(TPCMImportUriGlobalScopeProvider.IMPORT_RESOURCES_PATHMAP_TEMPLATE,
                        imp.getNamespace().toUpperCase());
                var mappedURI = URIMappingRegistryImpl.INSTANCE.getURI(URI.createURI(namespaceUri));
                validNamespace = mappedURI.toString() != namespaceUri;
                if (!validNamespace)
                    error(String.format(
                            "The import namespace %s cannot be resolved. Make sure that there is a URI mapping for \"%s\".",
                            imp.getNamespace(), namespaceUri), imp, LanguagePackage.Literals.IMPORT__NAMESPACE);
            }
            
            if (validNamespace) {
                error(String.format(
                        "The referenced import cannot be resolved. Make sure that the URI \"%s\" is resolvable.",
                        uri.toString()), imp, LanguagePackage.Literals.IMPORT__IMPORT_URI);    
            }
        }
    }

    @Check
    public void checkCallParameterTypeIsCorrect(ParameterSpecification specification) {
        var container = specification.eContainer();

        if (!(container instanceof SEFFCallAction))
            return;

        var params = ((SEFFCallAction) container).getParameters();
        var signature = ((SEFFCallAction) container).getSignature();
        var expectedParams = signature.getParameters();
        Optional<Parameter> parameterDefinition = Optional.empty();
        AbstractNamedReference remainder = VALUE_REFERENCE;
        if (specification.getReference() == null) { // Positional value argument
            parameterDefinition = getParameterByIndex(specification, params, signature, expectedParams);
        } else {
            parameterDefinition = getParameterByNameOrPosition(specification, params, signature, expectedParams);

            remainder = NAMED_REFERENCE_EXTRACTOR.doSwitch(specification.getReference());
        }
        if (parameterDefinition.isPresent()) {
            var primitive = dtResolver.resolveRequiredPrimitive(remainder, parameterDefinition.get()
                .getType());
            if (primitive.isLeft()) {
                var error = primitive.getLeft();
                error(error.description, error.object, error.feature);
            } else {
                var currentType = expressionTypeInference.getExpressionType(specification.getSpecification());
                if (currentType.isEmpty()) {
                    warning("Could not determine type of expression", specification,
                            LanguagePackage.Literals.PARAMETER_SPECIFICATION__SPECIFICATION);
                } else {
                    //Typecasts required because the used implementation of Either returns an Object (https://github.com/eclipse-lsp4j/lsp4j/blob/main/org.eclipse.lsp4j.jsonrpc/src/main/java/org/eclipse/lsp4j/jsonrpc/messages/Either.java)
                    if (!typeComparison.isAssignableFrom((PrimitiveTypeEnum)primitive.get(), currentType.get())) {
                        error(String.format("An expression of type %s expected. Found %s", ((PrimitiveTypeEnum)primitive.get())
                            .toString(),
                                currentType.get()
                                    .toString()),
                                specification, LanguagePackage.Literals.PARAMETER_SPECIFICATION__SPECIFICATION);
                    }
                }
            }
        }
    }

    private Optional<Parameter> getParameterByIndex(ParameterSpecification specification,
            EList<ParameterSpecification> params, Signature signature, EList<Parameter> expectedParams) {
        var idx = params.indexOf(specification);
        Optional<Parameter> result = Optional.empty();
        if (idx >= expectedParams.size()) {
            error(String.format("Signature %s does not define more than %d parameters", nameOf(signature),
                    expectedParams.size()), specification,
                    LanguagePackage.Literals.PARAMETER_SPECIFICATION__SPECIFICATION);
        } else {
            result = Optional.of(expectedParams.get(idx));
        }
        return result;
    }

    private Optional<Parameter> getParameterByNameOrPosition(ParameterSpecification specification,
            EList<ParameterSpecification> params, Signature signature, EList<Parameter> expectedParams) {
        return (new LanguageSwitch<Optional<Parameter>>() {
            @Override
            public Optional<Parameter> caseAbsoluteReference(AbsoluteReference object) {
                var p = getNamedParameter(expectedParams, object.getReference());
                if (p.isEmpty()) {
                    error(String
                        .format("The signature %s does not define a parameter %s", nameOf(signature),
                                object.getReference()
                                    .getReferenceName()),
                            object, LanguagePackage.Literals.ABSOLUTE_REFERENCE__REFERENCE);
                }
                return p;
            }

            @Override
            public Optional<Parameter> caseRelativeReference(RelativeReference object) {
                var idx = params.indexOf(specification);
                var p = getIndexedParameter(expectedParams, idx);
                if (p.isEmpty()) {
                    error(String.format("Signature %s does not define more than %d parameters", nameOf(signature),
                            expectedParams.size()), specification,
                            LanguagePackage.Literals.PARAMETER_SPECIFICATION__SPECIFICATION);
                }
                return p;
            }
        }).doSwitch(specification.getReference());
    }

    private String nameOf(Signature signature) {
        return nameConverter.toString(nameProvider.getFullyQualifiedName(signature));
    }

    private Optional<Parameter> getIndexedParameter(List<Parameter> parameters, int idx) {
        return idx >= parameters.size() ? Optional.empty() : Optional.of(parameters.get(idx));
    }

    private Optional<Parameter> getNamedParameter(Collection<Parameter> parameters, AbstractNamedReference reference) {
        return parameters.stream()
            .filter(p -> p.getName()
                .equals(reference.getReferenceName()))
            .findAny();
    }
    
    @Check
    public void checkAssemblyContextAssignmentIsExclusive(Connector connector) {
        if (connector.getRequiringRole() == null) {
            List<Interface> providedInterfaces = connector.getFrom().getComponent().getContents().stream()
                    .filter(DomainInterfaceProvidedRole.class::isInstance).map(DomainInterfaceProvidedRole.class::cast)
                    .map(i -> i.getType()).collect(Collectors.toList());
            List<Interface> requiredInterface = getTargetContext(connector).getComponent().getContents().stream()
                    .filter(InterfaceRequiredRole.class::isInstance).map(InterfaceRequiredRole.class::cast)
                    .map(i -> i.getType()).collect(Collectors.toList());

            List<Long> counts = providedInterfaces.stream().mapToLong(iface -> {
                return requiredInterface.stream().filter(otherInterface -> otherInterface == iface).count();
            }).filter(count -> count > 0).boxed().collect(Collectors.toList());

            if (counts.isEmpty()) {
                if (connector.getTarget() != null) {
                    error("The are no matching interfaces in these assembly contexts.",
                            LanguagePackage.Literals.CONNECTOR__TARGET);
                } else {
                    error("The are no matching interfaces in these assembly contexts.",
                            LanguagePackage.Literals.CONNECTOR__TO);
                }
            } else if (counts.size() > 1 || counts.get(0) > 1) {
                if (connector.getTarget() != null) {
                    error("Unclear how to connect assembly contexts. Please specify the target.",
                            LanguagePackage.Literals.CONNECTOR__TARGET);
                } else {
                    error("Unclear how to connect assembly contexts. Please specify the target.",
                            LanguagePackage.Literals.CONNECTOR__TO);
                }
            }
        } else {
            Interface requiredInterface = connector.getRequiringRole().getType();
            List<Interface> providedInterfaces = connector.getFrom().getComponent().getContents().stream()
                    .filter(DomainInterfaceProvidedRole.class::isInstance).map(DomainInterfaceProvidedRole.class::cast)
                    .map(i -> i.getType()).collect(Collectors.toList());
            
            if(!providedInterfaces.contains(requiredInterface)) {
                error("The are no matching interfaces in these assembly contexts.",
                        LanguagePackage.Literals.CONNECTOR__TO);
            }
        }
    }

    private static AssemblyContext getTargetContext(Connector connector) {
        if (connector.getTo() != null) {
            return connector.getTo();
        } else {
            return connector.getTarget();
        }
    }
}
