/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.textual.tpcm.resource;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionStrategy;
import org.eclipse.xtext.scoping.impl.ImportUriResolver;
import org.eclipse.xtext.util.IAcceptor;
import org.palladiosimulator.textual.tpcm.language.Model;

public class TPCMResourceDescriptionStrategy
extends DefaultResourceDescriptionStrategy {
    public static final String INCLUDES = "includes";
    public static final String ENTITY_TYPE = "entity_type";
    @Inject
    ImportUriResolver uriResolver;

    public boolean createEObjectDescriptions(EObject eObject, IAcceptor<IEObjectDescription> acceptor) {
        if (eObject instanceof Model) {
            this.createEObjectDescriptionForModel((Model)eObject, acceptor);
            return true;
        }
        return super.createEObjectDescriptions(eObject, acceptor);
    }

    private void createEObjectDescriptionForModel(Model model, IAcceptor<IEObjectDescription> acceptor) {
        ArrayList uris = Lists.newArrayList();
        model.getImports().stream().map(this.uriResolver).forEach(uris::add);
        HashMap<String, String> userData = new HashMap<String, String>();
        userData.put(INCLUDES, String.join((CharSequence)",", uris));
        acceptor.accept((Object)EObjectDescription.create((QualifiedName)QualifiedName.create((String)model.eResource().getURI().toString()), (EObject)model, userData));
    }
}

