/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.textual.tpcm.naming;

import com.google.inject.Inject;
import java.util.Arrays;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.palladiosimulator.textual.tpcm.language.AssemblyContext;
import org.palladiosimulator.textual.tpcm.language.Datatype;
import org.palladiosimulator.textual.tpcm.language.LanguagePackage;

public class TPCMQualifiedNameProvider
extends DefaultDeclarativeQualifiedNameProvider {
    @Inject
    private IQualifiedNameConverter converter;

    protected QualifiedName qualifiedName(AssemblyContext ctx) {
        QualifiedName qfn = this.getParentFQNWithoutDirectContainerIfInstance(ctx, LanguagePackage.Literals.SYSTEM_PROVIDED_ROLE, LanguagePackage.Literals.CONNECTOR);
        return qfn.append(this.converter.toQualifiedName(ctx.getName()));
    }

    protected QualifiedName qualifiedName(Datatype dt) {
        QualifiedName qfn = this.getParentFQNWithoutDirectContainerIfInstance(dt, LanguagePackage.Literals.COMPOSED_DATATYPE_ELEMENT);
        return qfn.append(this.converter.toQualifiedName(dt.getName()));
    }

    protected QualifiedName getParentFQNWithoutDirectContainerIfInstance(EObject object, EClass ... classes) {
        EObject directContainer;
        EObject container = directContainer = object.eContainer();
        if (directContainer != null && Arrays.asList(classes).stream().anyMatch(cls -> cls.isInstance((Object)directContainer))) {
            container = directContainer.eContainer();
        }
        if (container != null) {
            return this.getFullyQualifiedName(container);
        }
        return QualifiedName.EMPTY;
    }
}

