/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.textual.tpcm.scoping;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.scoping.impl.ImportUriGlobalScopeProvider;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.palladiosimulator.textual.tpcm.language.Import;
import org.palladiosimulator.textual.tpcm.language.Model;

public class TPCMImportUriGlobalScopeProvider
extends ImportUriGlobalScopeProvider {
    public static final String IMPORT_RESOURCES_PATHMAP_TEMPLATE = "pathmap://TPCM_RESOURCES_%s/";
    public static final String IMPORT_RESOURCES_URI_TEMPLATE = "pathmap://TPCM_RESOURCES_%s/%s.tpcm";
    @Inject
    IResourceScopeCache cache;

    public static String getURIFromImport(Import imp) {
        if (imp.getNamespace() != null) {
            return String.format(IMPORT_RESOURCES_URI_TEMPLATE, imp.getNamespace().toUpperCase(), imp.getImportURI());
        }
        return imp.getImportURI();
    }

    protected LinkedHashSet<URI> getImportedUris(final Resource resource) {
        return (LinkedHashSet)this.cache.get((Object)TPCMImportUriGlobalScopeProvider.class.getSimpleName(), resource, (Provider)new Provider<LinkedHashSet<URI>>(){

            public LinkedHashSet<URI> get() {
                LinkedHashSet<URI> uniqueImportURIs = new LinkedHashSet<URI>(5);
                IAcceptor collector = TPCMImportUriGlobalScopeProvider.this.createURICollector(resource, uniqueImportURIs);
                UnmodifiableIterator iterator = Iterators.filter((Iterator)resource.getContents().iterator(), Model.class);
                while (iterator.hasNext()) {
                    Model object = (Model)iterator.next();
                    object.getImports().stream().map(TPCMImportUriGlobalScopeProvider::getURIFromImport).forEach(arg_0 -> ((IAcceptor)collector).accept(arg_0));
                }
                Iterator uriIter = uniqueImportURIs.iterator();
                while (uriIter.hasNext()) {
                    if (EcoreUtil2.isValidUri((Resource)resource, (URI)((URI)uriIter.next()))) continue;
                    uriIter.remove();
                }
                return uniqueImportURIs;
            }
        });
    }
}

