/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.textual.tpcm.util;

import com.google.common.base.Objects;
import de.uka.ipd.sdq.stoex.AbstractNamedReference;
import de.uka.ipd.sdq.stoex.NamespaceReference;
import de.uka.ipd.sdq.stoex.StoexPackage;
import de.uka.ipd.sdq.stoex.VariableReference;
import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.palladiosimulator.textual.tpcm.language.CollectionDatatype;
import org.palladiosimulator.textual.tpcm.language.ComposedDatatype;
import org.palladiosimulator.textual.tpcm.language.ComposedDatatypeElement;
import org.palladiosimulator.textual.tpcm.language.Datatype;
import org.palladiosimulator.textual.tpcm.language.LanguagePackage;
import org.palladiosimulator.textual.tpcm.language.PrimitiveDatatype;
import org.palladiosimulator.textual.tpcm.language.PrimitiveTypeEnum;
import org.palladiosimulator.textual.tpcm.util.FeatureBasedTraversalError;
import org.palladiosimulator.textual.tpcm.util.INamedReferenceDataTypeResolver;

public class NamedReferenceDataTypeResolver
implements INamedReferenceDataTypeResolver {
    @Override
    public Either<FeatureBasedTraversalError, PrimitiveTypeEnum> resolveRequiredPrimitive(AbstractNamedReference ref, Datatype datatype) {
        return this.resolve(ref, datatype);
    }

    protected Either<FeatureBasedTraversalError, PrimitiveTypeEnum> _resolve(NamespaceReference ref, ComposedDatatype datatype) {
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            String _referenceName = ref.getReferenceName();
            return Objects.equal((Object)_name, (Object)_referenceName);
        };
        ComposedDatatypeElement nested = (ComposedDatatypeElement)IterableExtensions.findFirst(datatype.getElements(), (Functions.Function1)_function);
        if (nested == null) {
            StringConcatenation _builder = new StringConcatenation();
            String _referenceName = ref.getReferenceName();
            _builder.append(_referenceName);
            _builder.append(" does not exist in the enclosing namespace");
            return Either.forLeft((Object)FeatureBasedTraversalError.create((EStructuralFeature)StoexPackage.Literals.ABSTRACT_NAMED_REFERENCE__REFERENCE_NAME, (EObject)ref, _builder.toString()));
        }
        Datatype _type = nested.getType();
        boolean bl = _tripleNotEquals = _type != null;
        if (_tripleNotEquals) {
            return this.resolve(ref.getInnerReference_NamespaceReference(), nested.getType());
        }
        Datatype _reference = nested.getReference();
        boolean bl2 = _tripleNotEquals_1 = _reference != null;
        if (_tripleNotEquals_1) {
            return this.resolve(ref.getInnerReference_NamespaceReference(), nested.getReference());
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("The type of ");
        String _name = nested.getName();
        _builder_1.append(_name);
        _builder_1.append(" cannot be determined.");
        return Either.forLeft((Object)FeatureBasedTraversalError.create((EStructuralFeature)LanguagePackage.Literals.COMPOSED_DATATYPE_ELEMENT__TYPE, nested, _builder_1.toString()));
    }

    protected Either<FeatureBasedTraversalError, PrimitiveTypeEnum> _resolve(NamespaceReference ref, CollectionDatatype datatype) {
        block7: {
            String _referenceName = ref.getReferenceName();
            if (_referenceName == null) break block7;
            switch (_referenceName) {
                case "INNER": {
                    return this.resolve(ref.getInnerReference_NamespaceReference(), datatype.getCollectionType());
                }
            }
            StringConcatenation _builder = new StringConcatenation();
            String _referenceName_1 = ref.getReferenceName();
            _builder.append(_referenceName_1);
            _builder.append(" is not a valid member of a collection type. Use INNER if you want to refer to the type of the collection elements.");
            return Either.forLeft((Object)FeatureBasedTraversalError.create((EStructuralFeature)StoexPackage.Literals.ABSTRACT_NAMED_REFERENCE__REFERENCE_NAME, (EObject)ref, _builder.toString()));
        }
        StringConcatenation _builder = new StringConcatenation();
        String _referenceName_1 = ref.getReferenceName();
        _builder.append(_referenceName_1);
        _builder.append(" is not a valid member of a collection type. Use INNER if you want to refer to the type of the collection elements.");
        return Either.forLeft((Object)FeatureBasedTraversalError.create((EStructuralFeature)StoexPackage.Literals.ABSTRACT_NAMED_REFERENCE__REFERENCE_NAME, (EObject)ref, _builder.toString()));
    }

    protected Either<FeatureBasedTraversalError, PrimitiveTypeEnum> _resolve(VariableReference ref, PrimitiveDatatype datatype) {
        block16: {
            String _referenceName = ref.getReferenceName();
            if (_referenceName == null) break block16;
            switch (_referenceName) {
                case "BYTESIZE": {
                    return Either.forRight((Object)((Object)PrimitiveTypeEnum.INT));
                }
                case "VALUE": {
                    return Either.forRight((Object)((Object)datatype.getType()));
                }
                case "TYPE": {
                    return Either.forRight((Object)((Object)PrimitiveTypeEnum.STRING));
                }
                case "STRUCTURE": {
                    return Either.forRight((Object)((Object)PrimitiveTypeEnum.STRING));
                }
            }
            StringConcatenation _builder = new StringConcatenation();
            String _referenceName_1 = ref.getReferenceName();
            _builder.append(_referenceName_1);
            _builder.append(" is not a valid characteristic for the type ");
            String _name = datatype.getName();
            _builder.append(_name);
            _builder.append(".");
            return Either.forLeft((Object)FeatureBasedTraversalError.create((EStructuralFeature)StoexPackage.Literals.ABSTRACT_NAMED_REFERENCE__REFERENCE_NAME, (EObject)ref, _builder.toString()));
        }
        StringConcatenation _builder = new StringConcatenation();
        String _referenceName_1 = ref.getReferenceName();
        _builder.append(_referenceName_1);
        _builder.append(" is not a valid characteristic for the type ");
        String _name = datatype.getName();
        _builder.append(_name);
        _builder.append(".");
        return Either.forLeft((Object)FeatureBasedTraversalError.create((EStructuralFeature)StoexPackage.Literals.ABSTRACT_NAMED_REFERENCE__REFERENCE_NAME, (EObject)ref, _builder.toString()));
    }

    protected Either<FeatureBasedTraversalError, PrimitiveTypeEnum> _resolve(VariableReference ref, CollectionDatatype datatype) {
        block16: {
            String _referenceName = ref.getReferenceName();
            if (_referenceName == null) break block16;
            switch (_referenceName) {
                case "BYTESIZE": {
                    return Either.forRight((Object)((Object)PrimitiveTypeEnum.INT));
                }
                case "NUMBER_OF_ELEMENTS": {
                    return Either.forRight((Object)((Object)PrimitiveTypeEnum.INT));
                }
                case "TYPE": {
                    return Either.forRight((Object)((Object)PrimitiveTypeEnum.STRING));
                }
                case "STRUCTURE": {
                    return Either.forRight((Object)((Object)PrimitiveTypeEnum.STRING));
                }
            }
            StringConcatenation _builder = new StringConcatenation();
            String _referenceName_1 = ref.getReferenceName();
            _builder.append(_referenceName_1);
            _builder.append(" is not a valid characteristic on a collection type.");
            return Either.forLeft((Object)FeatureBasedTraversalError.create((EStructuralFeature)StoexPackage.Literals.ABSTRACT_NAMED_REFERENCE__REFERENCE_NAME, (EObject)ref, _builder.toString()));
        }
        StringConcatenation _builder = new StringConcatenation();
        String _referenceName_1 = ref.getReferenceName();
        _builder.append(_referenceName_1);
        _builder.append(" is not a valid characteristic on a collection type.");
        return Either.forLeft((Object)FeatureBasedTraversalError.create((EStructuralFeature)StoexPackage.Literals.ABSTRACT_NAMED_REFERENCE__REFERENCE_NAME, (EObject)ref, _builder.toString()));
    }

    protected Either<FeatureBasedTraversalError, PrimitiveTypeEnum> _resolve(VariableReference ref, ComposedDatatype datatype) {
        block13: {
            String _referenceName = ref.getReferenceName();
            if (_referenceName == null) break block13;
            switch (_referenceName) {
                case "BYTESIZE": {
                    return Either.forRight((Object)((Object)PrimitiveTypeEnum.INT));
                }
                case "TYPE": {
                    return Either.forRight((Object)((Object)PrimitiveTypeEnum.STRING));
                }
                case "STRUCTURE": {
                    return Either.forRight((Object)((Object)PrimitiveTypeEnum.STRING));
                }
            }
            StringConcatenation _builder = new StringConcatenation();
            String _referenceName_1 = ref.getReferenceName();
            _builder.append(_referenceName_1);
            _builder.append(" is not a valid characteristic on a composition type.");
            return Either.forLeft((Object)FeatureBasedTraversalError.create((EStructuralFeature)StoexPackage.Literals.ABSTRACT_NAMED_REFERENCE__REFERENCE_NAME, (EObject)ref, _builder.toString()));
        }
        StringConcatenation _builder = new StringConcatenation();
        String _referenceName_1 = ref.getReferenceName();
        _builder.append(_referenceName_1);
        _builder.append(" is not a valid characteristic on a composition type.");
        return Either.forLeft((Object)FeatureBasedTraversalError.create((EStructuralFeature)StoexPackage.Literals.ABSTRACT_NAMED_REFERENCE__REFERENCE_NAME, (EObject)ref, _builder.toString()));
    }

    public Either<FeatureBasedTraversalError, PrimitiveTypeEnum> resolve(AbstractNamedReference ref, Datatype datatype) {
        if (ref instanceof NamespaceReference && datatype instanceof CollectionDatatype) {
            return this._resolve((NamespaceReference)ref, (CollectionDatatype)datatype);
        }
        if (ref instanceof NamespaceReference && datatype instanceof ComposedDatatype) {
            return this._resolve((NamespaceReference)ref, (ComposedDatatype)datatype);
        }
        if (ref instanceof VariableReference && datatype instanceof CollectionDatatype) {
            return this._resolve((VariableReference)ref, (CollectionDatatype)datatype);
        }
        if (ref instanceof VariableReference && datatype instanceof ComposedDatatype) {
            return this._resolve((VariableReference)ref, (ComposedDatatype)datatype);
        }
        if (ref instanceof VariableReference && datatype instanceof PrimitiveDatatype) {
            return this._resolve((VariableReference)ref, (PrimitiveDatatype)datatype);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(ref, datatype).toString());
    }
}

