/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.textual.tpcm.validation;

import com.google.inject.Inject;
import de.uka.ipd.sdq.stoex.AbstractNamedReference;
import de.uka.ipd.sdq.stoex.StoexFactory;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.URIMappingRegistryImpl;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.resource.IClasspathUriResolver;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.validation.Check;
import org.palladiosimulator.textual.tpcm.language.AbsoluteReference;
import org.palladiosimulator.textual.tpcm.language.AssemblyContext;
import org.palladiosimulator.textual.tpcm.language.Connector;
import org.palladiosimulator.textual.tpcm.language.DomainInterfaceProvidedRole;
import org.palladiosimulator.textual.tpcm.language.Import;
import org.palladiosimulator.textual.tpcm.language.Interface;
import org.palladiosimulator.textual.tpcm.language.InterfaceRequiredRole;
import org.palladiosimulator.textual.tpcm.language.LanguagePackage;
import org.palladiosimulator.textual.tpcm.language.Parameter;
import org.palladiosimulator.textual.tpcm.language.ParameterSpecification;
import org.palladiosimulator.textual.tpcm.language.PrimitiveTypeEnum;
import org.palladiosimulator.textual.tpcm.language.RelativeReference;
import org.palladiosimulator.textual.tpcm.language.SEFFCallAction;
import org.palladiosimulator.textual.tpcm.language.Signature;
import org.palladiosimulator.textual.tpcm.language.util.LanguageSwitch;
import org.palladiosimulator.textual.tpcm.scoping.TPCMImportUriGlobalScopeProvider;
import org.palladiosimulator.textual.tpcm.util.FeatureBasedTraversalError;
import org.palladiosimulator.textual.tpcm.util.IExpressionPrimitiveTypeInference;
import org.palladiosimulator.textual.tpcm.util.INamedReferenceDataTypeResolver;
import org.palladiosimulator.textual.tpcm.util.IPrimitiveTypeComparison;
import org.palladiosimulator.textual.tpcm.validation.AbstractTPCMValidator;

public class TPCMValidator
extends AbstractTPCMValidator {
    protected static final AbstractNamedReference VALUE_REFERENCE = StoexFactory.eINSTANCE.createVariableReference();
    protected static final LanguageSwitch<AbstractNamedReference> NAMED_REFERENCE_EXTRACTOR = new LanguageSwitch<AbstractNamedReference>(){

        @Override
        public AbstractNamedReference caseAbsoluteReference(AbsoluteReference object) {
            return object.getReference().getInnerReference_NamespaceReference();
        }

        @Override
        public AbstractNamedReference caseRelativeReference(RelativeReference object) {
            return object.getCharacteristic();
        }
    };
    @Inject
    IQualifiedNameProvider nameProvider;
    @Inject
    IQualifiedNameConverter nameConverter;
    @Inject
    INamedReferenceDataTypeResolver dtResolver;
    @Inject
    IExpressionPrimitiveTypeInference expressionTypeInference;
    @Inject
    IPrimitiveTypeComparison typeComparison;

    public TPCMValidator() {
        VALUE_REFERENCE.setReferenceName("VALUE");
    }

    @Check
    public void checkSignaturesWithoutParametersAreNotCalledWithParameters(SEFFCallAction callAction) {
        if (callAction.getSignature().getParameters().isEmpty() && callAction.getParameters().size() > 0) {
            String name = this.nameConverter.toString(this.nameProvider.getFullyQualifiedName((EObject)callAction.getSignature()));
            this.error(String.format("%s does not expect any parameters", name), callAction, (EStructuralFeature)LanguagePackage.Literals.SEFF_CALL_ACTION__PARAMETERS);
        }
    }

    @Check
    public void checkPositionalArgumentsDoNotFollowNamedArguments(SEFFCallAction callAction) {
        boolean positionalAllowed = true;
        for (ParameterSpecification param : callAction.getParameters()) {
            if (!positionalAllowed && param.getReference() == null) {
                this.error("Positional short-hand value characterizations must not occur after named ones.", param, (EStructuralFeature)LanguagePackage.Literals.SEFF_CALL_ACTION__PARAMETERS);
            }
            positionalAllowed &= param.getReference() == null;
        }
    }

    @Check
    public void checkImportNamespaceIsValid(Import imp) {
        boolean validNamespace = true;
        URI uri = URI.createURI((String)TPCMImportUriGlobalScopeProvider.getURIFromImport(imp));
        ResourceSet resSet = imp.eResource().getResourceSet();
        if (resSet instanceof XtextResourceSet) {
            IClasspathUriResolver xtextUriResolver = ((XtextResourceSet)imp.eResource().getResourceSet()).getClasspathUriResolver();
            Object xtextUriContext = ((XtextResourceSet)imp.eResource().getResourceSet()).getClasspathURIContext();
            uri = xtextUriResolver.resolve(xtextUriContext, uri);
        }
        if (!EcoreUtil2.isValidUri((EObject)imp, (URI)uri)) {
            if (imp.getNamespace() != null) {
                String namespaceUri = String.format("pathmap://TPCM_RESOURCES_%s/", imp.getNamespace().toUpperCase());
                URI mappedURI = URIMappingRegistryImpl.INSTANCE.getURI(URI.createURI((String)namespaceUri));
                boolean bl = validNamespace = mappedURI.toString() != namespaceUri;
                if (!validNamespace) {
                    this.error(String.format("The import namespace %s cannot be resolved. Make sure that there is a URI mapping for \"%s\".", imp.getNamespace(), namespaceUri), imp, (EStructuralFeature)LanguagePackage.Literals.IMPORT__NAMESPACE);
                }
            }
            if (validNamespace) {
                this.error(String.format("The referenced import cannot be resolved. Make sure that the URI \"%s\" is resolvable.", uri.toString()), imp, (EStructuralFeature)LanguagePackage.Literals.IMPORT__IMPORT_URI);
            }
        }
    }

    @Check
    public void checkCallParameterTypeIsCorrect(ParameterSpecification specification) {
        EObject container = specification.eContainer();
        if (!(container instanceof SEFFCallAction)) {
            return;
        }
        EList<ParameterSpecification> params = ((SEFFCallAction)container).getParameters();
        Signature signature = ((SEFFCallAction)container).getSignature();
        EList<Parameter> expectedParams = signature.getParameters();
        Optional<Object> parameterDefinition = Optional.empty();
        AbstractNamedReference remainder = VALUE_REFERENCE;
        if (specification.getReference() == null) {
            parameterDefinition = this.getParameterByIndex(specification, params, signature, expectedParams);
        } else {
            parameterDefinition = this.getParameterByNameOrPosition(specification, params, signature, expectedParams);
            remainder = (AbstractNamedReference)NAMED_REFERENCE_EXTRACTOR.doSwitch(specification.getReference());
        }
        if (parameterDefinition.isPresent()) {
            Either<FeatureBasedTraversalError, PrimitiveTypeEnum> primitive = this.dtResolver.resolveRequiredPrimitive(remainder, ((Parameter)parameterDefinition.get()).getType());
            if (primitive.isLeft()) {
                FeatureBasedTraversalError error = (FeatureBasedTraversalError)primitive.getLeft();
                this.error(error.description, error.object, error.feature);
            } else {
                Optional<PrimitiveTypeEnum> currentType = this.expressionTypeInference.getExpressionType(specification.getSpecification());
                if (currentType.isEmpty()) {
                    this.warning("Could not determine type of expression", specification, (EStructuralFeature)LanguagePackage.Literals.PARAMETER_SPECIFICATION__SPECIFICATION);
                } else if (!this.typeComparison.isAssignableFrom((PrimitiveTypeEnum)((Object)primitive.get()), currentType.get())) {
                    this.error(String.format("An expression of type %s expected. Found %s", ((PrimitiveTypeEnum)((Object)primitive.get())).toString(), currentType.get().toString()), specification, (EStructuralFeature)LanguagePackage.Literals.PARAMETER_SPECIFICATION__SPECIFICATION);
                }
            }
        }
    }

    private Optional<Parameter> getParameterByIndex(ParameterSpecification specification, EList<ParameterSpecification> params, Signature signature, EList<Parameter> expectedParams) {
        int idx = params.indexOf((Object)specification);
        Optional<Parameter> result = Optional.empty();
        if (idx >= expectedParams.size()) {
            this.error(String.format("Signature %s does not define more than %d parameters", this.nameOf(signature), expectedParams.size()), specification, (EStructuralFeature)LanguagePackage.Literals.PARAMETER_SPECIFICATION__SPECIFICATION);
        } else {
            result = Optional.of((Parameter)expectedParams.get(idx));
        }
        return result;
    }

    private Optional<Parameter> getParameterByNameOrPosition(final ParameterSpecification specification, final EList<ParameterSpecification> params, final Signature signature, final EList<Parameter> expectedParams) {
        return (Optional)new LanguageSwitch<Optional<Parameter>>(){

            @Override
            public Optional<Parameter> caseAbsoluteReference(AbsoluteReference object) {
                Optional<Parameter> p = TPCMValidator.this.getNamedParameter((Collection<Parameter>)expectedParams, (AbstractNamedReference)object.getReference());
                if (p.isEmpty()) {
                    TPCMValidator.this.error(String.format("The signature %s does not define a parameter %s", TPCMValidator.this.nameOf(signature), object.getReference().getReferenceName()), object, (EStructuralFeature)LanguagePackage.Literals.ABSOLUTE_REFERENCE__REFERENCE);
                }
                return p;
            }

            @Override
            public Optional<Parameter> caseRelativeReference(RelativeReference object) {
                int idx = params.indexOf((Object)specification);
                Optional<Parameter> p = TPCMValidator.this.getIndexedParameter((List<Parameter>)expectedParams, idx);
                if (p.isEmpty()) {
                    TPCMValidator.this.error(String.format("Signature %s does not define more than %d parameters", TPCMValidator.this.nameOf(signature), expectedParams.size()), specification, (EStructuralFeature)LanguagePackage.Literals.PARAMETER_SPECIFICATION__SPECIFICATION);
                }
                return p;
            }
        }.doSwitch(specification.getReference());
    }

    private String nameOf(Signature signature) {
        return this.nameConverter.toString(this.nameProvider.getFullyQualifiedName((EObject)signature));
    }

    private Optional<Parameter> getIndexedParameter(List<Parameter> parameters, int idx) {
        return idx >= parameters.size() ? Optional.empty() : Optional.of(parameters.get(idx));
    }

    private Optional<Parameter> getNamedParameter(Collection<Parameter> parameters, AbstractNamedReference reference) {
        return parameters.stream().filter(p -> p.getName().equals(reference.getReferenceName())).findAny();
    }

    @Check
    public void checkAssemblyContextAssignmentIsExclusive(Connector connector) {
        if (connector.getRequiringRole() == null) {
            List providedInterfaces = connector.getFrom().getComponent().getContents().stream().filter(DomainInterfaceProvidedRole.class::isInstance).map(DomainInterfaceProvidedRole.class::cast).map(i -> i.getType()).collect(Collectors.toList());
            List requiredInterface = TPCMValidator.getTargetContext(connector).getComponent().getContents().stream().filter(InterfaceRequiredRole.class::isInstance).map(InterfaceRequiredRole.class::cast).map(i -> i.getType()).collect(Collectors.toList());
            List counts = providedInterfaces.stream().mapToLong(iface -> requiredInterface.stream().filter(otherInterface -> otherInterface == iface).count()).filter(count -> count > 0L).boxed().collect(Collectors.toList());
            if (counts.isEmpty()) {
                if (connector.getTarget() != null) {
                    this.error("The are no matching interfaces in these assembly contexts.", (EStructuralFeature)LanguagePackage.Literals.CONNECTOR__TARGET);
                } else {
                    this.error("The are no matching interfaces in these assembly contexts.", (EStructuralFeature)LanguagePackage.Literals.CONNECTOR__TO);
                }
            } else if (counts.size() > 1 || (Long)counts.get(0) > 1L) {
                if (connector.getTarget() != null) {
                    this.error("Unclear how to connect assembly contexts. Please specify the target.", (EStructuralFeature)LanguagePackage.Literals.CONNECTOR__TARGET);
                } else {
                    this.error("Unclear how to connect assembly contexts. Please specify the target.", (EStructuralFeature)LanguagePackage.Literals.CONNECTOR__TO);
                }
            }
        } else {
            Interface requiredInterface = connector.getRequiringRole().getType();
            List providedInterfaces = connector.getFrom().getComponent().getContents().stream().filter(DomainInterfaceProvidedRole.class::isInstance).map(DomainInterfaceProvidedRole.class::cast).map(i -> i.getType()).collect(Collectors.toList());
            if (!providedInterfaces.contains(requiredInterface)) {
                this.error("The are no matching interfaces in these assembly contexts.", (EStructuralFeature)LanguagePackage.Literals.CONNECTOR__TO);
            }
        }
    }

    private static AssemblyContext getTargetContext(Connector connector) {
        if (connector.getTo() != null) {
            return connector.getTo();
        }
        return connector.getTarget();
    }
}

