package org.palladiosimulator.xtext.helper;

import com.google.common.base.Objects;
import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.repository.CollectionDataType;
import org.palladiosimulator.pcm.repository.CompositeDataType;
import org.palladiosimulator.pcm.repository.Interface;

@SuppressWarnings("all")
public class PalladioQualifiedNameProvider extends DefaultDeclarativeQualifiedNameProvider {
  @Override
  public QualifiedName getFullyQualifiedName(final EObject obj) {
    return this.toFQN(obj);
  }

  protected QualifiedName _toFQN(final EObject d) {
    return QualifiedName.create(d.toString());
  }

  protected QualifiedName _toFQN(final Entity e) {
    QualifiedName _xblockexpression = null;
    {
      final EObject container = e.eContainer();
      if (((!Objects.equal(container, null)) && (container instanceof Entity))) {
        return QualifiedName.create(this.qualifiedName(container).toString(), e.getEntityName());
      }
      _xblockexpression = QualifiedName.create(e.getEntityName());
    }
    return _xblockexpression;
  }

  protected QualifiedName _toFQN(final CompositeDataType d) {
    return QualifiedName.create(d.getRepository__DataType().getEntityName(), d.getEntityName());
  }

  protected QualifiedName _toFQN(final CollectionDataType d) {
    return QualifiedName.create(d.getRepository__DataType().getEntityName(), d.getEntityName());
  }

  protected QualifiedName _toFQN(final Interface i) {
    return QualifiedName.create(i.getRepository__Interface().getEntityName(), i.getEntityName());
  }

  public QualifiedName toFQN(final EObject d) {
    if (d instanceof CollectionDataType) {
      return _toFQN((CollectionDataType)d);
    } else if (d instanceof CompositeDataType) {
      return _toFQN((CompositeDataType)d);
    } else if (d instanceof Interface) {
      return _toFQN((Interface)d);
    } else if (d instanceof Entity) {
      return _toFQN((Entity)d);
    } else if (d != null) {
      return _toFQN(d);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(d).toString());
    }
  }
}
