/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.pcm.confidentiality.attacker.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.palladiosimulator.pcm.confidentiality.attackerSpecification.AttackerSystemSpecificationContainer;
import org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.Attack;
import org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.AttackVector;
import org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.ConfidentialityImpact;
import org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.Role;
import org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.Vulnerability;
import org.palladiosimulator.pcm.confidentiality.attackerSpecification.pcmIntegration.PCMElement;
import org.palladiosimulator.pcm.confidentiality.attackerSpecification.pcmIntegration.ResourceEnvironmentElement;
import org.palladiosimulator.pcm.confidentiality.attackerSpecification.pcmIntegration.RoleSystemIntegration;
import org.palladiosimulator.pcm.confidentiality.attackerSpecification.pcmIntegration.SystemElement;
import org.palladiosimulator.pcm.confidentiality.attackerSpecification.pcmIntegration.VulnerabilitySystemIntegration;
import org.palladiosimulator.pcm.confidentiality.context.system.pcm.structure.MethodSpecification;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;

public final class VulnerabilityHelper {
    private static HashMap<String, List<Vulnerability>> vulnarabilityMap = new HashMap();

    private VulnerabilityHelper() {
        assert (false);
    }

    public static Vulnerability checkAttack(boolean authenticated, List<Vulnerability> vulnerabilities, List<Attack> attacks, AttackVector vector, List<Role> roles) {
        ArrayList<Vulnerability> applicableVulnerabilities = new ArrayList<Vulnerability>();
        for (Vulnerability vulnerability : vulnerabilities) {
            for (Attack attack : attacks) {
                if (!attack.canExploit(vulnerability, authenticated, vector)) continue;
                if (vulnerability.getConfidentialityImpact() == ConfidentialityImpact.HIGH) {
                    return vulnerability;
                }
                applicableVulnerabilities.add(vulnerability);
            }
        }
        Optional<Vulnerability> returnValue = applicableVulnerabilities.stream().filter(e -> e.getConfidentialityImpact() == ConfidentialityImpact.LOW).findAny();
        if (returnValue.isPresent()) {
            return returnValue.get();
        }
        return applicableVulnerabilities.stream().findAny().orElse(null);
    }

    public static void initializeVulnerabilityStorage(AttackerSystemSpecificationContainer vulnerabilityspecification) {
        VulnerabilityHelper.resetMap();
        List<VulnerabilitySystemIntegration> listVulnerabilitySystemIntegration = VulnerabilityHelper.filterSystemSpecification(vulnerabilityspecification);
        listVulnerabilitySystemIntegration.parallelStream().filter(e -> e.getPcmelement() != null).forEach(e -> {
            if (e.getPcmelement().getResourcecontainer() != null) {
                VulnerabilityHelper.putInMap(e.getPcmelement().getResourcecontainer().getId(), VulnerabilityHelper.getVulnerabilities(listVulnerabilitySystemIntegration, e.getPcmelement().getResourcecontainer()));
            } else if (e.getPcmelement().getLinkingresource() != null) {
                VulnerabilityHelper.putInMap(e.getPcmelement().getLinkingresource().getId(), VulnerabilityHelper.getVulnerabilities(listVulnerabilitySystemIntegration, e.getPcmelement().getLinkingresource()));
            } else if (e.getPcmelement().getAssemblycontext() != null && !e.getPcmelement().getAssemblycontext().isEmpty()) {
                VulnerabilityHelper.putInMap(((AssemblyContext)e.getPcmelement().getAssemblycontext().get(0)).getId(), VulnerabilityHelper.getVulnerabilities(listVulnerabilitySystemIntegration, (AssemblyContext)e.getPcmelement().getAssemblycontext().get(0)));
            } else if (e.getPcmelement().getMethodspecification() != null) {
                VulnerabilityHelper.putInMap(e.getPcmelement().getMethodspecification().getId(), VulnerabilityHelper.getVulnerabilities(listVulnerabilitySystemIntegration, e.getPcmelement().getMethodspecification()));
            }
        });
    }

    public static void resetMap() {
        vulnarabilityMap = new HashMap();
        vulnarabilityMap.clear();
    }

    private static synchronized void putInMap(String key, List<Vulnerability> value) {
        vulnarabilityMap.put(key, value);
    }

    public static List<Vulnerability> getVulnerabilities(AttackerSystemSpecificationContainer vulnerabilityspecification, ResourceContainer resource) {
        if (!vulnarabilityMap.containsKey(resource.getId())) {
            return new ArrayList<Vulnerability>();
        }
        return vulnarabilityMap.get(resource.getId());
    }

    private static List<VulnerabilitySystemIntegration> filterSystemSpecification(AttackerSystemSpecificationContainer vulnerabilityspecification) {
        return vulnerabilityspecification.getVulnerabilities().stream().filter(VulnerabilitySystemIntegration.class::isInstance).map(VulnerabilitySystemIntegration.class::cast).collect(Collectors.toList());
    }

    public static List<RoleSystemIntegration> getRoles(AttackerSystemSpecificationContainer vulnerabilityspecification) {
        return vulnerabilityspecification.getVulnerabilities().stream().filter(RoleSystemIntegration.class::isInstance).map(RoleSystemIntegration.class::cast).collect(Collectors.toList());
    }

    public static List<Vulnerability> getVulnerabilities(List<VulnerabilitySystemIntegration> vulnerabilitySpecification, ResourceContainer resource) {
        return VulnerabilityHelper.getVulnerbilities(vulnerabilitySpecification, ResourceEnvironmentElement::getResourcecontainer, (EObject)resource);
    }

    public static List<Vulnerability> getVulnerabilities(AttackerSystemSpecificationContainer vulnerabilityspecification, AssemblyContext component) {
        if (!vulnarabilityMap.containsKey(component.getId())) {
            return new ArrayList<Vulnerability>();
        }
        return vulnarabilityMap.get(component.getId());
    }

    public static List<Vulnerability> getVulnerabilities(AttackerSystemSpecificationContainer vulnerabilityspecification, MethodSpecification methodSpecification) {
        if (!vulnarabilityMap.containsKey(methodSpecification.getId())) {
            return new ArrayList<Vulnerability>();
        }
        return vulnarabilityMap.get(methodSpecification.getId());
    }

    public static List<Vulnerability> getVulnerabilities(List<VulnerabilitySystemIntegration> vulnerabilitySpecification, MethodSpecification methodSpecification) {
        return VulnerabilityHelper.getVulnerbilities(vulnerabilitySpecification, SystemElement::getMethodspecification, (EObject)methodSpecification);
    }

    public static List<Vulnerability> getVulnerabilities(List<VulnerabilitySystemIntegration> vulnerabilitySpecification, AssemblyContext component) {
        return vulnerabilitySpecification.stream().filter(target -> VulnerabilityHelper.filterAssemblyContexts((List<AssemblyContext>)target.getPcmelement().getAssemblycontext(), List.of(component))).map(VulnerabilitySystemIntegration::getVulnerability).collect(Collectors.toList());
    }

    public static List<Vulnerability> getVulnerabilities(AttackerSystemSpecificationContainer vulnerabilityspecification, LinkingResource resource) {
        if (!vulnarabilityMap.containsKey(resource.getId())) {
            return new ArrayList<Vulnerability>();
        }
        return vulnarabilityMap.get(resource.getId());
    }

    public static List<Vulnerability> getVulnerabilities(List<VulnerabilitySystemIntegration> vulnerabilitySpecification, LinkingResource resource) {
        return VulnerabilityHelper.getVulnerbilities(vulnerabilitySpecification, ResourceEnvironmentElement::getLinkingresource, (EObject)resource);
    }

    private static List<Vulnerability> getVulnerbilities(List<VulnerabilitySystemIntegration> specification, Function<PCMElement, EObject> method, EObject object) {
        return specification.stream().filter(e -> EcoreUtil.equals((EObject)((EObject)method.apply(e.getPcmelement())), (EObject)object)).map(VulnerabilitySystemIntegration::getVulnerability).collect(Collectors.toList());
    }

    private static boolean filterAssemblyContexts(List<AssemblyContext> target, List<AssemblyContext> component) {
        if (target.size() != component.size()) {
            return false;
        }
        for (AssemblyContext element : target) {
            if (EcoreUtil.equals((EObject)element, (EObject)((EObject)component.get(0)))) continue;
            return false;
        }
        return true;
    }
}

