/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.ml.sensitivity.analysis;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.palladiosimulator.dependability.ml.sensitivity.analysis.SensitivityAggregations;
import org.palladiosimulator.dependability.ml.sensitivity.analysis.SensitivityModel;
import org.palladiosimulator.dependability.ml.sensitivity.builder.ProbabilisticSensitivityModelBuilder;
import org.palladiosimulator.dependability.ml.sensitivity.builder.ProbabilityDistributionBuilder;
import org.palladiosimulator.dependability.ml.sensitivity.exception.MLSensitivityAnalysisException;
import org.palladiosimulator.dependability.ml.sensitivity.transformation.PropertyMeasure;
import org.palladiosimulator.dependability.ml.sensitivity.transformation.SensitivityProperty;
import org.palladiosimulator.dependability.ml.sensitivity.transformation.property.conversion.SensitivityPropertyConventions;
import org.palladiosimulator.envdyn.api.entity.bn.BayesianNetwork;
import org.palladiosimulator.envdyn.api.entity.bn.InputValue;
import org.palladiosimulator.envdyn.environment.staticmodel.GroundProbabilisticModel;
import org.palladiosimulator.envdyn.environment.staticmodel.GroundProbabilisticNetwork;
import org.palladiosimulator.envdyn.environment.staticmodel.GroundRandomVariable;
import org.palladiosimulator.envdyn.environment.staticmodel.ProbabilisticModelRepository;
import org.palladiosimulator.envdyn.environment.templatevariable.TemplateVariableDefinitions;
import tools.mdsd.probdist.api.entity.CategoricalValue;
import tools.mdsd.probdist.api.entity.Conditionable;
import tools.mdsd.probdist.api.entity.ConditionalProbabilityDistribution;
import tools.mdsd.probdist.api.entity.Value;
import tools.mdsd.probdist.api.factory.IProbabilityDistributionFactory;
import tools.mdsd.probdist.api.random.ISeedProvider;
import tools.mdsd.probdist.distributionfunction.Domain;
import tools.mdsd.probdist.distributionfunction.ParamRepresentation;
import tools.mdsd.probdist.distributionfunction.Parameter;
import tools.mdsd.probdist.distributionfunction.ProbabilityDistribution;
import tools.mdsd.probdist.distributionfunction.ProbabilityDistributionFunctionRepository;
import tools.mdsd.probdist.distributionfunction.SimpleParameter;
import tools.mdsd.probdist.distributionfunction.TabularCPD;

public class ProbabilisticSensitivityModel
extends SensitivityModel {
    private static final String DIST_MODEL_NAME = "ProbabilityDistributions";
    private static final String DIST_MODEL_EXT = "distributionfunction";
    private static final String PROB_MODEL_NAME = "ProbabilisticSensitivityModel";
    private static final String PROB_MODEL_EXT = "staticmodel";
    private static final String TEMPLATE_MODEL_NAME = "ProbabilisticSensitivityModel";
    private static final String TEMPLATE_MODEL_EXT = "templatevariable";
    private final TemplateVariableDefinitions templateVariables;
    private final GroundProbabilisticNetwork probSensitivityModel;
    private final IProbabilityDistributionFactory<CategoricalValue> probabilityDistributionFactory;
    private final Optional<ISeedProvider> seedProvider;
    private BayesianNetwork<CategoricalValue> bayesianNetwork;

    private ProbabilisticSensitivityModel(GroundProbabilisticNetwork probSensitivityModel, TemplateVariableDefinitions templateVariables, IProbabilityDistributionFactory<CategoricalValue> probabilityDistributionFactory, Optional<ISeedProvider> seedProvider) {
        this.probSensitivityModel = probSensitivityModel;
        this.templateVariables = templateVariables;
        this.bayesianNetwork = null;
        this.probabilityDistributionFactory = probabilityDistributionFactory;
        this.seedProvider = seedProvider;
    }

    private ProbabilisticSensitivityModel(IProbabilityDistributionFactory<CategoricalValue> probabilityDistributionFactory, Optional<ISeedProvider> seedProvider) {
        this(null, null, probabilityDistributionFactory, seedProvider);
    }

    public static ProbabilisticSensitivityModel createFrom(GroundProbabilisticNetwork probSensitivityModel, TemplateVariableDefinitions templateVariables, IProbabilityDistributionFactory<CategoricalValue> probabilityDistributionFactory, Optional<ISeedProvider> seedProvider) {
        return new ProbabilisticSensitivityModel(probSensitivityModel, templateVariables, probabilityDistributionFactory, seedProvider);
    }

    public static ProbabilisticSensitivityModel createFrom(Set<PropertyMeasure> propertyMeasures, IProbabilityDistributionFactory<CategoricalValue> probabilityDistributionFactory, Optional<ISeedProvider> seedProvider) {
        return new ProbabilisticSensitivityModel(probabilityDistributionFactory, seedProvider).deriveFrom((Set)propertyMeasures);
    }

    @Override
    public void setSensitivityValues(Map<SensitivityProperty, Double> sensitivityValues) {
        SensitivityProperty propertyName = this.getGlobalProperty(sensitivityValues);
        GroundProbabilisticModel probabilisticModel = this.findRandomVariableFor(propertyName).getDescriptiveModel();
        probabilisticModel.setDistribution(this.buildProbabilityDistributionOf(sensitivityValues));
    }

    @Override
    public double getSensitivityValuesOf(SensitivityProperty property) {
        GroundProbabilisticModel probabilisticModel = this.findRandomVariableFor(property).getDescriptiveModel();
        ParamRepresentation param = ((Parameter)probabilisticModel.getDistribution().getParams().get(0)).getRepresentation();
        if (param instanceof SimpleParameter) {
            return this.retrieveSensitivityValueOf(property, (SimpleParameter)param).orElse(0.0);
        }
        return 0.0;
    }

    @Override
    public void setMLSensitivityValues(Map<SensitivityAggregations.MLSensitivityEntry, Double> mlSensitivityValues) {
        GroundProbabilisticModel probabilisticModel = this.findMLRandomVariable().getDescriptiveModel();
        probabilisticModel.setDistribution(this.buildMLProbabilityOfSuccessDistribution(mlSensitivityValues));
    }

    @Override
    public double inferSensitivity(List<SensitivityProperty> properties) {
        List<InputValue<CategoricalValue>> inputs;
        if (Objects.isNull(this.bayesianNetwork)) {
            this.bayesianNetwork = new BayesianNetwork(null, this.probSensitivityModel, this.probabilityDistributionFactory);
            this.bayesianNetwork.init(Optional.empty());
        }
        if (this.isInferenceRequired(inputs = this.toInputValues(properties))) {
            return this.bayesianNetwork.infer(inputs);
        }
        return this.bayesianNetwork.probability(inputs);
    }

    @Override
    public double conditionalSensitivity(List<SensitivityProperty> properties) {
        ProbabilityDistribution dist = this.findMLRandomVariable().getDescriptiveModel().getDistribution();
        TabularCPD paramRep = (TabularCPD)((Parameter)dist.getParams().get(0)).getRepresentation();
        ConditionalProbabilityDistribution conditionalOutcomeDistribution = new ConditionalProbabilityDistribution(dist, paramRep, this.probabilityDistributionFactory);
        conditionalOutcomeDistribution.init(this.seedProvider);
        List conditionals = properties.stream().map(each -> new Conditionable.Conditional(Domain.CATEGORY, (Value)each.getValue())).collect(Collectors.toList());
        CategoricalValue outcomeEvent = (CategoricalValue)this.mlInputValue().getValue();
        return conditionalOutcomeDistribution.given(conditionals).probability(outcomeEvent);
    }

    @Override
    public void saveAt(java.net.URI location) {
        URI uri = URI.createURI((String)location.toString());
        if (Objects.nonNull(uri.fileExtension())) {
            return;
        }
        this.saveTemplateVariables(uri);
        this.saveDistributionFunctions(uri);
        this.saveGroundProbabilisticModel(uri);
    }

    @Override
    public ProbabilisticSensitivityModel deriveFrom(Set<PropertyMeasure> propertyMeasures) {
        ProbabilisticSensitivityModelBuilder builder = ProbabilisticSensitivityModelBuilder.get();
        propertyMeasures.forEach(builder::addSensitivityFactor);
        List<EObject> models = builder.build();
        ProbabilisticModelRepository groundNetworkRepo = this.getModelOfType(ProbabilisticModelRepository.class, models);
        TemplateVariableDefinitions templateVariables = this.getModelOfType(TemplateVariableDefinitions.class, models);
        return new ProbabilisticSensitivityModel((GroundProbabilisticNetwork)groundNetworkRepo.getModels().get(0), templateVariables, this.probabilityDistributionFactory, this.seedProvider);
    }

    private <T> T getModelOfType(Class<T> modelType, List<EObject> models) {
        for (EObject each : models) {
            if (!modelType.isInstance(each)) continue;
            return (T)each;
        }
        return null;
    }

    private boolean isInferenceRequired(List<InputValue<CategoricalValue>> inputs) {
        return this.bayesianNetwork.getGroundVariables().size() > inputs.size();
    }

    private List<InputValue<CategoricalValue>> toInputValues(List<SensitivityProperty> properties) {
        List<InputValue<CategoricalValue>> inputs = properties.stream().map(this::toInputValue).collect(Collectors.toList());
        inputs.add(this.mlInputValue());
        return inputs;
    }

    private InputValue<CategoricalValue> mlInputValue() {
        CategoricalValue value = CategoricalValue.create((String)this.outcomeMeasure.toString());
        GroundRandomVariable mlVariable = this.findMLRandomVariable();
        return InputValue.create((Value)value, (GroundRandomVariable)mlVariable);
    }

    private InputValue<CategoricalValue> toInputValue(SensitivityProperty property) {
        CategoricalValue value = property.getValue();
        GroundRandomVariable variable = this.findRandomVariableFor(property);
        return InputValue.create((Value)value, (GroundRandomVariable)variable);
    }

    private Optional<Double> retrieveSensitivityValueOf(SensitivityProperty property, SimpleParameter param) {
        String[] values = param.getValue().split(";");
        return Stream.of(values).map(this.parseValues()).filter(this.withValue(property.getValue())).map(v -> Double.valueOf(v[1])).findFirst();
    }

    private Function<String, String[]> parseValues() {
        return value -> new StringBuilder((String)value).deleteCharAt(0).deleteCharAt(value.length() - 2).toString().split(",");
    }

    private Predicate<String[]> withValue(CategoricalValue measuredValue) {
        return v -> v[0].equals(measuredValue.toString());
    }

    private void saveTemplateVariables(URI location) {
        URI adjustedLocation = location.appendSegment("ProbabilisticSensitivityModel").appendFileExtension(TEMPLATE_MODEL_EXT);
        this.save((EObject)this.templateVariables, adjustedLocation);
    }

    private void saveGroundProbabilisticModel(URI location) {
        URI adjustedLocation = location.appendSegment("ProbabilisticSensitivityModel").appendFileExtension(PROB_MODEL_EXT);
        this.save(this.probSensitivityModel.eContainer(), adjustedLocation);
    }

    private void saveDistributionFunctions(URI location) {
        URI adjustedLocation = location.appendSegment(DIST_MODEL_NAME).appendFileExtension(DIST_MODEL_EXT);
        ProbabilityDistributionFunctionRepository root = ProbabilityDistributionBuilder.mergeToSingleRepository(this.retrieveDistributions());
        this.save((EObject)root, adjustedLocation);
    }

    private void save(EObject root, URI adjustedLocation) {
        try {
            Resource resourceToSave = new ResourceSetImpl().createResource(adjustedLocation);
            resourceToSave.getContents().add((Object)root);
            resourceToSave.save((Map)Maps.newHashMap());
        }
        catch (IOException e) {
            MLSensitivityAnalysisException.throwWithMessageAndCause(String.format("Model %s could not be safed", adjustedLocation), e);
        }
    }

    private Set<ProbabilityDistribution> retrieveDistributions() {
        return this.probSensitivityModel.getLocalModels().stream().map(GroundProbabilisticModel::getDistribution).collect(Collectors.toSet());
    }

    private SensitivityProperty getGlobalProperty(Map<SensitivityProperty, Double> sensitivityValues) {
        return sensitivityValues.keySet().iterator().next();
    }

    private GroundRandomVariable findRandomVariableFor(SensitivityProperty property) {
        return this.probSensitivityModel.getLocalProbabilisticModels().stream().flatMap(each -> each.getGroundRandomVariables().stream()).filter(this.variableOf(property)).findFirst().orElseThrow(MLSensitivityAnalysisException.supplierWithMessage(String.format("There is no variable for measured property %s", property.getId())));
    }

    public GroundRandomVariable findMLRandomVariable() {
        return this.probSensitivityModel.getLocalProbabilisticModels().stream().flatMap(each -> each.getGroundRandomVariables().stream()).filter(this.variablesWithParents()).findFirst().orElseThrow(MLSensitivityAnalysisException.supplierWithMessage("No random variable for ml prediction was found."));
    }

    private Predicate<GroundRandomVariable> variablesWithParents() {
        return v -> !v.getDependenceStructure().isEmpty();
    }

    private Predicate<GroundRandomVariable> variableOf(SensitivityProperty property) {
        return v -> SensitivityPropertyConventions.areSemanticallyEqual(v, property);
    }

    private ProbabilityDistribution buildProbabilityDistributionOf(Map<SensitivityProperty, Double> sensitivityValues) {
        return ProbabilityDistributionBuilder.buildProbabilityDistributionFor(this.getGlobalProperty(sensitivityValues)).withSimpleParameterDerivedFrom(sensitivityValues).build();
    }

    private ProbabilityDistribution buildMLProbabilityOfSuccessDistribution(Map<SensitivityAggregations.MLSensitivityEntry, Double> sensitivityValues) {
        return ProbabilityDistributionBuilder.buildProbabilityDistributionForMLVariable().withTabularParameterDerivedFrom(sensitivityValues).build();
    }
}

