/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.ml.sensitivity.transformation;

import java.util.Objects;
import tools.mdsd.probdist.api.entity.CategoricalValue;

public abstract class SensitivityProperty {
    private static final String ID_VALUE_DELIMITER = "=";
    private final String id;
    private final CategoricalValue value;

    protected SensitivityProperty(String id, CategoricalValue value) {
        this.id = id;
        this.value = this.normalizeValueIfNecessary(value);
    }

    private CategoricalValue normalizeValueIfNecessary(CategoricalValue value) {
        return this.isAlreadyNormalized(value) ? value : this.enrichWithId(value);
    }

    private boolean isAlreadyNormalized(CategoricalValue value) {
        String[] components = ((String)value.get()).split(ID_VALUE_DELIMITER);
        if (components.length != 2) {
            return false;
        }
        String originalValue = new StringBuilder(components[1]).deleteCharAt(components[1].length() - 1).toString();
        return this.constructEnrichedValue(originalValue).equals(value.get());
    }

    private CategoricalValue enrichWithId(CategoricalValue value) {
        return CategoricalValue.create((String)this.constructEnrichedValue((String)value.get()));
    }

    private String constructEnrichedValue(String value) {
        return String.format("(%s)", this.getId().concat(ID_VALUE_DELIMITER).concat(value));
    }

    public CategoricalValue getValue() {
        return this.value;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object other) {
        if (!SensitivityProperty.class.isInstance(other)) {
            return false;
        }
        SensitivityProperty otherProperty = (SensitivityProperty)other;
        return ((String)otherProperty.value.get()).equals(this.value.get());
    }

    public int hashCode() {
        return Objects.hash(this.value.get());
    }

    public String toString() {
        return this.getValue().toString();
    }
}

