/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.ml.sensitivity.analysis;

import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Set;
import org.palladiosimulator.dependability.ml.sensitivity.analysis.MLAnalysisContext;
import org.palladiosimulator.dependability.ml.sensitivity.analysis.MLSensitivityAnalysisStrategy;
import org.palladiosimulator.dependability.ml.sensitivity.analysis.SensitivityModel;
import org.palladiosimulator.dependability.ml.sensitivity.exception.MLSensitivityAnalysisException;
import org.palladiosimulator.dependability.ml.sensitivity.transformation.AnalysisTransformation;
import org.palladiosimulator.dependability.ml.sensitivity.transformation.PropertyMeasure;

public class MLSensitivityAnalysis {
    private static AnalysisTransformation analysisTransformation;
    private final MLSensitivityAnalysisStrategy analysisStrategy;

    private MLSensitivityAnalysis(MLSensitivityAnalysisStrategy analysisStrategy) {
        this.analysisStrategy = analysisStrategy;
    }

    public static MLSensitivityAnalysisBuilder newBuilder() {
        return new MLSensitivityAnalysisBuilder();
    }

    public static AnalysisTransformation getAnalysisTransformation() {
        return analysisTransformation;
    }

    public SensitivityModel analyseSensitivity(MLAnalysisContext context) {
        return this.analysisStrategy.analyseSensitivity(context);
    }

    public static class MLSensitivityAnalysisBuilder {
        private Set<PropertyMeasure> propertyMeasures = Sets.newHashSet();
        private MLSensitivityAnalysisStrategy analysisStrategy = null;

        public MLSensitivityAnalysisBuilder withSensitivityAnalysisStrategy(MLSensitivityAnalysisStrategy analysisStrategy) {
            this.analysisStrategy = analysisStrategy;
            return this;
        }

        public MLSensitivityAnalysisBuilder addPropertyMeasure(PropertyMeasure propertyMeasure) {
            this.propertyMeasures.add(propertyMeasure);
            return this;
        }

        public MLSensitivityAnalysis build() {
            Objects.requireNonNull(this.analysisStrategy, "There has to be a sensitive analysis strategy specified.");
            if (this.propertyMeasures.isEmpty()) {
                MLSensitivityAnalysisException.throwWithMessageAndCause("There hast to be at least one property measure.", new IllegalArgumentException());
            }
            analysisTransformation = new AnalysisTransformation(this.propertyMeasures);
            return new MLSensitivityAnalysis(this.analysisStrategy);
        }
    }
}

