/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.ml.sensitivity.analysis;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.palladiosimulator.dependability.ml.sensitivity.exception.MLSensitivityAnalysisException;
import org.palladiosimulator.dependability.ml.sensitivity.transformation.PropertyMeasure;
import org.palladiosimulator.dependability.ml.sensitivity.transformation.SensitivityProperty;

public class SensitivityAggregations {
    private static final double PROPERTY_OCCURENCE_COUNT = 1.0;
    private final Map<PropertyMeasure.MeasurableSensitivityProperty, Double> propertySensitivityAggregations = Maps.newHashMap();
    private final Map<MLSensitivityEntry, MLSensitivityValue> mlSensitivityAggregations = Maps.newHashMap();
    private int globalCount = 0;

    public void record(Set<PropertyMeasure.MeasurableSensitivityProperty> measuredProperties, double predictionAccuracy) {
        measuredProperties.forEach(this::updatePropertySensitivity);
        this.updateMLSensitivity(MLSensitivityEntry.from(measuredProperties), predictionAccuracy);
        this.incrementGlobalCounter();
    }

    public Set<String> getMeasurablePropertyIds() {
        return this.groupMeasurableProperties().keySet();
    }

    public Map<MLSensitivityEntry, Double> getMLSensitivityValues() {
        return this.mlSensitivityAggregations.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, this.normalizeAggregatedValues()));
    }

    public Map<PropertyMeasure.MeasurableSensitivityProperty, Double> getPropertySensitivityValues(String propertyName) {
        return this.groupMeasurableProperties().get(propertyName).stream().collect(Collectors.toMap(Function.identity(), this::normalizeAggregatedValues));
    }

    private Double normalizeAggregatedValues(PropertyMeasure.MeasurableSensitivityProperty property) {
        Double value = Optional.ofNullable(this.propertySensitivityAggregations.get(property)).orElseThrow(MLSensitivityAnalysisException.supplierWithMessage(String.format("There is no local sensitivity value for property %s", property.getId())));
        return value / (double)this.globalCount;
    }

    private Function<Map.Entry<MLSensitivityEntry, MLSensitivityValue>, Double> normalizeAggregatedValues() {
        return e -> ((MLSensitivityValue)e.getValue()).computeNormalizedAggregatedValue();
    }

    private Map<String, List<PropertyMeasure.MeasurableSensitivityProperty>> groupMeasurableProperties() {
        return this.propertySensitivityAggregations.keySet().stream().collect(Collectors.groupingBy(SensitivityProperty::getId));
    }

    private void updatePropertySensitivity(PropertyMeasure.MeasurableSensitivityProperty property) {
        this.propertySensitivityAggregations.merge(property, 1.0, Double::sum);
    }

    private void updateMLSensitivity(MLSensitivityEntry entry, double value) {
        this.mlSensitivityAggregations.merge(entry, new MLSensitivityValue(value), MLSensitivityValue::incrementalUpdate);
    }

    private void incrementGlobalCounter() {
        ++this.globalCount;
    }

    public static class MLSensitivityEntry {
        public static final String SIGNATURE_DELIMITER = ",";
        private final String signature;

        private MLSensitivityEntry(List<PropertyMeasure.MeasurableSensitivityProperty> properties) {
            this.signature = MLSensitivityEntry.constructSignatureFrom(properties);
        }

        public static MLSensitivityEntry from(Set<PropertyMeasure.MeasurableSensitivityProperty> properties) {
            return new MLSensitivityEntry(Lists.newArrayList(properties));
        }

        public static MLSensitivityEntry from(List<PropertyMeasure.MeasurableSensitivityProperty> properties) {
            return new MLSensitivityEntry(properties);
        }

        private static String constructSignatureFrom(List<PropertyMeasure.MeasurableSensitivityProperty> properties) {
            StringBuilder builder = new StringBuilder();
            for (PropertyMeasure.MeasurableSensitivityProperty each : MLSensitivityEntry.orderAlphabeticallyByName(properties)) {
                builder.append(each.getValue().toString()).append(SIGNATURE_DELIMITER);
            }
            builder.deleteCharAt(builder.lastIndexOf(SIGNATURE_DELIMITER));
            return builder.toString();
        }

        private static List<PropertyMeasure.MeasurableSensitivityProperty> orderAlphabeticallyByName(List<PropertyMeasure.MeasurableSensitivityProperty> properties) {
            properties.sort((p1, p2) -> p1.getId().compareTo(p2.getId()));
            return properties;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MLSensitivityEntry) {
                return ((MLSensitivityEntry)MLSensitivityEntry.class.cast((Object)obj)).signature.equals(this.signature);
            }
            return false;
        }

        public int hashCode() {
            return this.signature.hashCode();
        }

        public List<String> getSignatureComponents() {
            return Lists.newArrayList((Object[])this.signature.split(SIGNATURE_DELIMITER));
        }
    }

    private static class MLSensitivityValue {
        private double sensitivity;
        private int occurenceCounter;

        public MLSensitivityValue(double initial) {
            this.sensitivity = initial;
            this.occurenceCounter = 1;
        }

        public MLSensitivityValue incrementalUpdate(MLSensitivityValue newValue) {
            this.sensitivity += newValue.sensitivity;
            ++this.occurenceCounter;
            return this;
        }

        public double computeNormalizedAggregatedValue() {
            return this.sensitivity / (double)this.occurenceCounter;
        }
    }
}

