/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.ml.sensitivity.api;

import com.google.common.collect.Lists;
import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.palladiosimulator.dependability.ml.model.TrainedModel;
import org.palladiosimulator.dependability.ml.sensitivity.analysis.MLSensitivityAnalysisStrategy;
import org.palladiosimulator.dependability.ml.sensitivity.api.MLSensitivityAnalyser;
import org.palladiosimulator.dependability.ml.sensitivity.exception.MLSensitivityAnalysisException;
import org.palladiosimulator.dependability.ml.sensitivity.transformation.PropertyMeasure;
import org.palladiosimulator.dependability.ml.sensitivity.util.ResourceUtil;

public class SensitivityAnalysisConfig {
    private final TrainedModel trainedModel;
    private final File trainDataLocation;
    private final URI sensModelStoringLocation;
    private final URI trainedModelURI;
    private final MLSensitivityAnalysisStrategy analysisStrategy;
    private final List<PropertyMeasure> propertyMeasures;

    private SensitivityAnalysisConfig(TrainedModel trainedModel, File trainDataLocation, URI trainedModelURI, MLSensitivityAnalysisStrategy analysisStrategy, List<PropertyMeasure> propertyMeasures, URI sensModelStoringLocation) {
        this.trainedModel = trainedModel;
        this.trainDataLocation = trainDataLocation;
        this.trainedModelURI = trainedModelURI;
        this.analysisStrategy = analysisStrategy;
        this.propertyMeasures = propertyMeasures;
        this.sensModelStoringLocation = sensModelStoringLocation;
    }

    public static SensitivityAnalysisConfigBuilder newBuilder() {
        return new SensitivityAnalysisConfigBuilder();
    }

    public TrainedModel getTrainedModel() {
        return this.trainedModel;
    }

    public File getTrainDataLocation() {
        return this.trainDataLocation;
    }

    public URI getTrainedModelURI() {
        return this.trainedModelURI;
    }

    public MLSensitivityAnalysisStrategy getAnalysisStrategy() {
        return this.analysisStrategy;
    }

    public List<PropertyMeasure> getPropertyMeasures() {
        return this.propertyMeasures;
    }

    public URI getSensitivityModelStoringLocation() {
        return this.sensModelStoringLocation;
    }

    public static class SensitivityAnalysisConfigBuilder {
        private String trainedModel = null;
        private String trainDataLocation = null;
        private String trainedModelURI = null;
        private String analysisStrategy = null;
        private String sensModelStoringLocation = null;
        private List<String> sensitivityProperties = Lists.newArrayList();

        public SensitivityAnalysisConfigBuilder modelToAnalyse(String trainedModel) {
            this.trainedModel = trainedModel;
            return this;
        }

        public SensitivityAnalysisConfigBuilder locatedAt(String trainedModelURI) {
            this.trainedModelURI = trainedModelURI;
            return this;
        }

        public SensitivityAnalysisConfigBuilder andTrainedWith(String trainDataLocation) {
            this.trainDataLocation = trainDataLocation;
            return this;
        }

        public SensitivityAnalysisConfigBuilder analyseProperties(List<String> sensitivityProperties) {
            this.sensitivityProperties.addAll(sensitivityProperties);
            return this;
        }

        public SensitivityAnalysisConfigBuilder withStrategy(String analysisStrategy) {
            this.analysisStrategy = analysisStrategy;
            return this;
        }

        public SensitivityAnalysisConfigBuilder storeSensitivityModelAt(String sensModelStoringLocation) {
            this.sensModelStoringLocation = sensModelStoringLocation;
            return this;
        }

        public SensitivityAnalysisConfig build() {
            TrainedModel trainedModel = this.retrieveTrainedModel();
            File trainDataLocation = this.convertTrainDataLocation();
            URI trainedModelFile = this.convertTrainedModelFile();
            URI sensModelStoringLocation = this.convertSensitivityModelStoringLocation();
            MLSensitivityAnalysisStrategy analysisStrategy = this.retrieveAnalysisStrategy();
            List<PropertyMeasure> propertyMeasures = this.retrievePropertyMeasures();
            return new SensitivityAnalysisConfig(trainedModel, trainDataLocation, trainedModelFile, analysisStrategy, propertyMeasures, sensModelStoringLocation);
        }

        private URI convertSensitivityModelStoringLocation() {
            this.checkValidity(this.sensModelStoringLocation);
            return ResourceUtil.asURI(this.sensModelStoringLocation);
        }

        private TrainedModel retrieveTrainedModel() {
            this.checkValidity(this.trainedModel);
            return MLSensitivityAnalyser.findAnalysableModelWith(this.trainedModel).orElseThrow(MLSensitivityAnalysisException.supplierWithMessage(String.format("There is no ml model with name: %s", this.trainedModel)));
        }

        private File convertTrainDataLocation() {
            this.checkValidity(this.trainDataLocation);
            File location = ResourceUtil.asFile(this.trainDataLocation);
            if (!location.exists()) {
                MLSensitivityAnalysisException.throwWithMessage(String.format("The training data location is not properly formatted: %s", this.trainDataLocation));
            }
            return location;
        }

        private URI convertTrainedModelFile() {
            this.checkValidity(this.trainedModelURI);
            return ResourceUtil.asURI(this.trainedModelURI);
        }

        private MLSensitivityAnalysisStrategy retrieveAnalysisStrategy() {
            this.checkValidity(this.analysisStrategy);
            return MLSensitivityAnalyser.findAnalysisStrategyWith(this.analysisStrategy).orElseThrow(MLSensitivityAnalysisException.supplierWithMessage(String.format("There is no strategy with name: %s", this.analysisStrategy)));
        }

        private List<PropertyMeasure> retrievePropertyMeasures() {
            if (this.sensitivityProperties.isEmpty()) {
                MLSensitivityAnalysisException.throwWithMessage("At least one property must be specified.");
            }
            return this.sensitivityProperties.stream().map(name -> this.retrievePropertyMeasure((String)name)).collect(Collectors.toList());
        }

        private PropertyMeasure retrievePropertyMeasure(String name) {
            this.checkValidity(name);
            return MLSensitivityAnalyser.findAnalysablePropertyMeasureWith(name).orElseThrow(MLSensitivityAnalysisException.supplierWithMessage(String.format("There is no property measure with name: %s", name)));
        }

        private void checkValidity(String value) {
            if (Boolean.logicalOr(Objects.isNull(value), value.isBlank())) {
                MLSensitivityAnalysisException.throwWithMessage(String.format("Value %s is not properly specified.", value));
            }
        }
    }
}

