/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.ml.sensitivity.builder;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.dependability.ml.sensitivity.exception.MLSensitivityAnalysisException;
import org.palladiosimulator.dependability.ml.sensitivity.transformation.PropertyMeasure;
import org.palladiosimulator.dependability.ml.sensitivity.transformation.property.conversion.SensitivityPropertyConventions;
import org.palladiosimulator.envdyn.environment.staticmodel.GroundProbabilisticModel;
import org.palladiosimulator.envdyn.environment.staticmodel.GroundProbabilisticNetwork;
import org.palladiosimulator.envdyn.environment.staticmodel.GroundRandomVariable;
import org.palladiosimulator.envdyn.environment.staticmodel.LocalProbabilisticNetwork;
import org.palladiosimulator.envdyn.environment.staticmodel.ProbabilisticModelRepository;
import org.palladiosimulator.envdyn.environment.staticmodel.StaticmodelFactory;
import org.palladiosimulator.envdyn.environment.templatevariable.DependenceRelation;
import org.palladiosimulator.envdyn.environment.templatevariable.DependenceType;
import org.palladiosimulator.envdyn.environment.templatevariable.ProbabilisticTemplateFactor;
import org.palladiosimulator.envdyn.environment.templatevariable.Relation;
import org.palladiosimulator.envdyn.environment.templatevariable.TemplateFactor;
import org.palladiosimulator.envdyn.environment.templatevariable.TemplateVariable;
import org.palladiosimulator.envdyn.environment.templatevariable.TemplateVariableDefinitions;
import org.palladiosimulator.envdyn.environment.templatevariable.TemplatevariableFactory;
import tools.mdsd.probdist.distributiontype.ProbabilityDistributionSkeleton;
import tools.mdsd.probdist.model.basic.loader.BasicDistributionTypesLoader;

public class ProbabilisticSensitivityModelBuilder {
    private static final String MULTINOMIAL_DIST_SKELETON = "MultinomialDistribution";
    private static final String ML_TEMPLATE_NAME = "MLPredictionSensitivityTemplate";
    private static final String ML_VARIABLE_NAME = "MLPredictionSensitivity";
    private static final String ML_FACTOR_NAME = "MLPredictionSensitivityFactor";
    private static final String FACTOR_SUFFIX = "Factor";
    private static final String VARIABLE_NAME_SUFFIX = "Sensitivity";
    private static final String ML_NETWORK_NAME = "MLPredictionSensitivityModel";
    private static final String INSTANTIATION_FACTOR_SUFFIX = "Model";
    private final TemplatevariableFactory templateFactory = TemplatevariableFactory.eINSTANCE;
    private final StaticmodelFactory staticModelFactory = StaticmodelFactory.eINSTANCE;
    private final ProbabilisticModelRepository networkRepo = this.staticModelFactory.createProbabilisticModelRepository();
    private final TemplateVariableDefinitions templateDefinitions = this.templateFactory.createTemplateVariableDefinitions();
    private TemplateVariable mlTemplate = null;
    private GroundRandomVariable mlVariable = null;

    private ProbabilisticSensitivityModelBuilder() {
        this.buildInitialStructure();
    }

    public static ProbabilisticSensitivityModelBuilder get() {
        return new ProbabilisticSensitivityModelBuilder();
    }

    public ProbabilisticSensitivityModelBuilder addSensitivityFactor(PropertyMeasure propertyMeasure) {
        String name = SensitivityPropertyConventions.convertToTemplateVariableName(propertyMeasure);
        TemplateVariable template = this.buildTemplateWith(name);
        this.addToTemplateDefinitions(template);
        this.adjustMLFactorScope(template);
        TemplateFactor factor = this.buildTemplateFactor(template, name.concat(FACTOR_SUFFIX));
        this.addToTemplateDefinitions(factor);
        DependenceRelation dependencyRelation = this.buildDependencyRelationToMLTemplate(template);
        this.addToTemplateDefinitions((Relation)dependencyRelation);
        this.adjustMLDependencyStructure(dependencyRelation);
        GroundRandomVariable groundVariable = this.instantiateTemplate(template, name.concat(VARIABLE_NAME_SUFFIX));
        this.addToGroundNetwork(groundVariable);
        GroundProbabilisticModel instantiatedFactor = this.instantiateFactor(factor, name.concat(INSTANTIATION_FACTOR_SUFFIX));
        this.addToGroundNetwork(instantiatedFactor);
        groundVariable.setDescriptiveModel(instantiatedFactor);
        return this;
    }

    public List<EObject> build() {
        return Lists.newArrayList((Object[])new EObject[]{this.networkRepo, this.templateDefinitions});
    }

    private DependenceRelation buildDependencyRelationToMLTemplate(TemplateVariable source) {
        DependenceRelation dependencyRelation = this.templateFactory.createDependenceRelation();
        dependencyRelation.setType(DependenceType.DIRECTED);
        dependencyRelation.setSource(source);
        dependencyRelation.setTarget(this.mlTemplate);
        return dependencyRelation;
    }

    private void adjustMLFactorScope(TemplateVariable template) {
        for (TemplateFactor each : this.templateDefinitions.getFactors()) {
            if (!each.getScope().contains((Object)this.mlTemplate)) continue;
            each.getScope().add((Object)template);
            return;
        }
        MLSensitivityAnalysisException.throwWithMessage("There is no ML variable template.");
    }

    private void adjustMLDependencyStructure(DependenceRelation relation) {
        this.mlVariable.getDependenceStructure().add((Object)relation);
    }

    private void buildInitialStructure() {
        this.mlTemplate = this.buildMLTemplate();
        this.addToTemplateDefinitions(this.mlTemplate);
        TemplateFactor mlFactor = this.buildMLFactor(this.mlTemplate);
        this.addToTemplateDefinitions(mlFactor);
        this.buildAndAddGroundProbabilisticNetwork();
        this.mlVariable = this.instantiateTemplate(this.mlTemplate, ML_VARIABLE_NAME);
        this.addToGroundNetwork(this.mlVariable);
        GroundProbabilisticModel mlInstantiatedFactor = this.instantiateFactor(mlFactor, ML_NETWORK_NAME);
        this.addToGroundNetwork(mlInstantiatedFactor);
        this.mlVariable.setDescriptiveModel(mlInstantiatedFactor);
    }

    private GroundProbabilisticModel instantiateFactor(TemplateFactor mlFactor, String name) {
        GroundProbabilisticModel groundModel = this.staticModelFactory.createGroundProbabilisticModel();
        groundModel.setEntityName(name);
        groundModel.setInstantiatedFactor(mlFactor);
        return groundModel;
    }

    private TemplateVariable buildMLTemplate() {
        return this.buildTemplateWith(ML_TEMPLATE_NAME);
    }

    private TemplateVariable buildTemplateWith(String name) {
        TemplateVariable mlTemplate = this.templateFactory.createTemplateVariable();
        mlTemplate.setEntityName(name);
        return mlTemplate;
    }

    private TemplateFactor buildMLFactor(TemplateVariable mlTemplate) {
        return this.buildTemplateFactor(mlTemplate, ML_FACTOR_NAME);
    }

    private TemplateFactor buildTemplateFactor(TemplateVariable mlTemplate, String name) {
        ProbabilisticTemplateFactor mlFactor = this.templateFactory.createProbabilisticTemplateFactor();
        mlFactor.setDistributionFamily(this.multinomialDistributionFamily());
        mlFactor.setEntityName(name);
        mlFactor.getScope().add((Object)mlTemplate);
        return mlFactor;
    }

    private void addToTemplateDefinitions(TemplateVariable template) {
        this.templateDefinitions.getVariables().add((Object)template);
    }

    private void addToTemplateDefinitions(TemplateFactor factor) {
        this.templateDefinitions.getFactors().add((Object)factor);
    }

    private void addToTemplateDefinitions(Relation relation) {
        this.templateDefinitions.getRelation().add((Object)relation);
    }

    private void buildAndAddGroundProbabilisticNetwork() {
        GroundProbabilisticNetwork groundNetwork = this.staticModelFactory.createGroundProbabilisticNetwork();
        groundNetwork.setEntityName(ML_NETWORK_NAME);
        this.networkRepo.getModels().add((Object)groundNetwork);
    }

    private GroundRandomVariable instantiateTemplate(TemplateVariable template, String name) {
        GroundRandomVariable randomVariable = this.staticModelFactory.createGroundRandomVariable();
        randomVariable.setEntityName(name);
        randomVariable.setInstantiatedTemplate(template);
        return randomVariable;
    }

    private ProbabilityDistributionSkeleton multinomialDistributionFamily() {
        return BasicDistributionTypesLoader.loadRepository().getDistributionFamilies().stream().filter(each -> each.getEntityName().equals(MULTINOMIAL_DIST_SKELETON)).findFirst().get();
    }

    private void addToGroundNetwork(GroundRandomVariable groundVariable) {
        this.getOrCreateLocalModel().getGroundRandomVariables().add((Object)groundVariable);
    }

    private LocalProbabilisticNetwork getOrCreateLocalModel() {
        GroundProbabilisticNetwork groundNetwork = (GroundProbabilisticNetwork)this.networkRepo.getModels().get(0);
        if (groundNetwork.getLocalProbabilisticModels().isEmpty()) {
            groundNetwork.getLocalProbabilisticModels().add((Object)this.staticModelFactory.createLocalProbabilisticNetwork());
        }
        return (LocalProbabilisticNetwork)groundNetwork.getLocalProbabilisticModels().get(0);
    }

    private void addToGroundNetwork(GroundProbabilisticModel instantiatedFactor) {
        ((GroundProbabilisticNetwork)this.networkRepo.getModels().get(0)).getLocalModels().add((Object)instantiatedFactor);
    }
}

