/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.ml.sensitivity.builder;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.palladiosimulator.dependability.ml.sensitivity.analysis.SensitivityAggregations;
import org.palladiosimulator.dependability.ml.sensitivity.analysis.SensitivityModel;
import org.palladiosimulator.dependability.ml.sensitivity.exception.MLSensitivityAnalysisException;
import org.palladiosimulator.dependability.ml.sensitivity.transformation.SensitivityProperty;
import tools.mdsd.probdist.distributionfunction.DistributionfunctionFactory;
import tools.mdsd.probdist.distributionfunction.ParamRepresentation;
import tools.mdsd.probdist.distributionfunction.Parameter;
import tools.mdsd.probdist.distributionfunction.ParameterType;
import tools.mdsd.probdist.distributionfunction.ProbabilityDistribution;
import tools.mdsd.probdist.distributionfunction.ProbabilityDistributionFunctionRepository;
import tools.mdsd.probdist.distributionfunction.SimpleParameter;
import tools.mdsd.probdist.distributionfunction.TabularCPD;
import tools.mdsd.probdist.distributionfunction.TabularCPDEntry;
import tools.mdsd.probdist.distributiontype.ParameterSignature;
import tools.mdsd.probdist.distributiontype.ProbabilityDistributionSkeleton;
import tools.mdsd.probdist.model.basic.loader.BasicDistributionTypesLoader;

public class ProbabilityDistributionBuilder {
    private static final String MULTINOMIAL_DIST_SKELETON = "MultinomialDistribution";
    private static final String DIST_NAME_SUFFIX = "SensitivityDistribution";
    private static final String ML_DIST_NAME = "MLPrediction";
    private static final String PARAM_NAME = "SensitivityParam";
    private static final DistributionfunctionFactory FACTORY = DistributionfunctionFactory.eINSTANCE;
    private ProbabilityDistributionSkeleton skeleton = null;
    private Map<SensitivityProperty, Double> propertySensitivityValues = null;
    private Map<SensitivityAggregations.MLSensitivityEntry, Double> mlSensitivityValues = null;
    private String name = null;

    private ProbabilityDistributionBuilder(String name) {
        this.name = name + DIST_NAME_SUFFIX;
        this.skeleton = BasicDistributionTypesLoader.loadRepository().getDistributionFamilies().stream().filter(each -> each.getEntityName().equals(MULTINOMIAL_DIST_SKELETON)).findFirst().get();
    }

    public static ProbabilityDistributionFunctionRepository mergeToSingleRepository(Set<ProbabilityDistribution> distributions) {
        ProbabilityDistributionFunctionRepository repo = FACTORY.createProbabilityDistributionFunctionRepository();
        for (ProbabilityDistribution each : distributions) {
            repo.getDistributions().add((Object)each);
            repo.getParams().addAll((Collection)each.getParams());
        }
        return repo;
    }

    public static ProbabilityDistributionBuilder buildProbabilityDistributionFor(SensitivityProperty property) {
        return new ProbabilityDistributionBuilder(property.getId());
    }

    public static ProbabilityDistributionBuilder buildProbabilityDistributionForMLVariable() {
        return new ProbabilityDistributionBuilder(ML_DIST_NAME);
    }

    public ProbabilityDistributionBuilder withSimpleParameterDerivedFrom(Map<SensitivityProperty, Double> sensitivityValues) {
        this.propertySensitivityValues = sensitivityValues;
        return this;
    }

    public ProbabilityDistributionBuilder withTabularParameterDerivedFrom(Map<SensitivityAggregations.MLSensitivityEntry, Double> sensitivityValues) {
        this.mlSensitivityValues = sensitivityValues;
        return this;
    }

    public ProbabilityDistribution build() {
        this.checkValidity();
        Object paramRep = Objects.nonNull(this.mlSensitivityValues) ? this.buildTabularParam() : this.buildSimpleParam(this.parseToSampleSpace(this.propertySensitivityValues));
        Parameter defaultParameter = this.buildDefaultParameterWith((ParamRepresentation)paramRep);
        return this.buildDistribution(defaultParameter);
    }

    private void checkValidity() {
        if (Boolean.logicalAnd(Objects.isNull(this.mlSensitivityValues), Objects.isNull(this.propertySensitivityValues))) {
            MLSensitivityAnalysisException.throwWithMessage("There are no ML as well as property sensitivity values specified.");
        }
    }

    private TabularCPD buildTabularParam() {
        TabularCPD tabularCPD = FACTORY.createTabularCPD();
        for (SensitivityAggregations.MLSensitivityEntry eachEntry : this.mlSensitivityValues.keySet()) {
            TabularCPDEntry tabularCPDEntry = FACTORY.createTabularCPDEntry();
            for (String eachSignatureComponent : eachEntry.getSignatureComponents()) {
                tabularCPDEntry.getConditonals().add((Object)eachSignatureComponent);
            }
            String param = this.parseAsProbOfSuccessParam(this.mlSensitivityValues.get(eachEntry));
            tabularCPDEntry.setEntry(this.buildSimpleParam(param));
            tabularCPD.getCpdEntries().add((Object)tabularCPDEntry);
        }
        return tabularCPD;
    }

    private SimpleParameter buildSimpleParam(String stringRepresentation) {
        SimpleParameter param = FACTORY.createSimpleParameter();
        param.setType(ParameterType.SAMPLESPACE);
        param.setValue(stringRepresentation);
        return param;
    }

    private ProbabilityDistribution buildDistribution(Parameter defaultParameter) {
        ProbabilityDistribution distribution = FACTORY.createProbabilityDistribution();
        distribution.setInstantiated(this.skeleton);
        distribution.setEntityName(this.name);
        distribution.getParams().add((Object)defaultParameter);
        ProbabilityDistributionFunctionRepository defaultRepo = FACTORY.createProbabilityDistributionFunctionRepository();
        defaultRepo.getDistributions().add((Object)distribution);
        defaultRepo.getParams().add((Object)defaultParameter);
        return distribution;
    }

    private Parameter buildDefaultParameterWith(ParamRepresentation paramRep) {
        Parameter defaultParameter = FACTORY.createParameter();
        defaultParameter.setInstantiated(this.getEventProbabilityStructure());
        defaultParameter.setRepresentation(paramRep);
        defaultParameter.setEntityName(PARAM_NAME);
        return defaultParameter;
    }

    private ParameterSignature getEventProbabilityStructure() {
        return (ParameterSignature)this.skeleton.getParamStructures().get(0);
    }

    private String parseToSampleSpace(Map<SensitivityProperty, Double> sensitivityValues) {
        Map<String, String> sampleSpace = sensitivityValues.entrySet().stream().collect(Collectors.toMap(entry -> ((SensitivityProperty)entry.getKey()).getValue().toString(), entry -> ((Double)entry.getValue()).toString()));
        return this.parseToString(sampleSpace);
    }

    private String parseAsProbOfSuccessParam(Double probOfSuccess) {
        HashMap sampleSpace = Maps.newHashMap();
        sampleSpace.put(SensitivityModel.MLOutcomeMeasure.SUCCESS.toString(), probOfSuccess.toString());
        sampleSpace.put(SensitivityModel.MLOutcomeMeasure.FAIL.toString(), Double.toString(1.0 - probOfSuccess));
        return this.parseToString(sampleSpace);
    }

    private String parseToString(Map<String, String> sampleSpace) {
        StringBuilder builder = new StringBuilder();
        for (String eachCategory : sampleSpace.keySet()) {
            builder.append(String.format("{%1s,%2s};", eachCategory, sampleSpace.get(eachCategory)));
        }
        return builder.deleteCharAt(builder.length() - 1).toString();
    }
}

