/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.ml.sensitivity.analysis;

import java.io.File;
import java.util.Objects;
import org.palladiosimulator.dependability.ml.model.TrainedModel;
import org.palladiosimulator.dependability.ml.sensitivity.analysis.SensitivityModel;
import org.palladiosimulator.dependability.ml.sensitivity.exception.MLSensitivityAnalysisException;

public class MLAnalysisContext {
    private final TrainedModel trainedModel;
    private final File trainingData;
    private final SensitivityModel sensitivityModel;

    private MLAnalysisContext(TrainedModel trainedModel, File trainingData, SensitivityModel sensitivityModel) {
        this.trainedModel = trainedModel;
        this.trainingData = trainingData;
        this.sensitivityModel = sensitivityModel;
    }

    public static MLAnalysisContextBuilder newBuilder() {
        return new MLAnalysisContextBuilder();
    }

    public TrainedModel getMLModel() {
        return this.trainedModel;
    }

    public File getTrainingData() {
        return this.trainingData;
    }

    public SensitivityModel getSensitivityModel() {
        return this.sensitivityModel;
    }

    public static class MLAnalysisContextBuilder {
        TrainedModel trainedModel;
        private File trainingData = null;
        private SensitivityModel sensitivityModel = null;

        public MLAnalysisContextBuilder analyseSensitivityOf(TrainedModel trainedModel) {
            this.trainedModel = trainedModel;
            return this;
        }

        public MLAnalysisContextBuilder trainedWith(File trainingData) {
            this.trainingData = trainingData;
            return this;
        }

        public MLAnalysisContextBuilder andCapturedBy(SensitivityModel sensitivityModel) {
            this.sensitivityModel = sensitivityModel;
            return this;
        }

        public MLAnalysisContext build() {
            Objects.requireNonNull(this.trainedModel, "The ML model to analyse must be specified.");
            Objects.requireNonNull(this.trainingData, "The training data location has to be specified.");
            Objects.requireNonNull(this.sensitivityModel, "The sensitivity model has to be specified.");
            if (!this.trainingData.exists()) {
                MLSensitivityAnalysisException.throwWithMessage("The data location does not exist.");
            }
            return new MLAnalysisContext(this.trainedModel, this.trainingData, this.sensitivityModel);
        }
    }
}

