/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.ml.sensitivity.transformation;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.palladiosimulator.dependability.ml.model.InputData;
import org.palladiosimulator.dependability.ml.sensitivity.transformation.PropertyMeasure;

public class AnalysisTransformation {
    private final Set<PropertyMeasure> propertyMeasures;

    public AnalysisTransformation(Set<PropertyMeasure> propertyMeasures) {
        this.propertyMeasures = propertyMeasures;
    }

    public Set<PropertyMeasure.MeasurableSensitivityProperty> computeMeasurableProperties(InputData inputData) {
        return this.propertyMeasures.stream().map(each -> each.apply(inputData)).collect(Collectors.toSet());
    }

    public Optional<PropertyMeasure> findPropertyMeasureWith(String propertId) {
        return this.propertyMeasures.stream().filter(each -> each.getId().equals(propertId)).findFirst();
    }

    public Set<List<PropertyMeasure.MeasurableSensitivityProperty>> computeMeasurableSpace() {
        ArrayList measurableSpace = Lists.newArrayList();
        for (PropertyMeasure eachMeasure : this.propertyMeasures) {
            HashSet propertySpace = Sets.newHashSet(eachMeasure.getMeasurablePropertySpace());
            measurableSpace.add(propertySpace);
        }
        return Sets.cartesianProduct((List)measurableSpace);
    }
}

