/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.ml.sensitivity.transformation.property;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import org.palladiosimulator.dependability.ml.model.InputData;
import org.palladiosimulator.dependability.ml.model.nn.ImageInputData;
import org.palladiosimulator.dependability.ml.sensitivity.exception.MLSensitivityAnalysisException;
import org.palladiosimulator.dependability.ml.sensitivity.transformation.PropertyMeasure;
import tools.mdsd.probdist.api.entity.CategoricalValue;

public class ImageBrightness
extends PropertyMeasure {
    private static final int HIGH_BRIGHTNESS_THRESHOLD = 175;
    private static final int MEDIUM_BRIGHTNESS_THRESHOLD = 75;
    private static final String PROPERTY_NAME = "Image brightness measure";
    private static final String PROPERTY_ID = "ImageBrightnessMeasure";
    private static final ImageBrightness INSTANCE = new ImageBrightness();

    private ImageBrightness() {
    }

    public static ImageBrightness get() {
        return INSTANCE;
    }

    @Override
    public PropertyMeasure.MeasurableSensitivityProperty apply(InputData inputData) {
        if (!this.isApplicableTo(inputData).booleanValue()) {
            MLSensitivityAnalysisException.throwWithMessage("Input data is not applicable to propertymeasure");
        }
        return this.computeBrightness((ImageInputData)inputData);
    }

    @Override
    public Boolean isApplicableTo(InputData inputData) {
        return inputData instanceof ImageInputData;
    }

    @Override
    public Set<PropertyMeasure.MeasurableSensitivityProperty> getMeasurablePropertySpace() {
        return BrightnessCategory.getValueSpace();
    }

    @Override
    public String getId() {
        return PROPERTY_ID;
    }

    private PropertyMeasure.MeasurableSensitivityProperty computeBrightness(ImageInputData inputData) {
        BufferedImage img = this.readImageToProcess(inputData);
        Map<Integer, Integer> grayscaleHist = this.computeGrayScaleHist(img);
        int meanGrayScale = this.computeMeanGrayScaleValue(grayscaleHist);
        if (this.isLowBrightness(meanGrayScale)) {
            return BrightnessCategory.LOW.asMeasurableProperty();
        }
        if (this.isMediumBrightness(meanGrayScale)) {
            return BrightnessCategory.MEDIUM.asMeasurableProperty();
        }
        return BrightnessCategory.HIGH.asMeasurableProperty();
    }

    private Map<Integer, Integer> computeGrayScaleHist(BufferedImage img) {
        HashMap grayscaleHist = Maps.newHashMap();
        int y = 0;
        while (y < img.getHeight()) {
            int x = 0;
            while (x < img.getWidth()) {
                int grayscale = this.computeGrayscaleValue(img.getRGB(x, y));
                grayscaleHist.merge(grayscale, 1, (v1, v2) -> v1 + v2);
                ++x;
            }
            ++y;
        }
        return grayscaleHist;
    }

    private int computeGrayscaleValue(int pixel) {
        int r = pixel >> 16 & 0xFF;
        int g = pixel >> 8 & 0xFF;
        int b = pixel & 0xFF;
        return (int)(0.33 * (double)b + 0.56 * (double)g + 0.11 * (double)r);
    }

    private int computeMeanGrayScaleValue(Map<Integer, Integer> grayscaleHist) {
        Integer totalCount = grayscaleHist.values().stream().reduce((v1, v2) -> v1 + v2).get();
        double meanGrayScale = 0.0;
        for (int eachGrayscaleValue : grayscaleHist.keySet()) {
            Integer relativeGrayscaleCount = grayscaleHist.get(eachGrayscaleValue);
            double relativeFrequency = (double)relativeGrayscaleCount.intValue() / (double)totalCount.intValue();
            meanGrayScale += (double)eachGrayscaleValue * relativeFrequency;
        }
        return (int)meanGrayScale;
    }

    private boolean isMediumBrightness(int meanGrayScale) {
        return Boolean.logicalAnd(meanGrayScale >= 75, meanGrayScale < 175);
    }

    private boolean isLowBrightness(int meanGrayScale) {
        return meanGrayScale < 75;
    }

    private BufferedImage readImageToProcess(ImageInputData inputData) {
        BufferedImage img = null;
        try {
            img = ImageIO.read(inputData.getImage());
        }
        catch (IOException e) {
            MLSensitivityAnalysisException.throwWithMessageAndCause("Something went wrong during brithness computation.", e);
        }
        return img;
    }

    @Override
    public String getName() {
        return PROPERTY_NAME;
    }

    private static enum BrightnessCategory {
        HIGH("High"),
        MEDIUM("Medium"),
        LOW("Low");

        private final PropertyMeasure.MeasurableSensitivityProperty value;

        private BrightnessCategory(String name) {
            this.value = INSTANCE.generateFromRaw(CategoricalValue.create((String)name));
        }

        public PropertyMeasure.MeasurableSensitivityProperty asMeasurableProperty() {
            return this.value;
        }

        public static Set<PropertyMeasure.MeasurableSensitivityProperty> getValueSpace() {
            return Sets.newHashSet((Object[])new PropertyMeasure.MeasurableSensitivityProperty[]{HIGH.asMeasurableProperty(), MEDIUM.asMeasurableProperty(), LOW.asMeasurableProperty()});
        }
    }
}

