/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.ml.sensitivity.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;

public class ResourceUtil {
    public static final String RESOURCE_PLATFORM_URI = "platform:/resource/";

    public static File asFile(String path) {
        return new File(ResourceUtil.formatPath(path));
    }

    public static java.net.URI asURI(String path) {
        if (ResourceUtil.isValidURL(path)) {
            return ResourceUtil.asURL(path).get();
        }
        return java.net.URI.create(ResourceUtil.formatPath(path));
    }

    private static Optional<java.net.URI> asURL(String path) {
        try {
            return Optional.of(new URL(path).toURI());
        }
        catch (MalformedURLException | URISyntaxException e) {
            return Optional.empty();
        }
    }

    private static boolean isValidURL(String path) {
        if (path.startsWith(RESOURCE_PLATFORM_URI)) {
            return false;
        }
        return ResourceUtil.asURL(path).isPresent();
    }

    private static String formatPath(String path) {
        if (path.startsWith(RESOURCE_PLATFORM_URI)) {
            Path resolvedPath = new Path(URI.createURI((String)path).toPlatformString(true));
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)resolvedPath);
            path = file.getRawLocation().toString();
        } else {
            path = Path.fromOSString((String)path).toString();
        }
        return path;
    }
}

