/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.dependability.ml.ui.launch;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.palladiosimulator.dependability.ml.sensitivity.api.MLSensitivityAnalyser;
import org.palladiosimulator.dependability.ml.sensitivity.api.SensitivityAnalysisConfig;
import tools.mdsd.probdist.api.factory.IProbabilityDistributionFactory;
import tools.mdsd.probdist.api.factory.ProbabilityDistributionFactory;

public class MLSensitivityLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        ProbabilityDistributionFactory defaultProbabilityDistributionFactory;
        String trainedModel = configuration.getAttribute("org.palladiosimulator.dependability.ml.ui.model", "");
        String trainedModelFile = configuration.getAttribute("org.palladiosimulator.dependability.ml.ui.modelurl", "");
        String trainDataLocation = configuration.getAttribute("org.palladiosimulator.dependability.ml.ui.traindata", "");
        String analysisStrategy = configuration.getAttribute("org.palladiosimulator.dependability.ml.ui.strategy", "");
        String sensModelStoringLocation = configuration.getAttribute("org.palladiosimulator.dependability.ml.ui.sensmodel", "");
        ArrayList sensitivityProperties = Lists.newArrayList();
        for (String each : configuration.getAttributes().keySet()) {
            if (!each.startsWith("org.palladiosimulator.dependability.ml.ui.property")) continue;
            sensitivityProperties.add(configuration.getAttribute(each, ""));
        }
        SensitivityAnalysisConfig config = SensitivityAnalysisConfig.newBuilder().modelToAnalyse(trainedModel).locatedAt(trainedModelFile).andTrainedWith(trainDataLocation).analyseProperties((List)sensitivityProperties).withStrategy(analysisStrategy).storeSensitivityModelAt(sensModelStoringLocation).build();
        ProbabilityDistributionFactory probabilityDistributionFactory = defaultProbabilityDistributionFactory = new ProbabilityDistributionFactory(Optional.empty());
        MLSensitivityAnalyser.analyseAndSave((SensitivityAnalysisConfig)config, (IProbabilityDistributionFactory)probabilityDistributionFactory, Optional.empty());
    }
}

